/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitProgram;
import com.caucho.jca.ConnectionPool;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.jca.cfg.ConnectionDefinition;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.jca.cfg.ObjectConfig;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class ConnectorResource
implements EnvironmentListener {
    private static L10N L = new L10N(ConnectorResource._resin_compat_class_0());
    private static Logger log = Log.open(ConnectorResource._resin_compat_class_0());
    private static int _idGen;
    private String _name;
    private String _type;
    private ResourceArchive _rar;
    private ResourceAdapterConfig _resourceAdapter = new ResourceAdapterConfig();
    private InitProgram _resourceAdapterInit;
    private ArrayList<ConnectionFactory> _outboundList = new ArrayList();
    private ArrayList<ConnectionListener> _inboundList = new ArrayList();
    private ArrayList<ConnectionResource> _resourceList = new ArrayList();
    private ResourceAdapter _ra;
    private boolean _isInitRA;
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(String type) throws Exception {
        this._type = type;
        this._rar = ResourceArchiveManager.findResourceArchive(this._type);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this._rar != null) {
            com.caucho.jca.cfg.ResourceAdapterConfig raConfig = this._rar.getResourceAdapter();
            if (this._name == null) {
                this._name = new CharBuffer().append(this._rar.getDisplayName()).append("-").append(_idGen++).toString();
            }
            if (raConfig.getType() != null) {
                this._ra = (ResourceAdapter)raConfig.instantiate();
            }
        } else {
            try {
                Class<?> raClass = Class.forName(this._type, false, loader);
                this._ra = (ResourceAdapter)raClass.newInstance();
            }
            catch (Throwable e) {
                throw new ConfigException(L.l("`{0}' is not a known connector.  The type must match the resource adaptor or managed connection factory of one of the installed *.rar files or specify a ResourceAdapter implementation.", this._type));
            }
        }
    }

    public String getType() {
        return this._type;
    }

    public ResourceAdapterConfig createResourceAdapter() throws ConfigException {
        if (this._ra == null) {
            throw new ConfigException(L.l("`{0}' may not have a <resource-adapter> section.  Old-style connectors must use <connection-factory>, but not <resource-adapter>.", this._type));
        }
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapterConfig raConfig) throws Throwable {
        if (raConfig.getInit() != null) {
            raConfig.getInit().configure(this._ra);
        }
        this.initRA();
        if (raConfig.getName() != null) {
            Jndi.bindDeepShort(raConfig.getName(), this._ra);
        }
    }

    public ConnectionFactory createConnectionFactory() throws Throwable {
        this.initRA();
        return new ConnectionFactory();
    }

    public void addConnectionFactory(ConnectionFactory factory) throws Throwable {
        ManagedConnectionFactory managedFactory = factory.getFactory();
        if (factory.getInit() != null) {
            factory.getInit().configure(managedFactory);
        }
        if (this._ra != null) {
            managedFactory.setResourceAdapter(this._ra);
        }
        this.initRA();
        ResourceManagerImpl rm = ResourceManagerImpl.createLocalManager();
        ConnectionPool cm = rm.createConnectionPool();
        if (this._name != null) {
            cm.setName(this._name);
        }
        if (this._rar != null) {
            String trans = this._rar.getTransactionSupport();
            if (trans == null) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("XATransaction")) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("NoTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(false);
            } else if (trans.equals("LocalTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(true);
            }
        }
        cm.setLocalTransactionOptimization(factory.getLocalTransactionOptimization());
        cm.setShareable(factory.getShareable());
        Object connectionFactory = cm.init(managedFactory);
        cm.start();
        if (factory.getName() != null) {
            Jndi.bindDeepShort(factory.getName(), connectionFactory);
        }
    }

    public ConnectionListener createMessageListener() throws Exception {
        this.initRA();
        return new ConnectionListener();
    }

    public void addMessageListener(ConnectionListener listener) throws Throwable {
        ActivationSpec activationSpec;
        this._inboundList.add(listener);
        String listenerType = listener.getType();
        if (this._ra == null) {
            throw new ConfigException(L.l("message-listener requires a resource-adapter."));
        }
        if (this._rar != null) {
            MessageListenerConfig objectCfg = this._rar.getMessageListener(listenerType);
            if (objectCfg == null) {
                throw new ConfigException(L.l("`{0}' is an unknown type of <connection-listener> for `{1}'.  The connector has no matching inbound connection-listener.", (Object)listenerType, this._type));
            }
            activationSpec = (ActivationSpec)objectCfg.instantiate();
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> listenerClass = null;
            try {
                listenerClass = Class.forName(listenerType, false, loader);
            }
            catch (Throwable e) {
                throw new ConfigException(L.l("`{0}' is not a known listener.  The type must match the activation spec for an inbound connection of one of the installed *.rar files or specify an ActivationSpec implementation.", listenerType), e);
            }
            activationSpec = (ActivationSpec)listenerClass.newInstance();
        }
        if (listener.getInit() != null) {
            listener.getInit().configure(activationSpec);
        }
        activationSpec.setResourceAdapter(this._ra);
        EndpointFactory endpointFactoryCfg = listener.getEndpointFactory();
        if (endpointFactoryCfg == null) {
            throw new ConfigException(L.l("connection-listener needs endpoint factory."));
        }
        Class endpointClass = endpointFactoryCfg.getType();
        MessageEndpointFactory endpointFactory = (MessageEndpointFactory)endpointClass.newInstance();
        if (endpointFactoryCfg.getInit() != null) {
            endpointFactoryCfg.getInit().configure(endpointFactory);
        }
        Config.init(endpointFactory);
        listener.setEndpoint(endpointFactory);
        listener.setActivation(activationSpec);
    }

    public ConnectionResource createResource() {
        return new ConnectionResource();
    }

    public void addResource(ConnectionResource resource) throws Throwable {
        Object resourceObject = resource.getObject();
        if (resource.getInit() != null) {
            resource.getInit().configure(resourceObject);
        }
        if (this._ra != null && resourceObject instanceof ResourceAdapterAssociation) {
            ((ResourceAdapterAssociation)resourceObject).setResourceAdapter(this._ra);
        }
        if (resource.getName() != null) {
            Jndi.bindDeepShort(resource.getName(), resourceObject);
        }
    }

    public void init() throws Exception {
        if (this._type == null) {
            throw new ConfigException(L.l("<connector> requires a <type>."));
        }
        this.initRA();
        Environment.addEnvironmentListener(this);
        this.start();
        log.info(new CharBuffer().append("Connector[").append(this._type).append("] initialized").toString());
    }

    public void start() throws Exception {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this.initRA();
        for (int i = 0; i < this._inboundList.size(); ++i) {
            ConnectionListener listener = this._inboundList.get(i);
            this._ra.endpointActivation(listener.getEndpoint(), listener.getActivation());
        }
    }

    public void initRA() throws Exception {
        if (!this._isInitRA) {
            this._isInitRA = true;
            if (this._ra != null) {
                ResourceManagerImpl.addResource(this._ra);
            }
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        for (int i = 0; i < this._inboundList.size(); ++i) {
            ConnectionListener listener = this._inboundList.get(i);
            MessageEndpointFactory endpointFactory = listener.getEndpoint();
            ActivationSpec activation = listener.getActivation();
            if (this._ra == null) continue;
            this._ra.endpointDeactivation(endpointFactory, activation);
        }
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return new CharBuffer().append("ConnectorResource[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.ConnectorResource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class ConnectionResource {
        private String _name;
        private String _type;
        private InitProgram _init;
        private ObjectConfig _objectConfig;
        private Object _object;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) throws Exception {
            this._type = type;
            Object resourceObject = null;
            if (ConnectorResource.this._rar != null) {
                this._objectConfig = ConnectorResource.this._rar.getAdminObject(type);
                if (this._objectConfig == null) {
                    throw new ConfigException(L.l("`{0}' may not have a <resource> section.  The connector has no matching <adminobject> defined.", this._type));
                }
                this._object = this._objectConfig.instantiate();
            } else {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> resourceClass = Class.forName(type, false, loader);
                    this._object = resourceClass.newInstance();
                }
                catch (Throwable e) {
                    throw new ConfigException(L.l("`{0}' is not a known resource.  The type must match the adminobject of one of the installed *.rar files.", this._type), e);
                }
            }
        }

        public String getType() {
            return this._type;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public InitProgram getInit() {
            return this._init;
        }

        public Object getObject() {
            return this._object;
        }

        public void init() throws ConfigException {
            if (this._object == null) {
                throw new ConfigException(L.l("<type> must be set for a resource."));
            }
        }
    }

    public class EndpointFactory {
        private String _name;
        private Class _type;
        private InitProgram _init;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(Class type) throws ConfigException {
            this._type = type;
            Config.checkCanInstantiate(type);
        }

        public Class getType() {
            return this._type;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public InitProgram getInit() {
            return this._init;
        }
    }

    public class ConnectionListener {
        private String _name;
        private String _type;
        private InitProgram _init;
        private EndpointFactory _endpointFactory;
        private MessageEndpointFactory _endpoint;
        private ActivationSpec _activation;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public InitProgram getInit() {
            return this._init;
        }

        public EndpointFactory getEndpointFactory() {
            return this._endpointFactory;
        }

        public EndpointFactory createEndpointFactory() {
            this._endpointFactory = new EndpointFactory();
            return this._endpointFactory;
        }

        public void init() throws ConfigException {
            if (this._endpointFactory == null) {
                throw new ConfigException(L.l("connection-listener needs an endpoint-factory"));
            }
        }

        public void setEndpoint(MessageEndpointFactory endpoint) {
            this._endpoint = endpoint;
        }

        public MessageEndpointFactory getEndpoint() {
            return this._endpoint;
        }

        public void setActivation(ActivationSpec activation) {
            this._activation = activation;
        }

        public ActivationSpec getActivation() {
            return this._activation;
        }
    }

    public class ConnectionFactory {
        private String _name;
        private String _type;
        private ManagedConnectionFactory _factory;
        private boolean _localTransactionOptimization = true;
        private boolean _shareable = true;
        private InitProgram _init;
        private static Class _resin_compat_class_0;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) throws Exception {
            this._type = type;
            if (ConnectorResource.this._rar != null) {
                ConnectionDefinition factoryConfig = ConnectorResource.this._rar.getConnectionDefinition(type);
                if (factoryConfig == null) {
                    throw new ConfigException(L.l("`{0}' is an unknown type of <connection-factory> for `{1}'.  The connector has no matching outbound connection-factory.", (Object)type, ConnectorResource.this._type));
                }
                this._factory = (ManagedConnectionFactory)factoryConfig.instantiate();
            } else if (type != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(type, false, loader);
                }
                catch (Throwable e) {
                    throw new ConfigException(L.l("`{0}' is not a known connection factory.  The type must match the resource adaptor or managed connection factory of one of the installed *.rar files or specify a ManagedConnectionFactory implementation.", type));
                }
                if (!ConnectionFactory._resin_compat_class_0().isAssignableFrom(factoryClass)) {
                    throw new ConfigException(L.l("`{0}' does not implement javax.resource.spi.ManagedConnectionFactory.  <connection-factory> classes must implement ManagedConnectionFactory.", factoryClass.getName()));
                }
                this._factory = (ManagedConnectionFactory)factoryClass.newInstance();
            }
        }

        public String getType() {
            return this._type;
        }

        public void setLocalTransactionOptimization(boolean enable) {
            this._localTransactionOptimization = enable;
        }

        public boolean getLocalTransactionOptimization() {
            return this._localTransactionOptimization;
        }

        public void setShareable(boolean enable) {
            this._shareable = enable;
        }

        public boolean getShareable() {
            return this._shareable;
        }

        public ManagedConnectionFactory getFactory() {
            return this._factory;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public InitProgram getInit() {
            return this._init;
        }

        public void init() throws Exception {
            if (this._factory == null && ConnectorResource.this._rar != null) {
                ConnectionDefinition factoryConfig = ConnectorResource.this._rar.getConnectionDefinition(null);
                this._factory = (ManagedConnectionFactory)factoryConfig.instantiate();
            }
            if (this._factory == null) {
                throw new ConfigException(L.l("connection-factory requires a valid type."));
            }
        }

        private static Class _resin_compat_class_0() {
            try {
                Class<?> clazz = _resin_compat_class_0;
                if (clazz == null) {
                    clazz = _resin_compat_class_0 = Class.forName("javax.resource.spi.ManagedConnectionFactory");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public class ResourceAdapterConfig {
        private String _name;
        private InitProgram _init;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public InitProgram getInit() {
            return this._init;
        }
    }
}

