/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyComponent
extends ClassComponent {
    private static final L10N L = new L10N(DependencyComponent._resin_compat_class_0());
    private String _initMethod = "_caucho_init";
    private String _isModifiedMethod = "_caucho_is_modified";
    private Path _searchPath;
    private ArrayList<PersistentDependency> _dependList = new ArrayList();
    private static Class _resin_compat_class_0;

    public void setSearchPath(Path searchPath) {
        this._searchPath = searchPath;
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        out.println("private static com.caucho.make.Dependency []_caucho_depend;");
        out.println();
        out.println(new CharBuffer().append("public static void ").append(this._initMethod).append("(com.caucho.vfs.Path path)").toString());
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("_caucho_depend = new com.caucho.make.Dependency[").append(this._dependList.size()).append("];").toString());
        Path searchPath = this._searchPath;
        if (searchPath == null) {
            searchPath = JavaClassGenerator.getDefaultSearchPath();
        }
        for (int i = 0; i < this._dependList.size(); ++i) {
            PersistentDependency dependency = this._dependList.get(i);
            if (dependency instanceof Depend) {
                Depend depend = (Depend)this._dependList.get(i);
                Path path = depend.getPath();
                out.print(new CharBuffer().append("_caucho_depend[").append(i).append("] = new com.caucho.vfs.Depend(").toString());
                String relativePath = searchPath.lookup(path.getRelativePath()).getRelativePath();
                out.print(new CharBuffer().append("path.lookup(\"").append(relativePath).append("\"), ").toString());
                out.println(new CharBuffer().append(depend.getDigest()).append("L, ").append(depend.getRequireSource()).append(");").toString());
                continue;
            }
            out.print(new CharBuffer().append("_caucho_depend[").append(i).append("] = ").toString());
            out.print(dependency.getJavaCreateString());
            out.println(";");
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println(new CharBuffer().append("public static boolean ").append(this._isModifiedMethod).append("()").toString());
        out.println("{");
        out.pushDepth();
        this.printVersionChange(out);
        out.println("for (int i = _caucho_depend.length - 1; i >= 0; i--) {");
        out.println("  if (_caucho_depend[i].isModified())");
        out.println("    return true;");
        out.println("}");
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    protected void printVersionChange(JavaWriter out) throws IOException {
        out.println(new CharBuffer().append("if (com.caucho.util.CauchoSystem.getVersionId() != 0x").append(Long.toHexString(CauchoSystem.getVersionId())).append("L)").toString());
        out.println("  return true;");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.java.gen.DependencyComponent");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

