/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class BaseMethod
extends ClassComponent {
    private static final L10N L = new L10N(BaseMethod._resin_compat_class_0());
    private JMethod _method;
    private String _methodName;
    private boolean _isStatic;
    private String _visibility = "public";
    private JClass _returnType;
    private JClass[] _parameterTypes;
    private JClass[] _exceptionTypes;
    private CallChain _call;
    private static Class _resin_compat_class_0;

    public BaseMethod(String methodName, CallChain call) {
        this._methodName = methodName;
        this.setCall(call);
    }

    public BaseMethod(JMethod method, CallChain call) {
        this._method = method;
        this._exceptionTypes = method.getExceptionTypes();
        this.setCall(call);
    }

    public BaseMethod(JMethod method) {
        this._method = method;
        this._exceptionTypes = method.getExceptionTypes();
    }

    public BaseMethod(JMethod apiMethod, JMethod implMethod) {
        this(apiMethod, (CallChain)new MethodCallChain(implMethod));
    }

    public CallChain getCall() {
        return this._call;
    }

    public void setCall(CallChain call) {
        if (call == null) {
            throw new NullPointerException();
        }
        this._call = call;
    }

    public JMethod getMethod() {
        return this._method;
    }

    public String getMethodName() {
        if (this._methodName != null) {
            return this._methodName;
        }
        return this._method.getName();
    }

    public JClass[] getParameterTypes() {
        if (this._parameterTypes != null) {
            return this._parameterTypes;
        }
        if (this._method != null) {
            return this._method.getParameterTypes();
        }
        return this._call.getParameterTypes();
    }

    public JClass getReturnType() {
        if (this._method != null) {
            return this._method.getReturnType();
        }
        return this._call.getReturnType();
    }

    public JClass[] getExceptionTypes() {
        return this._exceptionTypes;
    }

    public void generate(JavaWriter out) throws IOException {
        String[] args = this.generateMethodHeader(out);
        JClass[] exceptionTypes = this.getExceptionTypes();
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            out.print("  throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(exceptionTypes[i].getPrintName());
            }
            out.println();
        }
        out.println("{");
        out.pushDepth();
        this.generateCall(out, args);
        out.popDepth();
        out.println("}");
    }

    public String[] generateMethodHeader(JavaWriter out) throws IOException {
        if (this._visibility != null && !this._visibility.equals("")) {
            out.print(new CharBuffer().append(this._visibility).append(" ").toString());
        }
        if (this._isStatic) {
            out.print("static ");
        }
        out.print(this.getReturnType().getPrintName());
        out.print(new CharBuffer().append(" ").append(this.getMethodName()).append("(").toString());
        JClass[] parameterTypes = this.getParameterTypes();
        String[] args = new String[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(parameterTypes[i].getPrintName());
            args[i] = new CharBuffer().append("a").append(i).toString();
            out.print(new CharBuffer().append(" ").append(args[i]).toString());
        }
        out.println(")");
        return args;
    }

    protected void generateCall(JavaWriter out, String[] args) throws IOException {
        this._call.generateCall(out, null, null, args);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.java.gen.BaseMethod");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

