/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

public class GroovyCompiler
extends AbstractJavaCompiler {
    protected static final Logger log = Log.open(GroovyCompiler._resin_compat_class_2());
    private static final String GROOVY_COMPILER = "org.codehaus.groovy.tools.FileSystemCompiler";
    private static Class _groovyCompilerClass;
    private static Method _setOutputDir;
    private static Method _setClasspath;
    private static Method _compile;
    String _userPrefix;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public GroovyCompiler(JavaCompiler compiler) {
        super(compiler);
    }

    protected void compileInt(String[] paths, LineMap lineMap) throws IOException {
        Object compiler;
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (_groovyCompilerClass == null) {
            try {
                _groovyCompilerClass = Class.forName(GROOVY_COMPILER, false, loader);
                _setClasspath = _groovyCompilerClass.getMethod("setClasspath", GroovyCompiler._resin_compat_class_0());
                _setOutputDir = _groovyCompilerClass.getMethod("setOutputDir", GroovyCompiler._resin_compat_class_0());
                _compile = _groovyCompilerClass.getMethod("compile", GroovyCompiler._resin_compat_class_1());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            compiler = _groovyCompilerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String sourceExt = this._compiler.getSourceExtension();
            String path = paths[0];
            int tail = path.length() - sourceExt.length();
            String className = path.substring(0, tail);
            Path classFile = this._compiler.getClassDir().lookup(new CharBuffer().append(className).append(".class").toString());
            String cp = this.normalizeClassPath(this._compiler.getClassPath(), false);
            _setClasspath.invoke(compiler, cp);
            String dest = this.normalizePath(this._compiler.getClassDirName(), false);
            _setOutputDir.invoke(compiler, dest);
            ArrayList<String> argList = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(paths[i]);
                argList.add(javaPath.getNativePath());
            }
            String[] files = new String[argList.size()];
            argList.toArray(files);
            _compile.invoke(compiler, new Object[]{files});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOExceptionWrapper(e);
        }
    }

    String normalizeClassPath(String classPath, boolean generateRelative) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        CharBuffer cb = CharBuffer.allocate();
        while (head < classPath.length()) {
            tail = classPath.indexOf(sep, head);
            if (tail < 0) {
                tail = classPath.length();
            }
            if (tail > head) {
                String segment = classPath.substring(head, tail);
                if (cb.length() != 0) {
                    cb.append(sep);
                }
                cb.append(this.normalizePath(segment, generateRelative));
            }
            head = tail + 1;
        }
        return cb.close();
    }

    String normalizePath(String segment, boolean generateRelative) {
        if (this._userPrefix == null) {
            Path userPath = Vfs.lookup(CauchoSystem.getUserDir());
            char sep = CauchoSystem.getFileSeparatorChar();
            this._userPrefix = userPath.getNativePath();
            if (this._userPrefix.length() == 0 || this._userPrefix.charAt(this._userPrefix.length() - 1) != sep) {
                this._userPrefix = new CharBuffer().append(this._userPrefix).append(sep).toString();
            }
        }
        Path path = Vfs.lookup(segment);
        String nativePath = path.getNativePath();
        if (!generateRelative) {
            return nativePath;
        }
        if (nativePath.startsWith(this._userPrefix)) {
            nativePath = nativePath.substring(this._userPrefix.length());
        }
        if (nativePath.equals("")) {
            return ".";
        }
        return nativePath;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("[Ljava.lang.String;");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.java.GroovyCompiler");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class CompilerThread
    implements Runnable {
        private volatile boolean _isDone;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._isDone = true;
            CompilerThread compilerThread = this;
            synchronized (compilerThread) {
                this.notifyAll();
            }
        }
    }
}

