/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.java.AbstractGenerator;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.reflect.Method;

public class IiopStubCompiler
extends AbstractGenerator {
    private Class _cl;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public IiopStubCompiler(Class cl) {
        this._cl = cl;
        String name = cl.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            String pkg = name.substring(0, p);
            String tail = name.substring(p + 1);
            this.setFullClassName(new CharBuffer().append(pkg).append("._").append(tail).append("_Stub").toString());
        } else {
            this.setFullClassName(new CharBuffer().append("_").append(name).append("_Stub").toString());
        }
    }

    public void generateJava() throws Exception {
        this.printHeader();
        Method[] methods = this._cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getDeclaringClass().isAssignableFrom(IiopStubCompiler._resin_compat_class_0()) || method.getDeclaringClass().isAssignableFrom(IiopStubCompiler._resin_compat_class_1())) continue;
            this.printMethod(method);
        }
        this.printFooter();
    }

    private void printHeader() throws IOException {
        this.println("/*");
        this.println(" * Generated by Resin-EJB IiopStubCompiler");
        this.println(" */");
        this.println();
        if (this.getPackageName() != null) {
            this.println(new CharBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.print(new CharBuffer().append("public class ").append(this.getClassName()).toString());
        if (IiopStubCompiler._resin_compat_class_0().isAssignableFrom(this._cl)) {
            this.println(" extends com.caucho.iiop.client.IiopHomeStub");
        } else {
            this.println(" extends com.caucho.iiop.client.IiopStub");
        }
        this.println(new CharBuffer().append("  implements ").append(this._cl.getName()).append(" {").toString());
        this.pushDepth();
        this.println("private static final String[] _type_ids = {");
        this.println(new CharBuffer().append("  \"RMI:").append(this._cl.getName()).append(":0000000000000000\"").toString());
        this.println("};");
        this.println();
        this.println("public String[] _ids()");
        this.println("{");
        this.println("  return _type_ids;");
        this.println("}");
    }

    private void printMethod(Method method) throws IOException {
        this.printMethodHeader(method);
        this.println("{");
        this.pushDepth();
        this.println("org.omg.CORBA_2_3.portable.OutputStream os = null;");
        this.println("try {");
        this.pushDepth();
        this.println(new CharBuffer().append("os = (org.omg.CORBA_2_3.portable.OutputStream) _request(\"").append(method.getName()).append("\", true);").toString());
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            this.printSetValue(args[i], new CharBuffer().append("a").append(i).toString());
        }
        this.println("org.omg.CORBA_2_3.portable.InputStream is;");
        this.println("is = (org.omg.CORBA_2_3.portable.InputStream) _invoke(os);");
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            this.print("return ");
            this.printGetValue(returnType);
            this.println(";");
        }
        this.popDepth();
        this.println("} catch (org.omg.CORBA.portable.ApplicationException e) {");
        this.println("  throw new RuntimeException((String) ((org.omg.CORBA_2_3.portable.InputStream) e.getInputStream()).read_string());");
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("  throw new RuntimeException(e);");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printGetValue(Class type) throws IOException {
        if (type.equals(Boolean.TYPE)) {
            this.print("is.read_boolean()");
        } else if (type.equals(Byte.TYPE)) {
            this.print("is.read_octet()");
        } else if (type.equals(Short.TYPE)) {
            this.print("is.read_short()");
        } else if (type.equals(Integer.TYPE)) {
            this.print("is.read_long()");
        } else if (type.equals(Long.TYPE)) {
            this.print("is.read_longlong()");
        } else if (type.equals(Float.TYPE)) {
            this.print("is.read_float()");
        } else if (type.equals(Double.TYPE)) {
            this.print("is.read_double()");
        } else if (type.equals(Character.TYPE)) {
            this.print("is.read_wchar()");
        } else if (IiopStubCompiler._resin_compat_class_1().isAssignableFrom(type) || IiopStubCompiler._resin_compat_class_2().isAssignableFrom(type)) {
            this.print(new CharBuffer().append("(").append(type.getName()).append(") is.read_Object(").append(type.getName()).append(".class)").toString());
        } else {
            this.print(new CharBuffer().append("(").append(type.getName()).append(") is.read_value(").append(type.getName()).append(".class)").toString());
        }
    }

    private void printSetValue(Class type, String value) throws IOException {
        if (type.equals(Boolean.TYPE)) {
            this.println(new CharBuffer().append("os.write_boolean(").append(value).append(");").toString());
        } else if (type.equals(Byte.TYPE)) {
            this.println(new CharBuffer().append("os.write_octet(").append(value).append(");").toString());
        } else if (type.equals(Short.TYPE)) {
            this.println(new CharBuffer().append("os.write_short(").append(value).append(");").toString());
        } else if (type.equals(Integer.TYPE)) {
            this.println(new CharBuffer().append("os.write_long(").append(value).append(");").toString());
        } else if (type.equals(Long.TYPE)) {
            this.println(new CharBuffer().append("os.write_longlong(").append(value).append(");").toString());
        } else if (type.equals(Float.TYPE)) {
            this.println(new CharBuffer().append("os.write_float(").append(value).append(");").toString());
        } else if (type.equals(Double.TYPE)) {
            this.println(new CharBuffer().append("os.write_double(").append(value).append(");").toString());
        } else if (type.equals(Character.TYPE)) {
            this.println(new CharBuffer().append("os.write_wchar(").append(value).append(");").toString());
        } else {
            this.println(new CharBuffer().append("os.write_value((java.io.Serializable) ").append(value).append(");").toString());
        }
    }

    private void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }

    public static Class create(String className) throws Exception {
        Class cl = CauchoSystem.loadClass(className);
        MergePath mergePath = new MergePath();
        mergePath.addClassPath();
        Path classPath = mergePath.lookup(new CharBuffer().append(className.replace('.', '/')).append(".class").toString());
        classPath = ((MergePath)classPath).getBestPath();
        Path dir = classPath.getParent();
        int i = 0;
        while ((i = className.indexOf(46, i + 1)) >= 0) {
            dir = dir.getParent();
        }
        dir.mkdirs();
        IiopStubCompiler compiler = new IiopStubCompiler(cl);
        compiler.setClassDir(dir);
        Class gen = compiler.preload();
        if (gen != null) {
            return gen;
        }
        compiler.generate();
        return compiler.compile();
    }

    public static void main(String[] argv) throws Exception {
        String className = argv[0];
        System.out.println(IiopStubCompiler.create(className));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.rmi.Remote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

