/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.SkeletonMethod;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.NO_IMPLEMENT;

public class IiopSkeleton
extends DummyObjectImpl {
    private static final Logger log = Log.open(IiopSkeleton._resin_compat_class_0());
    private static HashMap<String, String> _knownClasses = new HashMap();
    private ClassLoader _loader;
    private Class _remoteClass;
    private Object _obj;
    private static Class _resin_compat_class_0;

    IiopSkeleton(Object obj, Class apiClass, ClassLoader loader, String host, int port, String oid) {
        super(new IOR(apiClass, host, port, oid));
        if (obj == null) {
            throw new NullPointerException();
        }
        this._obj = obj;
        this._remoteClass = apiClass;
        this._loader = loader;
    }

    Object getObject() {
        return this._obj;
    }

    Class getRemoteClass() {
        return this._remoteClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service(Object obj, IiopReader reader, IiopWriter writer) throws Throwable {
        String op = reader.getOperation().toString();
        Method method = null;
        SkeletonMethod skelMethod = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("IIOP-call: ").append(this._remoteClass.getName()).append(".").append(op).toString());
        }
        if ((method = this.getMethod(op)) != null) {
            boolean isJava = !this._remoteClass.getName().startsWith("com.caucho.iiop");
            skelMethod = new SkeletonMethod(this, method, isJava);
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                skelMethod.service(obj, reader, writer);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        } else if (!this.serviceSystemMethod(obj, op, reader, writer)) {
            throw new NO_IMPLEMENT(new CharBuffer().append("no such method: ").append(op).append(" for ").append(this._remoteClass.getName()).toString());
        }
    }

    Method getMethod(String name) {
        Method[] methods = this._remoteClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    boolean serviceSystemMethod(Object obj, String op, IiopReader reader, IiopWriter writer) throws Exception {
        if (op.equals("_is_a")) {
            String name = reader.read_string();
            String className = _knownClasses.get(name);
            if (className == null) {
                if (name.startsWith("RMI:")) {
                    className = name.substring(4);
                    int p = className.indexOf(58);
                    if (p > 0) {
                        className = className.substring(0, p);
                    }
                } else {
                    className = name;
                }
            }
            Class<?> cl = obj.getClass();
            boolean value = this.isA(cl, className);
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("IIOP _is_a: ").append(obj.getClass()).append(" ").append(className).append(" ").append(value).toString());
            }
            writer.startReplyOk(reader.getRequestId());
            writer.write_boolean(value);
            return true;
        }
        return false;
    }

    private boolean isA(Class cl, String className) {
        while (cl != null) {
            if (cl.getName().equals(className)) {
                return true;
            }
            Class<?>[] ifs = cl.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                if (!this.isA(ifs[i], className)) continue;
                return true;
            }
            cl = cl.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return new CharBuffer().append("IiopSkeleton[").append(this._remoteClass.getName()).append("]").toString();
    }

    static {
        _knownClasses.put("IDL:omg.org/CosNaming/NamingContext:1.0", "org.omg.CosNaming.NamingContext");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.iiop.IiopSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

