/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class JavaSerializer
extends AbstractSerializer {
    private Field[] _fields;
    private Method _writeReplace;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public JavaSerializer(Class cl) {
        Object fields;
        if (!JavaSerializer._resin_compat_class_0().isAssignableFrom(cl)) {
            throw new IllegalStateException(new CharBuffer().append("Serialized class ").append(cl.getName()).append(" does not implement java.io.Serializable").toString());
        }
        this._writeReplace = this.getWriteReplace(cl);
        if (this._writeReplace != null) {
            this._writeReplace.setAccessible(true);
        }
        ArrayList<Object> primitiveFields = new ArrayList<Object>();
        ArrayList<Object> compoundFields = new ArrayList<Object>();
        while (cl != null) {
            fields = cl.getDeclaredFields();
            for (int i = 0; i < ((Object)fields).length; ++i) {
                Object field = fields[i];
                if (Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).setAccessible(true);
                if (((Field)field).getType().isPrimitive() || ((Field)field).getType().getName().startsWith("java.lang.") && !((Field)field).getType().equals(JavaSerializer._resin_compat_class_1())) {
                    primitiveFields.add(field);
                    continue;
                }
                compoundFields.add(field);
            }
            cl = cl.getSuperclass();
        }
        fields = new ArrayList();
        ((ArrayList)fields).addAll(primitiveFields);
        ((ArrayList)fields).addAll(compoundFields);
        this._fields = new Field[((ArrayList)fields).size()];
        ((ArrayList)fields).toArray(this._fields);
    }

    protected Method getWriteReplace(Class cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("writeReplace") || method.getParameterTypes().length != 0) continue;
                return method;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        try {
            if (this._writeReplace != null) {
                Object repl = this._writeReplace.invoke(obj, new Object[0]);
                out.removeRef(obj);
                out.writeObject(repl);
                out.replaceRef(repl, obj);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            out.writeMapBegin(cl.getName());
            for (int i = 0; i < this._fields.length; ++i) {
                Field field = this._fields[i];
                out.writeString(field.getName());
                out.writeObject(field.get(obj));
            }
            out.writeMapEnd();
        }
        catch (IllegalAccessException e) {
            throw new IOException(String.valueOf(e));
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.io.Serializable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

