/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.IOExceptionWrapper;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class BeanSerializer
extends AbstractSerializer {
    private Method[] _methods;
    private String[] _names;
    private Method _writeReplace;
    private static Class _resin_compat_class_0;

    public BeanSerializer(Class cl) {
        int i;
        this._writeReplace = this.getWriteReplace(cl);
        ArrayList<Method> primitiveMethods = new ArrayList<Method>();
        ArrayList<Method> compoundMethods = new ArrayList<Method>();
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                Class<?> type;
                String name;
                Method method = methods[i];
                if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || !(name = method.getName()).startsWith("get") || (type = method.getReturnType()).equals(Void.TYPE) || this.findSetter(methods, name, type) == null) continue;
                method.setAccessible(true);
                if (type.isPrimitive() || type.getName().startsWith("java.lang.") && !type.equals(BeanSerializer._resin_compat_class_0())) {
                    primitiveMethods.add(method);
                    continue;
                }
                compoundMethods.add(method);
            }
            cl = cl.getSuperclass();
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        methodList.addAll(primitiveMethods);
        methodList.addAll(compoundMethods);
        this._methods = new Method[methodList.size()];
        methodList.toArray(this._methods);
        this._names = new String[this._methods.length];
        for (i = 0; i < this._methods.length; ++i) {
            int j;
            String name = this._methods[i].getName();
            name = name.substring(3);
            for (j = 0; j < name.length() && Character.isUpperCase(name.charAt(j)); ++j) {
            }
            if (j == 1) {
                name = new CharBuffer().append(name.substring(0, j).toLowerCase()).append(name.substring(j)).toString();
            } else if (j > 1) {
                name = new CharBuffer().append(name.substring(0, j - 1).toLowerCase()).append(name.substring(j - 1)).toString();
            }
            this._names[i] = name;
        }
    }

    protected Method getWriteReplace(Class cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("writeReplace") || method.getParameterTypes().length != 0) continue;
                return method;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        try {
            if (this._writeReplace != null) {
                Object repl = this._writeReplace.invoke(obj, new Object[0]);
                out.removeRef(obj);
                out.writeObject(repl);
                out.replaceRef(repl, obj);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            out.writeMapBegin(cl.getName());
            for (int i = 0; i < this._methods.length; ++i) {
                Method method = this._methods[i];
                out.writeString(this._names[i]);
                out.writeObject(this._methods[i].invoke(obj, (Object[])null));
            }
            out.writeMapEnd();
        }
        catch (IllegalAccessException e) {
            throw new IOExceptionWrapper(e);
        }
        catch (InvocationTargetException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    private Method findSetter(Method[] methods, String getterName, Class arg) {
        String setterName = new CharBuffer().append("set").append(getterName.substring(3)).toString();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!method.getName().equals(setterName) || !method.getReturnType().equals(Void.TYPE) || (params = method.getParameterTypes()).length != 1 || !params[0].equals(arg)) continue;
            return method;
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

