/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RewriteFilter
implements Filter {
    private static final Logger log = Log.open(RewriteFilter._resin_compat_class_0());
    private static final L10N L = new L10N(RewriteFilter._resin_compat_class_0());
    private ServletContext _app;
    private ArrayList<RewriteEntry> _entries = new ArrayList();
    private static Class _resin_compat_class_0;

    public void addRewrite(RewriteEntry rewrite) {
        this._entries.add(rewrite);
    }

    public void init(FilterConfig config) throws ServletException {
        this._app = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String url = req.getRequestURI();
        for (int i = 0; i < this._entries.size(); ++i) {
            RewriteEntry entry = this._entries.get(i);
            Pattern pattern = entry.getRegexp();
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find(0)) continue;
            String replacement = this.replace(matcher, entry.getTarget());
            String query = req.getQueryString();
            if (query != null) {
                replacement = replacement.indexOf(63) > 0 ? new CharBuffer().append(replacement).append('&').append(query).toString() : new CharBuffer().append(replacement).append('?').append(query).toString();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("forwarding `{0}' to `{1}'", (Object)url, replacement));
            }
            if (replacement.startsWith("/")) {
                RequestDispatcher disp = this._app.getRequestDispatcher(replacement);
                disp.forward(request, response);
                return;
            }
            res.sendRedirect(res.encodeRedirectURL(replacement));
            return;
        }
        nextFilter.doFilter(request, response);
    }

    private String replace(Matcher matcher, String target) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < target.length(); ++i) {
            char ch = target.charAt(i);
            if (ch != '$' || i == target.length() - 1) {
                cb.append(ch);
                continue;
            }
            ch = target.charAt(i + 1);
            if (ch >= '0' && ch <= '9') {
                int group = ch - 48;
                cb.append(matcher.group(group));
                ++i;
                continue;
            }
            if (ch == '$') {
                cb.append('$');
                ++i;
                continue;
            }
            cb.append('$');
        }
        return cb.toString();
    }

    public void destroy() {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.filters.RewriteFilter");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class RewriteEntry {
        private Pattern _pattern;
        private String _target;

        public void setPattern(String pattern) {
            this._pattern = Pattern.compile(pattern);
        }

        public Pattern getRegexp() {
            return this._pattern;
        }

        public void setTarget(String target) {
            this._target = target;
        }

        public String getTarget() {
            return this._target;
        }
    }
}

