/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.wrapper;

import com.caucho.util.CharBuffer;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ESMethodDescriptor
extends MethodDescriptor {
    String name;
    boolean overwrite;
    boolean staticVirtual;
    Class declaringClass;
    String classJVMName;
    Class[] parameterTypes;

    public ESMethodDescriptor(Method method, boolean overwrite, boolean staticVirtual) throws IntrospectionException {
        super(method);
        this.name = method.getName();
        if (this.name == null) {
            throw new RuntimeException();
        }
        this.overwrite = overwrite;
        this.staticVirtual = staticVirtual;
    }

    public ESMethodDescriptor(ESMethodDescriptor md) throws IntrospectionException {
        super(md.getMethod());
        this.name = md.getName();
        this.overwrite = md.overwrite;
        this.staticVirtual = md.staticVirtual;
        this.declaringClass = md.declaringClass;
        this.parameterTypes = md.parameterTypes;
        this.classJVMName = md.classJVMName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isStaticVirtual() {
        return this.staticVirtual;
    }

    public boolean isStatic() {
        return !this.staticVirtual && Modifier.isStatic(this.getMethod().getModifiers());
    }

    public boolean overwrites(ESMethodDescriptor md) {
        if (!this.isStatic() && md.isStatic()) {
            return true;
        }
        return this.isOverwrite() && !md.isOverwrite();
    }

    public Class[] getParameterTypes() {
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        if (!this.isStaticVirtual()) {
            this.parameterTypes = this.getMethod().getParameterTypes();
        } else {
            Class<?>[] realParam = this.getMethod().getParameterTypes();
            this.parameterTypes = new Class[realParam.length - 1];
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameterTypes[i] = realParam[i + 1];
            }
        }
        return this.parameterTypes;
    }

    public Class getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.staticVirtual ? this.getMethod().getParameterTypes()[0] : this.getMethod().getDeclaringClass();
        }
        return this.declaringClass;
    }

    public Class getReturnType() {
        return this.getMethod().getReturnType();
    }

    public String getMethodClassName() {
        return this.getMethod().getDeclaringClass().getName();
    }

    String getObjectClassName() {
        return this.getDeclaringClass().getName();
    }

    String getClassJVMName() {
        if (this.classJVMName == null) {
            this.classJVMName = this.getDeclaringClass().getName().replace('.', '/');
        }
        return this.classJVMName;
    }

    public String toString() {
        Class[] param = this.getParameterTypes();
        if (param == null || param.length == 0) {
            return new CharBuffer().append("[ESMethodDescriptor ").append(this.getDeclaringClass().getName()).append(".").append(this.getName()).append("]").toString();
        }
        return new CharBuffer().append("[ESMethodDescriptor ").append(this.getDeclaringClass().getName()).append(".").append(this.getName()).append(" ").append(param[0]).append("]").toString();
    }
}

