/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.util.CharBuffer;

class Variable {
    private Function function;
    private ESId id;
    private boolean isLocal;
    private boolean isScope;
    private boolean isInitialized;
    private boolean isUsed;
    private boolean isClosureVar;
    private boolean isJavaGlobal;
    int type;
    Expr fullType;
    private boolean isDeclared;

    Variable(Block block, ESId id, Expr type, boolean isLocal) {
        this.function = block.function;
        this.id = id;
        this.isLocal = isLocal;
        this.isScope = block.getDepth() > 0 || !this.function.isGlobalScope();
        this.type = 0;
        this.fullType = (TypeExpr)type;
        if (this.fullType != null) {
            this.type = this.fullType.getType();
            this.isDeclared = true;
        }
    }

    ESId getId() {
        return this.id;
    }

    void setType(int type) {
        if (!this.isUsed) {
            this.isInitialized = true;
        }
        if (this.fullType == null) {
            this.type = type;
        }
    }

    void declare(int javaScriptType, Expr typeExpr) {
        if (this.isDeclared && !typeExpr.equals(this.fullType)) {
            throw new IllegalStateException(new CharBuffer().append("can't declare ").append(this).append(" twice").toString());
        }
        this.setType(javaScriptType, typeExpr);
        this.isDeclared = true;
    }

    void setType(int newType, Expr expr) {
        if (!this.isUsed) {
            this.isInitialized = true;
        }
        if (this.isDeclared) {
            return;
        }
        if (newType != 0 && newType != 6) {
            this.type = 1;
            this.fullType = null;
            return;
        }
        if (!(this.fullType == null || this.fullType instanceof JavaTypeExpr && expr instanceof JavaTypeExpr)) {
            this.type = 1;
            this.fullType = null;
            return;
        }
        JavaTypeExpr typeExpr = (JavaTypeExpr)expr;
        if (this.fullType != null && !((JavaTypeExpr)this.fullType).getJavaClass().equals(typeExpr.getJavaClass())) {
            this.type = 1;
            this.fullType = null;
            return;
        }
        Class javaClass = typeExpr.getJavaClass();
        if (javaClass.equals(Byte.TYPE) || javaClass.equals(Short.TYPE) || javaClass.equals(Integer.TYPE)) {
            this.type = 4;
        } else if (javaClass.equals(Float.TYPE) || javaClass.equals(Double.TYPE)) {
            this.type = 3;
        } else if (javaClass.equals(Boolean.TYPE)) {
            this.type = 5;
        } else {
            if (javaClass.isPrimitive()) {
                this.type = 1;
                this.fullType = null;
                return;
            }
            this.type = newType;
            this.fullType = typeExpr;
        }
    }

    boolean isLocal() {
        return this.isLocal;
    }

    void killLocal() {
        this.isLocal = false;
    }

    boolean isJavaLocal() {
        return this.isLocal && !this.isClosureVar;
    }

    boolean isJavaGlobal() {
        return this.isJavaGlobal;
    }

    void setJavaGlobal(boolean isGlobal) {
        this.isJavaGlobal = isGlobal;
        this.isLocal = false;
        if (this.type == 0) {
            this.type = 1;
        }
    }

    int getType() {
        if (this.type == 0) {
            this.type = 1;
            this.isInitialized = false;
        }
        return this.type;
    }

    Expr getTypeExpr() {
        return this.fullType;
    }

    boolean hasInit() {
        return this.type != 0 && this.isLocal && this.isInitialized;
    }

    boolean isScope() {
        return this.isScope;
    }

    void setUsed() {
        this.isUsed = true;
        if (this.type == 0) {
            this.type = 1;
        }
        this.isInitialized = false;
    }

    void setUsedByClosure() {
        this.isClosureVar = true;
        this.setUsed();
    }

    boolean isUsed() {
        return this.isUsed;
    }

    void setLocal() {
        this.isLocal = true;
    }

    public String toString() {
        return new CharBuffer().append("[Variable ").append(this.id).append(" ").append(this.fullType).append("]").toString();
    }
}

