/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.JavaClassExpr;
import com.caucho.es.parser.JavaMethod;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

class JavaNewExpr
extends CallExpr {
    private Class javaClass;
    private Constructor constructor;

    JavaNewExpr(Block block, Class javaClass) throws ESException {
        super(block, null, null, true);
        this.javaClass = javaClass;
    }

    void addCallParam(Expr param) {
        param.setUsed();
        this.args.add(param);
    }

    int getType() {
        this.calculateType();
        return this.type;
    }

    Expr getTypeExpr() {
        this.calculateType();
        return this.typeExpr;
    }

    private void calculateType() {
        if (this.isCalculated) {
            return;
        }
        this.isCalculated = true;
        if (this.javaClass == null) {
            return;
        }
        this.method = JavaMethod.bestMethod(this.javaClass, "create", true, this.args);
        if (this.method == null || !this.method.getReturnType().equals(this.javaClass)) {
            this.method = null;
        }
        if (this.method != null) {
            this.term = new JavaClassExpr(this.block, this.javaClass);
        }
        Constructor<?>[] constructors = this.javaClass.getConstructors();
        Constructor<?> bestConstructor = null;
        int bestCost = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            Class[] param;
            int cost;
            Constructor<?> constructor = constructors[i];
            if (!Modifier.isPublic(constructor.getModifiers()) || (cost = JavaMethod.methodCost(param = constructor.getParameterTypes(), this.args)) >= bestCost) continue;
            bestCost = cost;
            bestConstructor = constructor;
        }
        this.constructor = bestConstructor;
        this.type = 6;
        this.typeExpr = new JavaTypeExpr(this.block, this.javaClass);
    }

    void printJavaImpl() throws IOException {
        if (this.method != null) {
            super.printJavaImpl();
            return;
        }
        if (this.constructor == null) {
            throw new IOException(new CharBuffer().append("can't create `").append(this.javaClass.getName()).append("'").toString());
        }
        this.cl.print("new ");
        this.cl.print(this.javaClass.getName());
        this.cl.print("(");
        Class<?>[] params = null;
        if (this.constructor != null) {
            params = this.constructor.getParameterTypes();
        }
        for (int i = 0; i < params.length; ++i) {
            Expr expr = i < this.args.size() ? (Expr)this.args.get(i) : this.block.newLiteral(ESBase.esUndefined);
            if (i != 0) {
                this.cl.print(", ");
            }
            if (params != null && !params[i].isPrimitive()) {
                this.cl.print("(");
                this.printJavaClass(params[i]);
                this.cl.print(")");
            }
            expr.printJava();
        }
        this.cl.print(")");
    }
}

