/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.AssignExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.DeleteExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.PostfixExpr;
import com.caucho.es.parser.Variable;
import com.caucho.util.CharBuffer;
import java.io.IOException;

class IdExpr
extends Expr {
    private static ESId ARGUMENTS = ESId.intern("arguments");
    private Variable var;

    IdExpr(Block block, Variable var) {
        super(block);
        this.var = var;
        if (var.getId() == ARGUMENTS) {
            this.function.setArguments();
            this.function.setUseAllVariables();
        }
        if (var.getTypeExpr() != null) {
            this.type = var.getType();
            this.javaType = var.getTypeExpr().getJavaClass();
        }
        if (!(var.isLocal() || this.function.isGlobalScope() || var.isJavaGlobal())) {
            this.function.setNeedsScope();
        }
    }

    void setType(int type) {
        this.var.setType(type);
    }

    boolean isLocal() {
        return this.var.isLocal() && this.function.allowLocals();
    }

    boolean isJavaLocal() {
        return this.var.isJavaLocal() && this.function.allowLocals();
    }

    boolean isJavaGlobal() {
        return this.var.isJavaGlobal();
    }

    void setUsed() {
        this.var.setUsed();
    }

    int getType() {
        if (!this.isLocal() && !this.isJavaGlobal()) {
            return 1;
        }
        return this.var.getType();
    }

    Expr getTypeExpr() {
        if (!this.isLocal()) {
            return null;
        }
        return this.var.getTypeExpr();
    }

    boolean isSimple() {
        return this.isJavaLocal();
    }

    boolean isGlobalScope() {
        return this.function.isGlobalScope() && !this.var.isScope();
    }

    Variable getVar() {
        return this.var;
    }

    boolean isUsed() {
        return this.var.isUsed() || this.function.useAllVariables();
    }

    void setLocal() {
        this.var.setLocal();
    }

    ESId getId() {
        return this.var.getId();
    }

    Expr delete() {
        return new DeleteExpr(this.block, this);
    }

    Expr postfix(int op) {
        if (op == 43) {
            return new PostfixExpr(this.block, 73, this);
        }
        return new PostfixExpr(this.block, 68, this);
    }

    Expr prefix(int op) {
        if (op == 43) {
            return new PostfixExpr(this.block, 105, this);
        }
        return new PostfixExpr(this.block, 100, this);
    }

    Expr assign(Expr value) throws ESException {
        int valueType = value.getType();
        Expr typeExpr = value.getTypeExpr();
        int type = this.var.type;
        if (this.isLocal() || this.isJavaGlobal()) {
            if (valueType == 0) {
                valueType = 1;
            }
            if (typeExpr != null) {
                this.var.setType(6, typeExpr);
            } else if (type == 0) {
                this.var.setType(valueType);
            } else if (type != valueType) {
                if (!(type != 4 && type != 3 || valueType != 4 && valueType != 3)) {
                    this.var.setType(3);
                } else {
                    this.var.setType(1, null);
                }
            }
            type = this.var.getType();
            Expr newTypeExpr = this.var.getTypeExpr();
            this.javaType = newTypeExpr == null ? null : newTypeExpr.getJavaClass();
        }
        return new AssignExpr(this.block, this, value);
    }

    CallExpr startCall() throws ESException {
        this.var.setUsed();
        return new CallExpr(this.block, this, null, false);
    }

    CallExpr startNew() throws ESException {
        this.var.setUsed();
        return new CallExpr(this.block, this, null, true);
    }

    void exprStatement(Function fun) throws ESException {
        this.doVoid().exprStatement(fun);
    }

    void printNumImpl() throws IOException {
        this.printImpl();
    }

    void printBooleanImpl() throws IOException {
        this.printImpl();
    }

    void printInt32Impl() throws IOException {
        this.printImpl();
    }

    void printStringImpl() throws IOException {
        this.printImpl();
    }

    void printImpl() throws IOException {
        this.cl.setLine(this.getFilename(), this.getLine());
        if (this.isJavaLocal()) {
            this.cl.print(this.getId());
        } else if (this.isJavaGlobal()) {
            this.cl.print(this.getId());
        } else if (this.isGlobalScope()) {
            this.cl.print("_env.getGlobalVariable(");
            this.printLiteral(this.getId());
            this.cl.print(")");
        } else {
            this.cl.print("_env.getScopeProperty(");
            this.printLiteral(this.getId());
            this.cl.print(")");
        }
    }

    void printJavaImpl() throws IOException {
        this.cl.setLine(this.getFilename(), this.getLine());
        this.cl.print(this.getId());
    }

    public String toString() {
        return new CharBuffer().append("[IdExpr ").append(this.getId()).append("]").toString();
    }
}

