/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.es.parser.Parser;
import com.caucho.es.parser.TypeExpr;
import com.caucho.es.parser.Variable;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class Function {
    static ESId PROTOTYPE = ESId.intern("prototype");
    Parser parser;
    ParseClass cl;
    private Function parent;
    int funDepth;
    private int lambdaCount = 0;
    ArrayList formals;
    Expr returnType;
    ArrayList variables = new ArrayList();
    ArrayList functions;
    private IntMap funMap;
    boolean isClass;
    ESId classProto;
    Function constructor;
    String name;
    ESId id;
    int num;
    boolean isSilent;
    boolean hasCall;
    boolean hasThis;
    boolean allowLocals;
    boolean allowJavaLocals;
    boolean needsScope;
    ArrayList data = new ArrayList();
    private HashMap vars = new HashMap();
    CharBuffer tail;
    private int iterCount;
    private int tempCount;
    private int stmtCount;
    private int stmtTop;
    private HashMap usedVars;
    private boolean isGlobal;
    private boolean needsArguments;
    private boolean needsStatementResults;
    private boolean useAllVariables;
    private boolean isEval;
    private boolean hasSwitch;

    Function(ParseClass cl, Function parent, String name, ESId id, boolean isClass) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.cl = cl;
        this.funDepth = parent == null || isClass ? 0 : parent.funDepth + 1;
        this.num = -1;
        this.isGlobal = parent == null;
        this.allowJavaLocals = this.allowLocals = this.funDepth >= 1 || isClass;
        this.needsStatementResults = parent == null;
    }

    void setFast(boolean isFast) {
        if (isFast) {
            this.allowLocals = true;
            this.allowJavaLocals = true;
        }
    }

    Function getParent() {
        return this.parent;
    }

    boolean isGlobalScope() {
        return !this.needsScope && (this.getFunctionDepth() == 0 || this.getFunctionDepth() == 1 && !this.needsArguments());
    }

    boolean needsStatementResults() {
        return this.needsStatementResults;
    }

    void setNeedsResults() {
        this.needsStatementResults = true;
    }

    void setEval() {
        this.setArguments();
        this.needsStatementResults = true;
        this.isEval = true;
    }

    boolean useAllVariables() {
        return this.isEval || this.useAllVariables;
    }

    void setUseAllVariables() {
        this.useAllVariables = true;
    }

    String getStatementVar() {
        if (!this.needsStatementResults()) {
            return null;
        }
        return new CharBuffer().append("_val").append(this.stmtCount).toString();
    }

    void pushStatementLoop() {
        if (!this.needsStatementResults()) {
            return;
        }
        ++this.stmtCount;
        if (this.stmtCount > this.stmtTop) {
            this.stmtTop = this.stmtCount;
        }
    }

    void popStatementLoop() {
        if (!this.needsStatementResults()) {
            return;
        }
        --this.stmtCount;
    }

    void setCall() {
        this.hasCall = true;
    }

    void setThis() {
        this.hasThis = true;
    }

    void setVars() {
        Iterator iter = this.vars.values().iterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            var.getType();
        }
    }

    boolean isGlobal() {
        return this.isGlobal;
    }

    int getFunctionDepth() {
        return this.funDepth;
    }

    void disableGlobal() {
        this.isGlobal = false;
    }

    void disallowLocal() {
        if (this.parent != null) {
            this.allowJavaLocals = false;
            this.allowLocals = false;
            this.needsScope = true;
        }
    }

    void disallowJavaLocal() {
        this.allowJavaLocals = false;
    }

    void setNeedsScope() {
        if (this.parent != null) {
            this.needsScope = true;
        }
    }

    void setArguments() {
        this.needsArguments = true;
        this.setNeedsScope();
        this.disallowLocal();
    }

    boolean needsArguments() {
        return this.needsArguments;
    }

    boolean allowLocals() {
        return this.allowLocals;
    }

    boolean allowJavaLocals() {
        return this.allowLocals && this.allowJavaLocals;
    }

    void useClosureVar(ESId name) {
        Function fun = this.parent;
        while (fun != null) {
            Variable var = (Variable)fun.vars.get(name);
            fun.needsArguments = true;
            if (var != null) {
                var.setUsedByClosure();
            } else {
                if (fun.usedVars == null) {
                    fun.usedVars = new HashMap();
                }
                fun.usedVars.put(name, name);
            }
            fun = fun.parent;
        }
    }

    boolean hasVar(ESId name) {
        return this.vars.get(name) != null;
    }

    IdExpr newVar(Block block, ESId name) {
        return this.newVar(block, name, null);
    }

    IdExpr newVar(Block block, ESId name, Expr type) {
        Variable var = (Variable)this.vars.get(name);
        if (var == null && type == null && (var = this.cl.getVariable(name)) != null) {
            return new IdExpr(block, var);
        }
        if (var == null) {
            var = new Variable(block, name, type, false);
            this.vars.put(name, var);
            if (this.usedVars != null && this.usedVars.get(name) != null) {
                var.setUsedByClosure();
            }
        }
        this.useClosureVar(name);
        return new IdExpr(block, var);
    }

    void addVariable(Block block, ESId id, Expr type) {
        Variable var;
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        if ((var = (Variable)this.vars.get(id)) == null) {
            var = new Variable(block, id, type, this.allowLocals);
            this.vars.put(id, var);
            if (this.usedVars != null && this.usedVars.get(id) != null) {
                var.setUsedByClosure();
            }
            if (this.parent == null && type != null) {
                this.cl.addVariable(id, var);
            }
        } else if (this.parent != null) {
            var.setLocal();
        }
        if (!(this.variables.contains(var) || this.formals != null && this.formals.contains(var))) {
            this.variables.add(var);
        }
        this.useClosureVar(id);
    }

    int getIter() {
        return this.iterCount++;
    }

    String getTemp() {
        return new CharBuffer().append("temp").append(this.tempCount++).toString();
    }

    void setConstructor(Function constructor) {
        this.isClass = true;
        this.constructor = constructor;
    }

    void setClassProto(ESId classProto) {
        this.isClass = true;
        this.classProto = classProto;
    }

    void setCodeNumber(int num) {
        this.num = num;
    }

    void addFormal(Block block, ESId id, Expr type) {
        if (this.formals == null) {
            this.formals = new ArrayList();
        }
        Variable var = new Variable(block, id, type, true);
        var.setUsed();
        this.formals.add(var);
        this.vars.put(id, var);
    }

    int getFormalSize() {
        return this.formals == null ? 0 : this.formals.size();
    }

    Variable getFormal(int j) {
        return (Variable)this.formals.get(j);
    }

    Expr getReturnType() {
        return this.returnType;
    }

    void setReturnType(Expr type) {
        this.returnType = type;
    }

    int getVariableSize() {
        return this.variables == null ? 0 : this.variables.size();
    }

    void addFunction(Function function) {
        int pos;
        if (this.functions == null) {
            this.functions = new ArrayList();
            this.funMap = new IntMap();
        }
        if ((pos = this.funMap.get(function.id)) < 0) {
            this.funMap.put(function.id, this.functions.size());
            this.functions.add(function);
        } else {
            this.functions.set(pos, function);
        }
    }

    int getFunctionSize() {
        return this.functions == null ? 0 : this.functions.size();
    }

    Function getFunction(int i) {
        return (Function)this.functions.get(i);
    }

    Function getFunction(ESId id) {
        if (this.funMap == null) {
            return null;
        }
        int index = this.funMap.get(id);
        if (index >= 0) {
            return (Function)this.functions.get(index);
        }
        return null;
    }

    void print(Object value) {
        if (this.tail == null) {
            this.tail = CharBuffer.allocate();
        }
        this.tail.append(String.valueOf(value));
    }

    void println(String value) {
        if (this.tail == null) {
            this.tail = CharBuffer.allocate();
        }
        this.tail.append(String.valueOf(value));
        this.tail.append('\n');
    }

    void addExpr(Expr expr) {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.data.add(expr);
        expr.setUsed();
    }

    void addBoolean(Expr expr) {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.data.add(expr.setBoolean());
        expr.setUsed();
    }

    Object getTop() {
        if (this.tail != null) {
            return this.tail;
        }
        if (this.data.size() > 0) {
            return this.data.get(this.data.size() - 1);
        }
        this.tail = new CharBuffer();
        return this.tail;
    }

    Object getSwitch() {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.hasSwitch = true;
        return this.data.get(this.data.size() - 1);
    }

    int mark() {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        return this.data.size();
    }

    void moveChunk(Object topObject, int mark) {
        int top;
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        for (top = 0; top < mark && this.data.get(top) != topObject; ++top) {
        }
        ++top;
        int here = this.data.size();
        for (int i = 0; i < here - mark; ++i) {
            Object chunk = this.data.remove(this.data.size() - 1);
            this.data.add(top, chunk);
        }
    }

    void writeCode(ParseClass cl) throws IOException {
        int i;
        cl.print("public ");
        if (this.returnType == null) {
            cl.print("ESBase ");
        } else if (this.returnType.getType() == 4) {
            cl.print("int ");
        } else {
            cl.print("ESBase ");
        }
        cl.print(new CharBuffer().append(this.name).append("(Call _env, int _length").toString());
        for (i = 0; i < this.getFormalSize(); ++i) {
            TypeExpr type;
            Variable formal = (Variable)this.formals.get(i);
            if (!(formal.getTypeExpr() instanceof TypeExpr) || (type = (TypeExpr)formal.getTypeExpr()).getTypeName() == null) continue;
            cl.print(new CharBuffer().append(", ").append(type.getTypeName()).append(" ").append(formal.getId()).toString());
        }
        cl.println(")");
        cl.println("throws Throwable");
        cl.println("{");
        cl.pushDepth();
        if (this.hasCall) {
            cl.println("Call _call = _env.getCall();");
        }
        if (this.hasThis) {
            cl.println("ESObject _this = _env.getThis();");
        }
        if (this.parent != null && this.functions != null && this.functions.size() > 0) {
            this.needsArguments = true;
            this.setNeedsScope();
        }
        if (this.isEval) {
            cl.println("ESObject _arg = _env.getEval();");
        } else {
            if (this.needsScope && this.parent != null) {
                cl.println("_env.fillScope();");
            }
            if (this.needsArguments && this.parent != null) {
                cl.print("ESObject _arg = _env.createArg(");
                if (this.getFormalSize() > 0) {
                    cl.print(new CharBuffer().append("_js._a_").append(this.num).toString());
                } else {
                    cl.print("_js._a_null");
                }
                cl.println(", _length);");
            }
        }
        this.printFormals();
        this.printLocalVariables();
        for (i = 0; this.needsArguments && this.functions != null && i < this.functions.size(); ++i) {
            if (i == 0) {
                cl.println("ESClosure _closure;");
            }
            Function fun = (Function)this.functions.get(i);
            Variable var = (Variable)this.vars.get(fun.id);
            if (!this.isGlobal && !this.isEval && var != null && !var.isUsed() && !this.useAllVariables) continue;
            cl.print("_closure = new ESClosure(");
            cl.printLiteral(fun.id);
            cl.println(new CharBuffer().append(", _js, null, ").append(fun.num).append(", _js._a_null, null);").toString());
            cl.println("_closure.closure(_env);");
            if (!this.isEval && this.allowLocals && var != null && var.isUsed() && var.isJavaLocal()) {
                cl.println(new CharBuffer().append("ESBase ").append(fun.id).append(" = _closure;").toString());
                continue;
            }
            if (!this.isEval && this.parent != null) {
                cl.print("_arg.put(");
            } else {
                cl.print("_env.global.put(");
            }
            cl.printLiteral(fun.id);
            cl.print(", _closure, ");
            if (!this.isEval) {
                cl.print("ESBase.DONT_ENUM|ESBase.DONT_DELETE");
            } else {
                cl.print("0");
            }
            cl.println(");");
        }
        for (i = 0; i < this.iterCount; ++i) {
            cl.println(new CharBuffer().append("java.util.Iterator iter").append(i).append(";").toString());
        }
        for (i = 0; i < this.tempCount; ++i) {
            cl.println(new CharBuffer().append("ESBase temp").append(i).append(";").toString());
        }
        if (this.needsStatementResults()) {
            cl.println("ESBase _val0 = ESBase.esUndefined;");
        }
        for (i = 1; i <= this.stmtTop; ++i) {
            cl.println(new CharBuffer().append("ESBase _val").append(i).append(" = ESBase.esUndefined;").toString());
        }
        if (this.hasSwitch) {
            cl.println("int _switchcode;");
            cl.println("ESBase _switchtemp;");
        }
        for (i = 0; i < this.data.size(); ++i) {
            Object d = this.data.get(i);
            if (d instanceof CharBuffer) {
                cl.print((CharBuffer)d);
                continue;
            }
            if (!(d instanceof Expr)) continue;
            Expr expr = (Expr)d;
            expr.printExpr();
        }
        if (this.tail != null) {
            cl.print(this.tail);
        }
        cl.popDepth();
        cl.println("}");
    }

    void printFormals() throws IOException {
        block0: for (int i = 0; this.formals != null && i < this.formals.size(); ++i) {
            Variable formal = (Variable)this.formals.get(i);
            if (this.funMap != null && this.funMap.get(formal.getId()) >= 0) continue;
            for (int j = i + 1; j < this.formals.size(); ++j) {
                if (formal.getId() == ((Variable)this.formals.get(j)).getId()) continue block0;
            }
            if (!this.allowLocals || formal.getTypeExpr() instanceof JavaTypeExpr || formal.getType() == 4) continue;
            this.cl.print(new CharBuffer().append("ESBase ").append(formal.getId()).toString());
            this.cl.println(new CharBuffer().append(" = _env.getArg(").append(i).append(", _length);").toString());
        }
    }

    void printLocalVariables() throws IOException {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable var = (Variable)this.variables.get(i);
            if (this.funMap != null && this.funMap.get(var.getId()) >= 0) {
                var.killLocal();
                continue;
            }
            if (var.isJavaGlobal()) continue;
            if (!(this.allowLocals && var.isJavaLocal() || !this.isGlobal())) {
                this.cl.print("_env.global.setProperty(");
                this.cl.printLiteral(var.getId());
                this.cl.println(", ESBase.esUndefined);");
                continue;
            }
            if (!var.isUsed() && !this.useAllVariables()) continue;
            if (!this.allowLocals || !var.isJavaLocal()) {
                if (this.isEval) {
                    this.cl.print("if (_arg.getProperty(");
                    this.cl.printLiteral(var.getId());
                    this.cl.println(") == ESBase.esEmpty)");
                    this.cl.print("  ");
                }
                if (var.hasInit()) continue;
                this.cl.print("_arg.put(");
                this.cl.printLiteral(var.getId());
                this.cl.print(", ESBase.esUndefined, ");
                if (!this.isEval) {
                    this.cl.print("ESBase.DONT_ENUM|ESBase.DONT_DELETE");
                } else {
                    this.cl.print("0");
                }
                this.cl.println(");");
                continue;
            }
            if (var.getType() == 5) {
                this.cl.println(new CharBuffer().append("boolean ").append(var.getId()).append(";").toString());
                if (var.hasInit()) continue;
                this.cl.println(new CharBuffer().append(var.getId()).append(" = false;").toString());
                continue;
            }
            if (var.getType() == 4) {
                this.cl.println(new CharBuffer().append("int ").append(var.getId()).append(";").toString());
                if (var.hasInit()) continue;
                this.cl.println(new CharBuffer().append(var.getId()).append(" = 0;").toString());
                continue;
            }
            if (var.getType() == 3) {
                this.cl.println(new CharBuffer().append("double ").append(var.getId()).append(";").toString());
                if (var.hasInit()) continue;
                this.cl.println(new CharBuffer().append(var.getId()).append(" = Double.NaN;").toString());
                continue;
            }
            if (var.getType() == 2) {
                this.cl.println(new CharBuffer().append("ESString ").append(var.getId()).append(";").toString());
                if (var.hasInit()) continue;
                this.cl.println(new CharBuffer().append(var.getId()).append(" = null;").toString());
                continue;
            }
            if (var.getType() == 6 && var.getTypeExpr() != null) {
                TypeExpr type = (TypeExpr)var.getTypeExpr();
                this.cl.println(new CharBuffer().append(type.getTypeName()).append(" ").append(var.getId()).append(" = null;").toString());
                continue;
            }
            if (var.isLocal()) {
                if (!var.hasInit()) {
                    this.cl.println(new CharBuffer().append("ESBase ").append(var.getId()).append(" = ESBase.esUndefined;").toString());
                    continue;
                }
                this.cl.println(new CharBuffer().append("ESBase ").append(var.getId()).append(";").toString());
                continue;
            }
            this.cl.print("  _env.global.setProperty(");
            this.cl.printLiteral(var.getId());
            this.cl.println(", ESBase.esUndefined);");
        }
    }
}

