/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.util.CharBuffer;
import java.io.IOException;

class CastExpr
extends Expr {
    private Expr lhs;
    private TypeExpr typeExpr;
    private static Class _resin_compat_class_0;

    private CastExpr(Block block, Expr lhs, TypeExpr typeExpr) throws ESException {
        super(block);
        this.lhs = lhs;
        this.typeExpr = typeExpr;
    }

    static CastExpr create(Block block, Expr lhs, TypeExpr typeExpr) throws ESException {
        return new CastExpr(block, lhs, typeExpr);
    }

    int getType() {
        return this.typeExpr.getType();
    }

    Expr getTypeExpr() {
        return this.typeExpr;
    }

    void printImpl() throws IOException {
        this.lhs.print();
    }

    void printBooleanImpl() throws IOException {
        this.lhs.printBoolean();
    }

    void printInt32Impl() throws IOException {
        if (!this.typeExpr.getTypeName().equals("int")) {
            this.cl.print(new CharBuffer().append("(").append(this.typeExpr.getTypeName()).append(") ").toString());
        }
        this.lhs.printInt32();
    }

    void printNumImpl() throws IOException {
        if (!this.typeExpr.getTypeName().equals("double")) {
            this.cl.print(new CharBuffer().append("(").append(this.typeExpr.getTypeName()).append(") ").toString());
        }
        this.lhs.printNum();
    }

    void printStringImpl() throws IOException {
        if (this.lhs.getJavaClass().equals(CastExpr._resin_compat_class_0())) {
            this.lhs.printStringImpl();
        } else {
            this.cl.print("String.valueOf(");
            this.lhs.printString();
            this.cl.print(")");
        }
    }

    void printJavaImpl() throws IOException {
        if (!this.typeExpr.getJavaClass().isAssignableFrom(this.lhs.getJavaClass())) {
            this.cl.print(new CharBuffer().append("(").append(this.typeExpr.getJavaClass().getName()).append(") ").toString());
        }
        this.lhs.printJava();
    }

    void setUsed() {
        this.lhs.setUsed();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

