/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESWrapperException;
import com.caucho.es.parser.BinaryExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.LiteralExpr;
import java.io.IOException;

class BooleanBinaryExpr
extends BinaryExpr {
    private BooleanBinaryExpr(Block block, Expr left, Expr right, int op) {
        super(block, left, right, op);
    }

    static Expr create(Block block, Expr left, Expr right, int op) throws ESException {
        boolean value;
        if (!(left instanceof LiteralExpr) || !(right instanceof LiteralExpr)) {
            return new BooleanBinaryExpr(block, left, right, op);
        }
        ESBase lvalue = ((LiteralExpr)left).getLiteral();
        ESBase rvalue = ((LiteralExpr)right).getLiteral();
        try {
            switch (op) {
                case 60: {
                    value = lvalue.lessThan(rvalue, false);
                    break;
                }
                case 62: {
                    value = rvalue.lessThan(lvalue, false);
                    break;
                }
                case 272: {
                    value = rvalue.lessThan(lvalue, true);
                    break;
                }
                case 271: {
                    value = lvalue.lessThan(rvalue, true);
                    break;
                }
                case 273: {
                    value = lvalue.ecmaEquals(rvalue);
                    break;
                }
                case 274: {
                    value = !lvalue.ecmaEquals(rvalue);
                    break;
                }
                case 275: {
                    value = lvalue.equals(rvalue);
                    break;
                }
                case 276: {
                    value = !lvalue.equals(rvalue);
                    break;
                }
                default: {
                    throw new RuntimeException("foo");
                }
            }
        }
        catch (Throwable e) {
            throw new ESWrapperException(e);
        }
        return new LiteralExpr(block, ESBoolean.create(value));
    }

    int getType() {
        return 5;
    }

    void printBooleanImpl() throws IOException {
        switch (this.op) {
            case 60: {
                if (this.left.getType() == 4 && this.right.getType() == 4) {
                    this.cl.print("(");
                    this.left.printInt32();
                    this.cl.print("<");
                    this.right.printInt32();
                    this.cl.print(")");
                    break;
                }
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("<");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".lessThan(");
                this.right.print();
                this.cl.print(", false)");
                break;
            }
            case 62: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print(">");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".greaterThan(");
                this.right.print();
                this.cl.print(", false)");
                break;
            }
            case 272: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("<=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".greaterThan(");
                this.right.print();
                this.cl.print(", true)");
                break;
            }
            case 271: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print(">=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".lessThan(");
                this.right.print();
                this.cl.print(", true)");
                break;
            }
            case 273: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("==");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".ecmaEquals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 274: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("!=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.cl.print("!");
                this.left.print();
                this.cl.print(".ecmaEquals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 275: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("==");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".equals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 276: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("!=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.cl.print("!");
                this.left.print();
                this.cl.print(".equals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
    }
}

