/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;

class NativeObject
extends Native {
    static final int TO_OBJECT = 2;
    static final int TO_STRING = 3;
    static final int VALUE_OF = 4;
    static final int TO_SOURCE = 5;
    static final int WATCH = 6;
    static final int UNWATCH = 7;

    private NativeObject(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        NativeObject nativeObj = new NativeObject("Object", 2, 1);
        resin.objProto = new ESObject("Object", esBase);
        NativeWrapper obj = new NativeWrapper(resin, nativeObj, resin.objProto, 1);
        NativeObject.put(resin.objProto, "toString", 3, 0, 4);
        NativeObject.put(resin.objProto, "valueOf", 4, 0, 4);
        NativeObject.put(resin.objProto, "toSource", 5, 0, 4);
        NativeObject.put(resin.objProto, "watch", 6, 0, 4);
        NativeObject.put(resin.objProto, "unwatch", 7, 0, 4);
        resin.objProto.setClean();
        obj.setClean();
        return obj;
    }

    private static void put(ESObject obj, String name, int n, int len, int flags) {
        ESId id = ESId.intern(name);
        NativeObject fun = new NativeObject(name, n, len);
        try {
            obj.put(id, (ESBase)fun, flags);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 3: {
                ESBase arg = eval.getArg(-1);
                if (arg instanceof ESObject) {
                    return NativeObject.toString((ESObject)arg);
                }
                return NativeObject.toString(arg.toObject());
            }
            case 4: {
                ESBase arg = eval.getArg(-1);
                if (arg instanceof ESWrapper) {
                    ESWrapper obj = (ESWrapper)arg;
                    if (obj.value instanceof ESBase) {
                        return obj.value;
                    }
                    return obj.toStr();
                }
                return arg;
            }
            case 2: {
                ESBase arg;
                if (length <= 0 || (arg = eval.getArg(0)) == ESBase.esNull || arg == ESBase.esUndefined || arg == ESBase.esEmpty) {
                    return Global.getGlobalProto().createObject();
                }
                if (length > 1) {
                    return this.createObjectLiteral(eval, length);
                }
                return arg.toObject();
            }
            case 5: {
                ESObject arg = eval.getThis();
                Global.getGlobalProto().clearMark();
                IntMap map = new IntMap();
                ((ESBase)arg).toSource(map, true);
                return ((ESBase)arg).toSource(map, false);
            }
            case 6: {
                if (length < 2) {
                    throw new ESException("watch expects two arguments");
                }
                ESObject obj = eval.getThis();
                ESString key = eval.getArg(0).toStr();
                ESBase fun = eval.getArg(1);
                if (!(fun instanceof ESClosure) && !(fun instanceof Native)) {
                    throw new ESException("watch requires function");
                }
                obj.watch(key, fun);
                return esUndefined;
            }
            case 7: {
                if (length < 1) {
                    throw new ESException("unwatch expects one argument");
                }
                ESObject obj = eval.getThis();
                ESString key = eval.getArg(0).toStr();
                obj.unwatch(key);
                return esUndefined;
            }
        }
        throw new RuntimeException("Unknown object function");
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != 2) {
            return super.construct(eval, length);
        }
        if (length == 0 || eval.getArg(0) == esNull || eval.getArg(0) == esUndefined || eval.getArg(0) == esEmpty) {
            return Global.getGlobalProto().createObject();
        }
        if (length > 1) {
            return this.createObjectLiteral(eval, length);
        }
        return eval.getArg(0).toObject();
    }

    private ESBase createObjectLiteral(Call call, int length) throws Throwable {
        ESObject obj = Global.getGlobalProto().createObject();
        int i = 0;
        while (i + 1 < length) {
            ESString key = call.getArg(i, length).toStr();
            ESBase value = call.getArg(i + 1, length);
            obj.setProperty(key, value);
            i += 2;
        }
        return obj;
    }

    public static ESBase toString(ESObject obj) throws ESException {
        return ESString.create(new CharBuffer().append("[object ").append(obj.getClassName()).append("]").toString());
    }
}

