/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class NativeFile
extends Native {
    static ESId IN = ESId.intern("in");
    static ESId OUT = ESId.intern("out");
    static final int WRITE = 2;
    static final int WRITELN = 3;
    static final int FLUSH = 4;
    static final int CLOSE = 5;

    private NativeFile(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static void create(Global resin) {
        NativeFile.put(resin, "write", 2, 0, 4);
        NativeFile.put(resin, "writeln", 3, 0, 4);
        NativeFile.put(resin, "flush", 4, 0, 4);
        NativeFile.put(resin, "close", 5, 0, 4);
    }

    private static void put(Global resin, String name, int n, int len, int flags) {
        ESId id = ESId.intern(name);
        resin.addProperty(id, new NativeFile(name, n, len));
    }

    public ESBase call(Call eval, int length) throws Throwable {
        ESBase out;
        ESBase evalThis = eval.getArg(-1);
        WriteStream stream = null;
        try {
            stream = (WriteStream)evalThis.toJavaObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stream == null && (out = evalThis.hasProperty(OUT)) != null) {
            eval.setThis(out);
            return out.call(eval, length, this.id);
        }
        switch (this.n) {
            case 2: {
                return NativeFile.write(eval, length);
            }
            case 3: {
                return NativeFile.writeln(eval, length);
            }
            case 4: {
                return NativeFile.flush(eval, length);
            }
            case 5: {
                return NativeFile.close(eval, length);
            }
        }
        throw new ESException("Unknown file function");
    }

    private static WriteStream getWriteStream(Call eval) throws Throwable {
        ESBase evalThis = eval.getArg(-1);
        WriteStream stream = null;
        try {
            stream = (WriteStream)evalThis.toJavaObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stream != null) {
            return stream;
        }
        ESBase obj = evalThis.hasProperty(OUT);
        try {
            stream = (WriteStream)obj.toJavaObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        obj = Global.getGlobalProto().getGlobal().hasProperty(OUT);
        try {
            stream = (WriteStream)obj.toJavaObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stream == null) {
            throw new ESException(new CharBuffer().append("expected file as `this' or as value of `").append(OUT).append("'").toString());
        }
        return stream;
    }

    public static ESBase write(Call eval, int length) throws Throwable {
        WriteStream stream = NativeFile.getWriteStream(eval);
        try {
            for (int i = 0; i < length; ++i) {
                stream.print(eval.getArg(i).toString());
            }
        }
        catch (IOException e) {
            return ESBoolean.FALSE;
        }
        return eval.getArg(-1);
    }

    public static ESBase writeln(Call eval, int length) throws Throwable {
        WriteStream stream = NativeFile.getWriteStream(eval);
        try {
            for (int i = 0; i < length; ++i) {
                stream.print(eval.getArg(i).toString());
            }
            stream.println();
        }
        catch (IOException e) {
            return ESBoolean.FALSE;
        }
        return eval.getArg(-1);
    }

    public static ESBase flush(Call eval, int length) throws Throwable {
        WriteStream stream = NativeFile.getWriteStream(eval);
        try {
            stream.flush();
        }
        catch (IOException e) {
            return ESBoolean.FALSE;
        }
        return eval.getArg(-1);
    }

    public static ESBase close(Call eval, int length) throws Throwable {
        WriteStream stream = NativeFile.getWriteStream(eval);
        try {
            stream.close();
        }
        catch (IOException e) {
            return ESBoolean.FALSE;
        }
        return eval.getArg(-1);
    }
}

