/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.util.CharBuffer;

class Native
extends ESBase {
    static ESId CONSTRUCTOR = ESId.intern("constructor");
    static ESId LENGTH = ESId.intern("length");
    static ESId PROTOTYPE = ESId.intern("prototype");
    static final int NEW = 1;
    String name;
    ESString id;
    ESString[] formals;
    int length;
    protected int n;
    protected int newN;

    protected Native(String name, int len) {
        this.prototype = esBase;
        this.name = name;
        this.length = len;
        this.className = "Function";
        this.id = ESId.intern(name);
    }

    public ESBase getProperty(ESString key) {
        if (key.equals(LENGTH)) {
            return ESNumber.create(this.length);
        }
        return esEmpty;
    }

    public ESBase delete(ESString key) {
        return ESBoolean.create(false);
    }

    public ESBase typeof() throws ESException {
        return ESString.create("function");
    }

    public ESString toStr() {
        return ESString.create(this.decompile());
    }

    private String decompile() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("function ");
        sbuf.append(this.name);
        sbuf.append("(");
        for (int i = 0; this.formals != null && i < this.formals.length; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.formals[i]);
        }
        sbuf.append(") ");
        sbuf.append("{ ");
        sbuf.append("[native code]");
        sbuf.append(" }");
        return sbuf.toString();
    }

    public double toNum() {
        return Double.NaN;
    }

    public boolean toBoolean() {
        return true;
    }

    public ESObject toObject() {
        throw new RuntimeException();
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != this.newN) {
            return super.construct(eval, length);
        }
        try {
            return this.call(eval, length);
        }
        catch (ClassCastException e) {
            throw new ESException(new CharBuffer().append("cannot create ").append(this.name).toString());
        }
    }

    protected Native create(String name, int n, int len) {
        throw new RuntimeException("create not specialized");
    }
}

