/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNullException;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefinedException;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.util.HashMap;

public class ESBeanWrapper
extends ESBase {
    static ESId CALL = ESId.intern("call");
    protected static ESId LENGTH = ESId.intern("length");
    public int set;
    public IntMap hasDispatch;
    public IntMap setDispatch;
    public IntMap[] subGets;
    public IntMap[] subSets;
    public HashMap methods;
    public IntMap methodDispatch;
    protected Object value;
    protected String name;
    ESString[] formals;
    int length;
    public int n = -3;
    int newN;

    protected ESBeanWrapper() {
    }

    public long getVersionId() {
        return 0L;
    }

    private String decompile() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("function ");
        sbuf.append(this.name);
        sbuf.append("(");
        for (int i = 0; this.formals != null && i < this.formals.length; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.formals[i]);
        }
        sbuf.append(") ");
        sbuf.append("{ ");
        sbuf.append("[native code]");
        sbuf.append(" }");
        return sbuf.toString();
    }

    public ESString toStr() throws ESException {
        if (this.n == -1) {
            return ESString.create(this.value == null ? "null" : this.value.toString());
        }
        return ESString.create(this.decompile());
    }

    public double toNum() throws ESException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        throw new ESException(new CharBuffer().append("no number: ").append(this.getClass().getName()).toString());
    }

    public ESBase getProperty(ESString name) throws Throwable {
        ESBase value = this.hasProperty(name);
        if (value != null) {
            return value;
        }
        return esEmpty;
    }

    public ESBase hasProperty(ESString name) throws Throwable {
        return null;
    }

    public ESString toSource(IntMap map, boolean isLoopPath) throws ESException {
        if (isLoopPath) {
            return null;
        }
        return this.toStr();
    }

    public ESBase toPrimitive(int hint) throws ESException {
        if (this.value instanceof ESBase) {
            return (ESBase)this.value;
        }
        return this.toStr();
    }

    public Object toJavaObject() {
        return this.value != null ? this.value : this;
    }

    public boolean toBoolean() {
        return true;
    }

    protected ESBeanWrapper dup() {
        throw new UnsupportedOperationException();
    }

    protected ESBeanWrapper dup(int set) {
        ESBeanWrapper child = this.dup();
        child.value = this.value;
        child.set = set;
        child.hasDispatch = this.subGets[set];
        child.setDispatch = this.subSets[set];
        child.subGets = this.subGets;
        child.subSets = this.subSets;
        child.methods = this.methods;
        return child;
    }

    public ESBeanWrapper wrap(Object value) {
        throw new RuntimeException();
    }

    public ESBeanWrapper wrapStatic() {
        throw new RuntimeException();
    }

    public boolean ecmaEquals(ESBase b) {
        if (!(b instanceof ESBeanWrapper)) {
            return false;
        }
        return this.value.equals(((ESBeanWrapper)b).value);
    }

    public Object copy(HashMap refs) {
        return this;
    }

    public ESBase typeof() {
        return ESString.create("object");
    }

    public ESBase call(Call eval, int length, int n) throws Throwable {
        throw new ESNullException(new CharBuffer().append(this.toStr()).append(" is not a function").toString());
    }

    public ESBase call(Call eval, int length) throws Throwable {
        return this.call(eval, length, this.n);
    }

    public ESBase call(Call eval, int length, ESString key) throws Throwable {
        int n = this.methodDispatch.get(key);
        if (n < 0) {
            throw new ESUndefinedException(new CharBuffer().append(this.getClass().getName()).append(": undefined call `").append(key).append("'").toString());
        }
        return this.call(eval, length, n);
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != this.newN) {
            throw new ESException(new CharBuffer().append("cannot create ").append(this.name).toString());
        }
        ESBase value = this.call(eval, length);
        if (value == esUndefined || value == null) {
            throw new ESException(new CharBuffer().append("cannot create ").append(this.name).toString());
        }
        return value;
    }

    public boolean isModified() {
        return true;
    }
}

