/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.types.Period;
import com.caucho.el.ArrayExpr;
import com.caucho.el.ELExceptionImpl;
import com.caucho.el.ExprEnv;
import com.caucho.el.FunctionExpr;
import com.caucho.el.StringLiteral;
import com.caucho.log.Log;
import com.caucho.util.BeanUtil;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public abstract class Expr {
    protected static final Logger log = Log.open(Expr._resin_compat_class_0());
    protected static final L10N L = new L10N(Expr._resin_compat_class_0());
    private static final Character NULL_CHAR = new Character('\u0000');
    private static final long DAY = 86400000L;
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    static final int EQ = 6;
    static final int NE = 7;
    static final int LT = 8;
    static final int LE = 9;
    static final int GT = 10;
    static final int GE = 11;
    static final int AND = 12;
    static final int OR = 13;
    static final int NOT = 14;
    static final int MINUS = 15;
    static final int EMPTY = 16;
    static final int OBJECT = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BOOLEAN_OBJ = 8;
    static final int BYTE_OBJ = 9;
    static final int SHORT_OBJ = 10;
    static final int INT_OBJ = 11;
    static final int LONG_OBJ = 12;
    static final int FLOAT_OBJ = 13;
    static final int DOUBLE_OBJ = 14;
    static final int STRING = 15;
    static final IntMap _typeMap = new IntMap();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;

    public boolean isConstant() {
        return false;
    }

    public Expr createField(Expr field) {
        return new ArrayExpr(this, field);
    }

    public Expr createField(String field) {
        return this.createField(new StringLiteral(field));
    }

    public Expr createMethod(Expr[] args) {
        return new FunctionExpr(this, args);
    }

    public abstract Object evalObject(VariableResolver var1) throws ELException;

    public boolean evalBoolean(VariableResolver env) throws ELException {
        return Expr.toBoolean(this.evalObject(env), env);
    }

    public double evalDouble(VariableResolver env) throws ELException {
        return Expr.toDouble(this.evalObject(env), env);
    }

    public long evalLong(VariableResolver env) throws ELException {
        return Expr.toLong(this.evalObject(env), env);
    }

    public String evalString(VariableResolver env) throws ELException {
        return Expr.toString(this.evalObject(env), env);
    }

    public String evalStringNonNull(VariableResolver env) throws ELException {
        return Expr.toStringNonNull(this.evalObject(env), env);
    }

    public char evalCharacter(VariableResolver env) throws ELException {
        return Expr.toCharacter(this.evalObject(env), env);
    }

    public long evalPeriod(VariableResolver env) throws ELException {
        try {
            Object obj = this.evalObject(env);
            if (obj instanceof Number) {
                return 1000L * ((Number)obj).longValue();
            }
            return Period.toPeriod(Expr.toString(obj, env));
        }
        catch (Exception e) {
            throw new ELException(e.getMessage());
        }
    }

    public BigInteger evalBigInteger(VariableResolver env) throws ELException {
        return Expr.toBigInteger(this.evalObject(env), env);
    }

    public BigDecimal evalBigDecimal(VariableResolver env) throws ELException {
        return Expr.toBigDecimal(this.evalObject(env), env);
    }

    public boolean print(WriteStream out, VariableResolver env, boolean escapeXml) throws IOException, ELException {
        Object obj = this.evalObject(env);
        if (obj == null) {
            return true;
        }
        if (escapeXml) {
            Expr.toStreamEscaped(out, obj);
            return false;
        }
        Expr.toStream(out, obj);
        return false;
    }

    public boolean print(JspWriter out, VariableResolver env, boolean escapeXml) throws IOException, ELException {
        Object obj = this.evalObject(env);
        if (obj == null) {
            return true;
        }
        if (escapeXml) {
            Expr.toStreamEscaped((Writer)out, obj);
            return false;
        }
        Expr.toStream(out, obj);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public static String toString(Object value, VariableResolver env) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toStringNonNull(Object value, VariableResolver env) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toStringNonNull(long value, VariableResolver env) {
        return String.valueOf(value);
    }

    public static String toStringNonNull(double value, VariableResolver env) {
        return String.valueOf(value);
    }

    public static String toStringNonNull(boolean value, VariableResolver env) {
        return String.valueOf(value);
    }

    public static String toStringNonNull(char value, VariableResolver env) {
        return String.valueOf(value);
    }

    public static char toCharacter(Object value, VariableResolver env) throws ELException {
        if (value == null) {
            return '\u0000';
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return (char)number.intValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            String s = Expr.toString(value, env);
            if (s == null || s.length() == 0) {
                return '\u0000';
            }
            return s.charAt(0);
        }
        ELException e = new ELException(L.l("can't convert {0} to character.", value.getClass().getName()));
        throw e;
    }

    public static boolean toBoolean(Object value, VariableResolver env) throws ELException {
        if (value == null || value.equals("")) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("true") || value.equals("yes");
        }
        ELException e = new ELException(L.l("can't convert {0} to boolean.", value.getClass().getName()));
        throw e;
    }

    public static double toDouble(Object value, VariableResolver env) throws ELException {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            double dValue = ((Number)value).doubleValue();
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        if (value.equals("")) {
            return 0.0;
        }
        if (value instanceof String) {
            double dValue = Double.parseDouble((String)value);
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        ELException e = new ELException(L.l("can't convert {0} to double.", value.getClass().getName()));
        throw e;
    }

    public static BigDecimal toBigDecimal(Object value, VariableResolver env) throws ELException {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            double dValue = ((Number)value).doubleValue();
            return new BigDecimal(dValue);
        }
        if (value.equals("")) {
            return BigDecimal.ZERO;
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Character) {
            return new BigDecimal(((Character)value).charValue());
        }
        ELException e = new ELException(L.l("can't convert {0} to BigDecimal.", value.getClass().getName()));
        Expr.error(e, env);
        return BigDecimal.ZERO;
    }

    public static BigInteger toBigInteger(Object value, VariableResolver env) throws ELException {
        if (value == null) {
            return BigInteger.ZERO;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString()).toBigInteger();
        }
        if (value.equals("")) {
            return BigInteger.ZERO;
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        if (value instanceof Character) {
            return new BigInteger(String.valueOf((int)((Character)value).charValue()));
        }
        ELException e = new ELException(L.l("can't convert {0} to BigInteger.", value.getClass().getName()));
        Expr.error(e, env);
        return BigInteger.ZERO;
    }

    public static long toLong(Object value, VariableResolver env) throws ELException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value.equals("")) {
            return 0L;
        }
        if (value instanceof String) {
            int i;
            int sign = 1;
            String string = (String)value;
            int length = string.length();
            long intValue = 0L;
            for (i = 0; i < length && Character.isWhitespace(string.charAt(i)); ++i) {
            }
            if (length <= i) {
                return 0L;
            }
            char ch = string.charAt(i);
            if (ch == '-') {
                sign = -1;
                ++i;
            } else if (ch == '+') {
                ++i;
            }
            while (i < length && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                intValue = 10L * intValue + (long)ch - 48L;
                ++i;
            }
            while (i < length && Character.isWhitespace(string.charAt(i))) {
                ++i;
            }
            if (i < length) {
                ELException e = new ELException(L.l("can't convert '{0}' to long.", string));
                throw e;
            }
            return (long)sign * intValue;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        ELException e = new ELException(L.l("can't convert {0} to long.", value.getClass().getName()));
        throw e;
    }

    public static boolean toStream(JspWriter out, Object value, boolean isEscaped) throws IOException {
        if (value == null) {
            return true;
        }
        if (isEscaped) {
            Expr.toStreamEscaped((Writer)out, value);
        } else {
            Expr.toStream(out, value);
        }
        return false;
    }

    public static void toStream(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            out.print((String)value);
        } else if (value instanceof Reader) {
            out.writeStream((Reader)value);
        } else {
            out.print(value.toString());
        }
    }

    public static void toStream(JspWriter out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            out.print((String)value);
        } else if (value instanceof Reader) {
            int ch;
            Reader reader = (Reader)value;
            while ((ch = reader.read()) > 0) {
                out.print((char)ch);
            }
        } else {
            out.print(value.toString());
        }
    }

    public static void printEscapedString(WriteStream os, String string) throws IOException {
        int length = string.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\\': {
                    os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    os.print("\\\"");
                    continue block6;
                }
                default: {
                    os.print(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(Writer out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Reader) {
            Expr.toStreamEscaped(out, (Reader)value);
            return;
        }
        String string = value.toString();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '\'': {
                    out.write("&#039;");
                    continue block7;
                }
                case '\"': {
                    out.write("&#034;");
                    continue block7;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        String string = value.toString();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    out.print("&gt;");
                    continue block7;
                }
                case '&': {
                    out.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    out.print("&#039;");
                    continue block7;
                }
                case '\"': {
                    out.print("&#034;");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(Writer out, Reader in) throws IOException {
        int ch;
        if (in == null) {
            return;
        }
        block7: while ((ch = in.read()) >= 0) {
            switch (ch) {
                case 60: {
                    out.write("&lt;");
                    continue block7;
                }
                case 62: {
                    out.write("&gt;");
                    continue block7;
                }
                case 38: {
                    out.write("&amp;");
                    continue block7;
                }
                case 39: {
                    out.write("&#039;");
                    continue block7;
                }
                case 34: {
                    out.write("&#034;");
                    continue block7;
                }
            }
            out.write((char)ch);
        }
    }

    public static void printEscaped(WriteStream os, ReadStream is) throws IOException {
        int ch;
        block6: while ((ch = is.readChar()) >= 0) {
            switch (ch) {
                case 92: {
                    os.print("\\\\");
                    continue block6;
                }
                case 10: {
                    os.print("\\n");
                    continue block6;
                }
                case 13: {
                    os.print("\\r");
                    continue block6;
                }
                case 34: {
                    os.print("\\\"");
                    continue block6;
                }
            }
            os.print((char)ch);
        }
    }

    public static void setProperty(Object target, String property, Object value) throws ELException {
        if (target instanceof Map) {
            Map map = (Map)target;
            if (value != null) {
                map.put(property, value);
            } else {
                map.remove(property);
            }
        } else if (target != null) {
            Method method = null;
            try {
                method = BeanUtil.getSetMethod(target.getClass(), property);
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
            if (method == null) {
                throw new ELException(L.l("can't find property `{0}' in `{1}'", (Object)property, target.getClass()));
            }
            Class<?> type = method.getParameterTypes()[0];
            try {
                int code = _typeMap.get(type);
                switch (code) {
                    case 1: {
                        value = Expr.toBoolean(value, null) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 2: {
                        value = new Byte((byte)Expr.toLong(value, null));
                        break;
                    }
                    case 3: {
                        value = new Short((short)Expr.toLong(value, null));
                        break;
                    }
                    case 4: {
                        value = new Integer((int)Expr.toLong(value, null));
                        break;
                    }
                    case 5: {
                        value = new Long(Expr.toLong(value, null));
                        break;
                    }
                    case 6: {
                        value = new Float((float)Expr.toDouble(value, null));
                        break;
                    }
                    case 7: {
                        value = new Double(Expr.toDouble(value, null));
                        break;
                    }
                    case 8: {
                        if (value == null) break;
                        value = Expr.toBoolean(value, null) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 9: {
                        if (value == null) break;
                        value = new Byte((byte)Expr.toLong(value, null));
                        break;
                    }
                    case 10: {
                        if (value == null) break;
                        value = new Short((short)Expr.toLong(value, null));
                        break;
                    }
                    case 11: {
                        if (value == null) break;
                        value = new Integer((int)Expr.toLong(value, null));
                        break;
                    }
                    case 12: {
                        if (value == null) break;
                        value = new Long(Expr.toLong(value, null));
                        break;
                    }
                    case 13: {
                        if (value == null) break;
                        value = new Float((float)Expr.toDouble(value, null));
                        break;
                    }
                    case 14: {
                        if (value == null) break;
                        value = new Double(Expr.toDouble(value, null));
                        break;
                    }
                    case 15: {
                        if (value == null) break;
                        value = String.valueOf(value);
                        break;
                    }
                }
                method.invoke(target, value);
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
        }
    }

    public static Object error(Throwable e, VariableResolver env) throws ELException {
        if (env == null) {
            throw ELExceptionImpl.create(e);
        }
        if (env instanceof ExprEnv && !((ExprEnv)env).isIgnoreException()) {
            throw ELExceptionImpl.create(e);
        }
        log.log(Level.FINE, e.toString(), e);
        return null;
    }

    public static Object invocationError(Throwable e) throws ELException {
        if (e instanceof InvocationTargetException && e.getCause() != null) {
            throw ELExceptionImpl.create(e.getCause());
        }
        throw ELExceptionImpl.create(e);
    }

    static {
        _typeMap.put(Boolean.TYPE, 1);
        _typeMap.put(Byte.TYPE, 2);
        _typeMap.put(Short.TYPE, 3);
        _typeMap.put(Integer.TYPE, 4);
        _typeMap.put(Long.TYPE, 5);
        _typeMap.put(Float.TYPE, 6);
        _typeMap.put(Double.TYPE, 7);
        _typeMap.put(Expr._resin_compat_class_1(), 8);
        _typeMap.put(Expr._resin_compat_class_2(), 9);
        _typeMap.put(Expr._resin_compat_class_3(), 10);
        _typeMap.put(Expr._resin_compat_class_4(), 11);
        _typeMap.put(Expr._resin_compat_class_5(), 12);
        _typeMap.put(Expr._resin_compat_class_6(), 13);
        _typeMap.put(Expr._resin_compat_class_7(), 14);
        _typeMap.put(Expr._resin_compat_class_8(), 15);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.el.Expr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Boolean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

