/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class BooleanExpr
extends AbstractBooleanExpr {
    private int _op;
    private Expr _left;
    private Expr _right;

    public BooleanExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        if (this._op == 12) {
            return this._left.evalBoolean(env) && this._right.evalBoolean(env);
        }
        if (this._op == 13) {
            return this._left.evalBoolean(env) || this._right.evalBoolean(env);
        }
        ELException e = new ELException(L.l("can't compare."));
        log.log(Level.FINE, e.getMessage(), e);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.BooleanExpr(");
        os.print(new CharBuffer().append(this._op).append(", ").toString());
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanExpr)) {
            return false;
        }
        BooleanExpr expr = (BooleanExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 13: {
                op = " or ";
                break;
            }
            case 12: {
                op = " and ";
                break;
            }
            default: {
                op = new CharBuffer().append(" unknown(").append(this._op).append(") ").toString();
            }
        }
        return new CharBuffer().append("(").append(this._left).append(op).append(this._right).append(")").toString();
    }
}

