/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class BinaryExpr
extends Expr {
    private int _op;
    private Expr _left;
    private Expr _right;

    public BinaryExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public Object evalObject(VariableResolver env) throws ELException {
        long b;
        long a;
        Object aObj = this._left.evalObject(env);
        Object bObj = this._right.evalObject(env);
        if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
            BigDecimal a2 = BinaryExpr.toBigDecimal(aObj, env);
            BigDecimal b2 = BinaryExpr.toBigDecimal(bObj, env);
            switch (this._op) {
                case 1: {
                    return a2.add(b2);
                }
                case 2: {
                    return a2.subtract(b2);
                }
                case 3: {
                    return a2.multiply(b2);
                }
                case 4: {
                    return a2.divide(b2, 4);
                }
                case 5: {
                    double da = BinaryExpr.toDouble(aObj, env);
                    double db = BinaryExpr.toDouble(bObj, env);
                    return new Double(da % db);
                }
            }
            throw new IllegalStateException();
        }
        if (aObj instanceof BigInteger || bObj instanceof BigInteger) {
            BigInteger a3 = BinaryExpr.toBigInteger(aObj, env);
            BigInteger b3 = BinaryExpr.toBigInteger(bObj, env);
            switch (this._op) {
                case 1: {
                    return a3.add(b3);
                }
                case 2: {
                    return a3.subtract(b3);
                }
                case 3: {
                    return a3.multiply(b3);
                }
                case 4: {
                    BigDecimal da = BinaryExpr.toBigDecimal(aObj, env);
                    BigDecimal db = BinaryExpr.toBigDecimal(bObj, env);
                    return da.divide(db, 4);
                }
                case 5: {
                    if (aObj instanceof Float || aObj instanceof Double || bObj instanceof Float || bObj instanceof Double) {
                        double da = BinaryExpr.toDouble(aObj, env);
                        double db = BinaryExpr.toDouble(bObj, env);
                        return new Double(da % db);
                    }
                    return a3.remainder(b3);
                }
            }
            throw new IllegalStateException();
        }
        if (aObj instanceof Float || aObj instanceof Double || bObj instanceof Float || bObj instanceof Double) {
            double a4 = BinaryExpr.toDouble(aObj, env);
            double b4 = BinaryExpr.toDouble(bObj, env);
            double dValue = 0.0;
            switch (this._op) {
                case 1: {
                    dValue = a4 + b4;
                    break;
                }
                case 2: {
                    dValue = a4 - b4;
                    break;
                }
                case 3: {
                    dValue = a4 * b4;
                    break;
                }
                case 4: {
                    dValue = a4 / b4;
                    break;
                }
                case 5: {
                    dValue = a4 % b4;
                }
            }
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj == null && bObj == null) {
            return new Integer(0);
        }
        if (bObj instanceof Double || bObj instanceof Double) {
            double a5 = BinaryExpr.toDouble(aObj, env);
            double b5 = ((Number)bObj).doubleValue();
            double dValue = 0.0;
            switch (this._op) {
                case 1: {
                    dValue = a5 + b5;
                    break;
                }
                case 2: {
                    dValue = a5 - b5;
                    break;
                }
                case 3: {
                    dValue = a5 * b5;
                    break;
                }
                case 4: {
                    dValue = a5 / b5;
                    break;
                }
                case 5: {
                    dValue = a5 % b5;
                }
            }
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof Number) {
            a = ((Number)aObj).longValue();
            b = BinaryExpr.toLong(bObj, env);
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        } else if (bObj instanceof Number) {
            a = BinaryExpr.toLong(aObj, env);
            b = ((Number)bObj).longValue();
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        }
        if (BinaryExpr.isDoubleString(aObj) || BinaryExpr.isDoubleString(bObj)) {
            double a6 = BinaryExpr.toDouble(aObj, env);
            double b6 = BinaryExpr.toDouble(bObj, env);
            switch (this._op) {
                case 1: {
                    return new Double(a6 + b6);
                }
                case 2: {
                    return new Double(a6 - b6);
                }
                case 3: {
                    return new Double(a6 * b6);
                }
                case 4: {
                    double dValue = a6 / b6;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Double(a6 % b6);
                }
            }
        } else {
            a = BinaryExpr.toLong(aObj, env);
            b = BinaryExpr.toLong(bObj, env);
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        }
        return null;
    }

    private static boolean isDoubleString(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String s = (String)obj;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' && ch != 'e' && ch != 'E') continue;
            return true;
        }
        return false;
    }

    public long evalLong(VariableResolver env) throws ELException {
        long a = this._left.evalLong(env);
        long b = this._right.evalLong(env);
        switch (this._op) {
            case 1: {
                return a + b;
            }
            case 2: {
                return a - b;
            }
            case 3: {
                return a * b;
            }
            case 4: {
                return (long)((double)a / (double)b);
            }
            case 5: {
                return a % b;
            }
        }
        ELException e = new ELException(L.l("error evaluating add {0} and {1}", (Object)String.valueOf(a), String.valueOf(b)));
        BinaryExpr.error(e, env);
        return 0L;
    }

    public double evalDouble(VariableResolver env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        switch (this._op) {
            case 1: {
                return a + b;
            }
            case 2: {
                return a - b;
            }
            case 3: {
                return a * b;
            }
            case 4: {
                return a / b;
            }
            case 5: {
                return a % b;
            }
        }
        ELException e = new ELException(L.l("error evaluating add {0} and {1}", (Object)String.valueOf(a), String.valueOf(b)));
        BinaryExpr.error(e, env);
        return 0.0;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.BinaryExpr(");
        os.print(new CharBuffer().append(this._op).append(", ").toString());
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryExpr)) {
            return false;
        }
        BinaryExpr expr = (BinaryExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 1: {
                op = " + ";
                break;
            }
            case 2: {
                op = " - ";
                break;
            }
            case 3: {
                op = " * ";
                break;
            }
            case 4: {
                op = " / ";
                break;
            }
            case 5: {
                op = " % ";
                break;
            }
            default: {
                op = new CharBuffer().append(" unknown(").append(this._op).append(") ").toString();
            }
        }
        return new CharBuffer().append("(").append(this._left).append(op).append(this._right).append(")").toString();
    }
}

