/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.JVMObject;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.SessionObject;
import com.caucho.ejb.session.StatefulContext;
import com.caucho.ejb.session.StatefulJndiFactory;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;

public class SessionServer
extends AbstractServer {
    protected static final Logger log = Log.open(SessionServer._resin_compat_class_0());
    private StatefulContext _homeContext;
    private LruCache<Object, AbstractSessionContext> _sessions = new LruCache(1024);
    private boolean _isClosed;
    private static Class _resin_compat_class_0;

    public SessionServer(EjbServerManager manager) {
        super(manager);
    }

    public void init() throws Exception {
        this._localHome = this.getSessionContext().createLocalHome();
        this._remoteHomeView = this.getSessionContext().createRemoteHomeView();
        log.config(new CharBuffer().append("initialized session bean: ").append(this).toString());
    }

    public Class getPrimaryKeyClass() {
        return null;
    }

    public EJBLocalHome getEJBLocalHome() {
        return this._localHome;
    }

    public EJBHome getEJBHome() throws RemoteException {
        return this._remoteHomeView;
    }

    public Object getHomeObject() {
        return this._remoteHomeView;
    }

    public Object getClientObject() {
        return new StatefulJndiFactory(this);
    }

    Object newInstance() {
        return this._homeContext._caucho_newInstance();
    }

    SessionObject getEJBLocalObject(SessionBean bean) {
        try {
            SessionObject obj = null;
            if (obj == null) {
                throw new IllegalStateException("bean has no local interface");
            }
            return obj;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    JVMObject createEJBObject(Object primaryKey) {
        try {
            JVMObject obj = (JVMObject)this._remoteStubClass.newInstance();
            obj._init(this, primaryKey);
            return obj;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    AbstractHandle createHandle(AbstractContext context) {
        String key = ((AbstractSessionContext)context).getPrimaryKey();
        return this.getHandleEncoder().createHandle(key);
    }

    public String createSessionKey(AbstractSessionContext context) {
        String key = this.getHandleEncoder().createRandomStringKey();
        this._sessions.put(key, context);
        return key;
    }

    public AbstractContext getContext(Object key, boolean forceLoad) throws FinderException {
        if (key == null) {
            return null;
        }
        AbstractSessionContext cxt = this._sessions.get(key);
        if (cxt == null) {
            throw new FinderException(new CharBuffer().append("no matching object:").append(key).toString());
        }
        return cxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSessionContext getSessionContext() {
        SessionServer sessionServer = this;
        synchronized (sessionServer) {
            if (this._homeContext == null) {
                try {
                    Class[] param = new Class[]{SessionServer._resin_compat_class_0()};
                    Constructor cons = this._contextImplClass.getConstructor(param);
                    this._homeContext = (StatefulContext)cons.newInstance(this);
                }
                catch (Exception e) {
                    throw new EJBExceptionWrapper(e);
                }
            }
        }
        return this._homeContext;
    }

    public void addSession(AbstractSessionContext context) {
        this.createSessionKey(context);
    }

    public void remove(AbstractHandle handle) {
        this._sessions.remove(handle.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SessionServer sessionServer = this;
        synchronized (sessionServer) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        ArrayList<AbstractSessionContext> values = new ArrayList<AbstractSessionContext>();
        Iterator<AbstractSessionContext> iter = this._sessions.values();
        while (iter.hasNext()) {
            values.add(iter.next());
        }
        this._sessions = null;
        log.fine(new CharBuffer().append("closing session server ").append(this).toString());
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            AbstractSessionContext cxt = (AbstractSessionContext)i$.next();
            try {
                cxt.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        super.destroy();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.session.SessionServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

