/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.util.CharBuffer;

class LikeExpr
extends Expr {
    private Expr _value;
    private Expr _pattern;
    private String _escape;
    private boolean _isNot;

    LikeExpr(Expr value, Expr pattern, String escape, boolean isNot) throws ConfigException {
        this._value = value;
        this._pattern = pattern;
        this._escape = escape;
        this._isNot = isNot;
        this.evalTypes();
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        if (!this._value.isString()) {
            throw this.error(L.l("LIKE value `{0}' must be a string expression", this._value));
        }
        if (!this._pattern.isString()) {
            throw this.error(L.l("LIKE pattern `{0}' must be a string expression.", this._pattern));
        }
        this.setJavaType(Boolean.TYPE);
    }

    void generateWhere(CharBuffer cb) {
        this._value.generateWhereSubExpr(cb);
        if (this._isNot) {
            cb.append(" NOT LIKE ");
        } else {
            cb.append(" LIKE ");
        }
        this._pattern.generateWhereSubExpr(cb);
        if (this._escape != null) {
            cb.append(" ESCAPE ");
            cb.append(this._escape);
        }
    }

    public String toString() {
        String not;
        String string = not = this._isNot ? "NOT " : "";
        if (this._escape != null) {
            return new CharBuffer().append(not).append(this._pattern).append(" ESCAPE ").append(this._escape).toString();
        }
        return new CharBuffer().append(not).append(this._pattern).toString();
    }
}

