/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.ql.Expr;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunExpr
extends Expr {
    static ArrayList<FunctionSignature> _standardFunctions = new ArrayList();
    private String _name;
    private ArrayList<Expr> _args;
    private ArrayList<FunctionSignature> _functions;
    private FunctionSignature _sig;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    FunExpr(String name, ArrayList<Expr> args, ArrayList<FunctionSignature> functions) throws ConfigException {
        this._name = name;
        this._args = args;
        this._functions = functions;
        this.evalTypes();
    }

    @Override
    void evalTypes() throws ConfigException {
        Class[] argTypes = this.getArgTypes();
        this._sig = null;
        for (int i = 0; i < this._functions.size(); ++i) {
            FunctionSignature sig = this._functions.get(i);
            if (!this._name.equalsIgnoreCase(sig.getName())) continue;
            this._sig = sig;
            Class[] funArgs = sig.getParameterTypes();
            if (funArgs.length != argTypes.length) continue;
            boolean isMatch = true;
            for (int j = 0; isMatch && j < funArgs.length; ++j) {
                if (argTypes[j].equals(funArgs[j]) || FunExpr._resin_compat_class_0().equals(funArgs[j]) || (Double.TYPE.equals(funArgs[j]) || Integer.TYPE.equals(funArgs[j])) && (Double.TYPE.equals(argTypes[j]) || Integer.TYPE.equals(argTypes[j]))) continue;
                isMatch = false;
            }
            if (!isMatch) continue;
            this._sig = sig;
            this.setJavaType(sig.getReturnType());
            return;
        }
        if (this._sig != null) {
            throw this.error(L.l("`{0}' signature does not match `{1}'", (Object)this._name, this._sig.getSignature()));
        }
        throw this.error(L.l("unknown function `{0}'", this._name));
    }

    private Class[] getArgTypes() {
        ArrayList<Class> argTypes = new ArrayList<Class>();
        for (int i = 0; i < this._args.size(); ++i) {
            Expr expr = this._args.get(i);
            if (expr.isBoolean()) {
                argTypes.add(Boolean.TYPE);
                continue;
            }
            if (expr.isInteger()) {
                argTypes.add(Integer.TYPE);
                continue;
            }
            if (expr.isNumeric()) {
                argTypes.add(Double.TYPE);
                continue;
            }
            if (expr.isDate()) {
                argTypes.add(FunExpr._resin_compat_class_1());
                continue;
            }
            if (expr.isString()) {
                argTypes.add(FunExpr._resin_compat_class_2());
                continue;
            }
            argTypes.add(FunExpr._resin_compat_class_0());
        }
        return argTypes.toArray(new Class[argTypes.size()]);
    }

    @Override
    void generateWhere(CharBuffer cb) {
        if (this._sig != null && this._sig.getSQL() != null) {
            this.generateWhereSQL(cb, this._sig.getSQL());
        } else {
            cb.append(this._name);
            cb.append("(");
            for (int i = 0; i < this._args.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                Expr expr = this._args.get(i);
                expr.generateWhere(cb);
            }
            cb.append(")");
        }
    }

    void generateWhereSQL(CharBuffer cb, String sql) {
        for (int i = 0; i < sql.length(); ++i) {
            char ch1;
            char ch = sql.charAt(i);
            if (ch == '?' && i + 1 < sql.length() && (ch1 = sql.charAt(i + 1)) >= '1' && ch1 <= '9') {
                int index = ch1 - 48;
                ++i;
                if (index <= 0 || this._args.size() < index) {
                    throw new IllegalStateException(L.l("illegal argument for sql `{0}'", sql));
                }
                this._args.get(index - 1).generateWhere(cb);
                continue;
            }
            cb.append(ch);
        }
    }

    @Override
    void generateSelect(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append(this._name);
        cb.append("(");
        for (int i = 0; i < this._args.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._args.get(i));
        }
        cb.append(")");
        return cb.toString();
    }

    public static ArrayList<FunctionSignature> getStandardFunctions() {
        return (ArrayList)_standardFunctions.clone();
    }

    static void addFunction(String signature) {
        try {
            FunctionSignature sig = new FunctionSignature(signature);
            _standardFunctions.add(sig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        FunExpr.addFunction("int abs(int)");
        FunExpr.addFunction("double abs(double)");
        FunExpr.addFunction("double acos(double)");
        FunExpr.addFunction("double sin(double)");
        FunExpr.addFunction("double atan(double)");
        FunExpr.addFunction("double cos(double)");
        FunExpr.addFunction("double cot(double)");
        FunExpr.addFunction("double degrees(double)");
        FunExpr.addFunction("double exp(double)");
        FunExpr.addFunction("double log(double)");
        FunExpr.addFunction("double log10(double)");
        FunExpr.addFunction("double radians(double)");
        FunExpr.addFunction("double sin(double)");
        FunExpr.addFunction("double sqrt(double)");
        FunExpr.addFunction("double tan(double)");
        FunExpr.addFunction("double pi()");
        FunExpr.addFunction("int ceiling(double)");
        FunExpr.addFunction("int floor(double)");
        FunExpr.addFunction("int sign(double)");
        FunExpr.addFunction("double atan2(double, double)");
        FunExpr.addFunction("double power(double, double)");
        FunExpr.addFunction("double round(double, double)");
        FunExpr.addFunction("double truncate(double, double)");
        FunExpr.addFunction("int mod()");
        FunExpr.addFunction("int rand()");
        FunExpr.addFunction("int count(any)");
        FunExpr.addFunction("double sum(any)");
        FunExpr.addFunction("int min(int)");
        FunExpr.addFunction("int max(int)");
        FunExpr.addFunction("double min(double)");
        FunExpr.addFunction("double max(double)");
        FunExpr.addFunction("int ascii(String)");
        FunExpr.addFunction("int length(String)");
        FunExpr.addFunction("String char(int)");
        FunExpr.addFunction("String space(int)");
        FunExpr.addFunction("String concat(String, String)");
        FunExpr.addFunction("int difference(String, String)");
        FunExpr.addFunction("String insert(String, int, int, String)");
        FunExpr.addFunction("String lcase(String)");
        FunExpr.addFunction("String ltrim(String)");
        FunExpr.addFunction("String rtrim(String)");
        FunExpr.addFunction("String ucase(String)");
        FunExpr.addFunction("String soundex(String)");
        FunExpr.addFunction("String left(String, int)");
        FunExpr.addFunction("String repeat(String, int)");
        FunExpr.addFunction("String right(String, int)");
        FunExpr.addFunction("int locate(String, String)");
        FunExpr.addFunction("int locate(String, String, int)");
        FunExpr.addFunction("String replace(String, String, String)");
        FunExpr.addFunction("String substring(String, int, int)");
        FunExpr.addFunction("String database()");
        FunExpr.addFunction("String user()");
        FunExpr.addFunction("Date curdate()");
        FunExpr.addFunction("Date curtime()");
        FunExpr.addFunction("Date now()");
        FunExpr.addFunction("String dayname(Date)");
        FunExpr.addFunction("String monthname(Date)");
        FunExpr.addFunction("int dayofmonth(Date)");
        FunExpr.addFunction("int dayofweek(Date)");
        FunExpr.addFunction("int dayofyear(Date)");
        FunExpr.addFunction("int hour(Date)");
        FunExpr.addFunction("int minute(Date)");
        FunExpr.addFunction("int month(Date)");
        FunExpr.addFunction("int quarter(Date)");
        FunExpr.addFunction("int second(Date)");
        FunExpr.addFunction("int week(Date)");
        FunExpr.addFunction("int year(Date)");
        FunExpr.addFunction("Date timestampadd(Date, Date)");
        FunExpr.addFunction("Date timestampdiff(Date, Date)");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.util.Date");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

