/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.FieldExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr {
    static final Logger log = Log.open(Expr._resin_compat_class_1());
    static final L10N L = new L10N(Expr._resin_compat_class_1());
    protected Query _query;
    private JClass _javaType;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public JClass getJavaType() {
        return this._javaType;
    }

    void setJavaType(JClass javaType) {
        this._javaType = javaType;
    }

    void setJavaType(Class javaType) {
        this.setJavaType(JClassLoader.localForName(javaType.getName()));
    }

    String getReturnEJB() {
        return null;
    }

    boolean isKey() {
        return this.getReturnEJB() != null;
    }

    boolean isNumeric() {
        JClass type = this.getJavaType();
        if (type == null) {
            return false;
        }
        String typeName = type.getName();
        if ("java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.Double".equals(typeName)) {
            return true;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        return !typeName.equals("boolean") && !typeName.equals("char");
    }

    boolean isInteger() {
        JClass type = this.getJavaType();
        String typeName = type.getName();
        return "java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "byte".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName);
    }

    static boolean isInteger(JClass type) {
        String typeName = type.getName();
        return "java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "byte".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName);
    }

    int getComponentCount() {
        return 1;
    }

    boolean isString() {
        JClass type = this.getJavaType();
        String typeName = type.getName();
        return "java.lang.String".equals(typeName) || "char".equals(typeName) || "java.lang.Character".equals(typeName);
    }

    boolean isBoolean() {
        JClass type = this.getJavaType();
        String typeName = type.getName();
        return "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    boolean isDate() {
        JClass type = this.getJavaType();
        String typeName = type.getName();
        return "java.util.Date".equals(typeName) || "java.sql.Timestamp".equals(typeName) || "java.sql.Date".equals(typeName) || "java.sql.Time".equals(typeName);
    }

    boolean canCoerce() {
        return false;
    }

    boolean isCollection() {
        JClass type = this.getJavaType();
        return type.isAssignableTo(Expr._resin_compat_class_0());
    }

    boolean isExternal() {
        return false;
    }

    EjbEntityBean getItemBean() {
        return null;
    }

    Expr newField(String field) throws ConfigException {
        throw this.error(L.l("`{0}' can't have field `{1}'.  Only path expressions referring to a single bean have fields.", (Object)this, field));
    }

    FieldExpr newReference(String field) throws ConfigException {
        throw this.error(L.l("`{0}' can't have reference `{1}'", (Object)this, field));
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() == null) {
            throw this.error(new CharBuffer().append(L.l("'{0}' has no type.", this)).append(this.getClass()).toString());
        }
    }

    void generateSelect(CharBuffer cb) {
        this.generateWhere(cb);
    }

    String getSelectTable(CharBuffer cb) throws ConfigException {
        throw new IllegalStateException(L.l("`{0}' can't be used in a SELECT expression", this));
    }

    void generateWhere(CharBuffer cb) {
        throw new IllegalStateException(L.l("{0}: '{1}' can't be used in a WHERE expression", (Object)this.getClass().getName(), this));
    }

    void generateWhereSubExpr(CharBuffer cb) {
        this.generateWhere(cb);
    }

    void generateComponent(CharBuffer cb, int i) {
        if (i != 0) {
            throw new IllegalStateException(L.l("`{0}' can't be used in a WHERE multi-component", this));
        }
        this.generateWhereSubExpr(cb);
    }

    protected String keyComponent(EntityType type, int index) {
        ArrayList<String> names = new ArrayList<String>();
        this.addKeys(names, type, "");
        Collections.sort(names);
        return names.get(index);
    }

    protected void addKeys(ArrayList<String> names, EntityType type, String prefix) {
        for (IdField key : type.getId().getKeys()) {
            if (key instanceof KeyManyToOneField) {
                KeyManyToOneField manyToOne = (KeyManyToOneField)key;
                this.addKeys(names, manyToOne.getEntityType(), new CharBuffer().append(prefix).append(key.getName()).append(".").toString());
                continue;
            }
            names.add(new CharBuffer().append(prefix).append(key.getName()).toString());
        }
    }

    ConfigException error(String msg) {
        if (this._query != null) {
            return this._query.error(msg);
        }
        return new ConfigException(msg);
    }

    ConfigException error(Query query, String msg) {
        return query.error(msg);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.util.Collection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.ejb.ql.Expr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

