/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class ArgExpr
extends Expr {
    private int _index;
    private Class _coerceType;
    private static Class _resin_compat_class_0;

    ArgExpr(Query query, int index) throws ConfigException {
        this._query = query;
        this._index = index;
        this.evalTypes();
    }

    int getIndex() {
        return this._query.getArgIndex(this._index);
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        JMethod method = this._query.getMethod();
        JClass[] args = method.getParameterTypes();
        if (args.length <= this._index - 1) {
            throw this.error(L.l("`{0}' exceeds number of arguments", new CharBuffer().append("?").append(this._index).toString()));
        }
        this.setJavaType(args[this._index - 1]);
        this._query.setArgSize(this._index, this.getComponentCount());
    }

    void setCoerceType(Class javaType) {
        this._coerceType = javaType;
    }

    boolean canCoerce() {
        return true;
    }

    int getComponentCount() {
        JClass javaType = this.getJavaType();
        if (javaType.isPrimitive() || javaType.isArray() || javaType.getName().startsWith("java.")) {
            return 1;
        }
        if (javaType.isAssignableTo(ArgExpr._resin_compat_class_0())) {
            EjbEntityBean bean = this._query.getConfig().findEntityByLocal(javaType);
            EntityType type = bean.getEntityType();
            return type.getId().getKeys().size();
        }
        JField[] fields = javaType.getFields();
        return fields.length;
    }

    void generateWhere(CharBuffer cb) {
        cb.append(new CharBuffer().append("?").append(this.getIndex()).toString());
    }

    void generateComponent(CharBuffer cb, int index) {
        cb.append(new CharBuffer().append("?").append(this.getIndex() + index).toString());
    }

    public String toString() {
        return new CharBuffer().append("?").append(this._index).toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

