/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EnvServerManager;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.IiopProtocolContainer;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.log.Log;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.MemoryModel;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ejb.EJBLocalHome;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbProtocolManager {
    private static final L10N L = new L10N(EjbProtocolManager._resin_compat_class_0());
    protected static final Logger log = Log.open(EjbProtocolManager._resin_compat_class_0());
    private static ThreadLocal<String> _protocolLocal = new ThreadLocal();
    private static Hashtable<String, WeakReference<AbstractServer>> _staticServerMap = new Hashtable();
    private EnvServerManager _ejbServer;
    private AbstractModel _namingRoot;
    private String _cmpJndiName = "java:comp/env/cmp";
    private HashMap<String, AbstractServer> _serverMap = new HashMap();
    protected ProtocolContainer _protocolContainer;
    protected HashMap<String, ProtocolContainer> _protocolMap = new HashMap();
    private static Class _resin_compat_class_0;

    public EjbProtocolManager(EnvServerManager ejbServer) throws ConfigException {
        this._ejbServer = ejbServer;
        this._namingRoot = new MemoryModel();
        IiopProtocolContainer iiop = IiopProtocolContainer.createProtocolContainer();
        if (iiop != null) {
            this._protocolMap.put("iiop", iiop);
        }
    }

    public EnvServerManager getServerManager() {
        return this._ejbServer;
    }

    public AbstractModel getNamingRoot() {
        return this._namingRoot;
    }

    public void init() throws NamingException {
    }

    public static String getThreadProtocol() {
        return _protocolLocal.get();
    }

    public static String setThreadProtocol(String protocol) {
        String oldProtocol = _protocolLocal.get();
        _protocolLocal.set(protocol);
        return oldProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolContainer(ProtocolContainer protocol) {
        this._protocolContainer = protocol;
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            this._protocolMap.put(protocol.getName(), protocol);
        }
        this.addProtocolServers(protocol);
    }

    public void addProtocolContainer(ProtocolContainer protocol) {
        if (this._protocolContainer == null) {
            this._protocolContainer = protocol;
        }
        this.addProtocolContainer(protocol.getName(), protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolContainer(String name, ProtocolContainer protocol) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            if (this._protocolMap.get(name) == null) {
                this._protocolMap.put(name, protocol);
            }
        }
        this.addProtocolServers(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolContainer getProtocol(String name) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            return this._protocolMap.get(name);
        }
    }

    private void addProtocolServers(ProtocolContainer protocol) {
        for (AbstractServer server : this._serverMap.values()) {
            protocol.addServer(server);
        }
    }

    public static AbstractServer getJVMServer(String serverId) {
        WeakReference<AbstractServer> serverRef = _staticServerMap.get(serverId);
        return serverRef != null ? (AbstractServer)serverRef.get() : null;
    }

    public void addServer(AbstractServer server) throws NamingException {
        this._serverMap.put(server.getEJBName(), server);
        this.addLocalServer(server);
        this.addRemoteServer(server);
    }

    public void removeServer(AbstractServer server) throws NamingException {
        this.removeRemoteServer(server);
    }

    public void addLocalServer(AbstractServer server) throws NamingException {
        String ejbName = server.getEJBName();
        AbstractModel model = this._namingRoot;
        while (ejbName.startsWith("/")) {
            ejbName = ejbName.substring(1);
        }
        while (ejbName.endsWith("/")) {
            ejbName = ejbName.substring(ejbName.length() - 1);
        }
        String[] split = ejbName.split("/+");
        for (int i = 0; i < split.length - 1; ++i) {
            model = model.lookup(split[i]) != null ? (AbstractModel)model.lookup(split[i]) : model.createSubcontext(split[i]);
        }
        EJBLocalHome home = server.getEJBLocalHome();
        if (home != null) {
            model.bind(split[split.length - 1], home);
        } else if (server.getClientObject() != null) {
            model.bind(split[split.length - 1], server.getClientObject());
        }
    }

    public void addRemoteServer(AbstractServer server) throws NamingException {
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.addServer(server);
        }
    }

    public void removeRemoteServer(AbstractServer server) throws NamingException {
        String ejbName = server.getEJBName();
        while (ejbName.startsWith("/")) {
            ejbName = ejbName.substring(1);
        }
        while (ejbName.endsWith("/")) {
            ejbName = ejbName.substring(ejbName.length() - 1);
        }
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.removeServer(server);
        }
    }

    public void deployEJB(String ejbName, AbstractServer server) {
    }

    public void deployJNDI(String jndiName, AbstractServer server) throws Exception {
        InitialContext ic = new InitialContext();
        ic.rebind(jndiName, (Object)this);
    }

    public AbstractServer getServerByEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = new CharBuffer().append("/").append(ejbName).toString();
        }
        return this._serverMap.get(ejbName);
    }

    public Iterator getLocalNames() {
        return this._serverMap.keySet().iterator();
    }

    public ArrayList<String> getLocalChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = new CharBuffer().append("/").append(ejbName).toString();
        }
        if (!ejbName.endsWith("/")) {
            ejbName = new CharBuffer().append(ejbName).append("/").toString();
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            int prefixLength;
            int p;
            AbstractServer server = this._serverMap.get(name);
            if (server.getClientObject() == null || !name.startsWith(ejbName) || children.contains(name = (p = name.indexOf(47, prefixLength = ejbName.length())) > 0 ? name.substring(prefixLength, p) : name.substring(prefixLength))) continue;
            children.add(name);
        }
        return children;
    }

    public ArrayList<String> getRemoteChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = new CharBuffer().append("/").append(ejbName).toString();
        }
        if (!ejbName.endsWith("/")) {
            ejbName = new CharBuffer().append(ejbName).append("/").toString();
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            int prefixLength;
            int p;
            AbstractServer server = this._serverMap.get(name);
            if (server.getRemoteObjectClass() == null || !name.startsWith(ejbName) || children.contains(name = (p = name.indexOf(47, prefixLength = ejbName.length())) > 0 ? name.substring(prefixLength, p) : name.substring(prefixLength))) continue;
            children.add(name);
        }
        if (children.size() == 0) {
            return null;
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass, String protocolName) throws ConfigException {
        ProtocolContainer protocol = null;
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            protocol = this._protocolMap.get(protocolName);
        }
        if (protocol != null) {
            return protocol.createHandleEncoder(server, primaryKeyClass);
        }
        if (this._protocolContainer != null) {
            return this._protocolContainer.createHandleEncoder(server, primaryKeyClass);
        }
        return new HandleEncoder(server, server.getEJBName());
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        if (this._protocolContainer != null) {
            return this._protocolContainer.createHandleEncoder(server, primaryKeyClass);
        }
        return new HandleEncoder(server, server.getEJBName());
    }

    protected void remove(AbstractHandle handle) {
    }

    public void destroy() {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.protocol.EjbProtocolManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

