/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;

public abstract class ClientContainer {
    protected static L10N L = new L10N(ClientContainer._resin_compat_class_1());
    protected static Logger log = Log.open(ClientContainer._resin_compat_class_1());
    static final String CLIENT_KEY = "caucho.ejb.client";
    String _serverId;
    EJBLocalHome _localHomeStub;
    EJBHome _remoteHomeStub;
    LruCache<String, EJBObject> _stubMap = new LruCache(1024);
    protected HandleEncoder _handleEncoder;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    protected ClientContainer(String serverId) {
        this._serverId = serverId;
    }

    protected String getServerId() {
        return this._serverId;
    }

    public EJBHome getHomeStub() throws Exception {
        if (this._remoteHomeStub != null) {
            return this._remoteHomeStub;
        }
        this._remoteHomeStub = this.createHomeStub();
        return this._remoteHomeStub;
    }

    public Object getEJBLocalHome() {
        AbstractServer jvmServer = EjbProtocolManager.getJVMServer(this._serverId);
        return jvmServer.getClientLocalHome();
    }

    protected abstract EJBHome createHomeStub() throws Exception;

    public HandleEncoder getHandleEncoder(AbstractHandle handle) {
        if (this._handleEncoder == null) {
            this._handleEncoder = new HandleEncoder("foo");
        }
        return this._handleEncoder;
    }

    public Class getPrimaryKeyClass() {
        return ClientContainer._resin_compat_class_0();
    }

    public EJBObject getObjectStub(String url) throws Exception {
        EJBObject stub = this._stubMap.get(url);
        if (stub != null) {
            return stub;
        }
        stub = this.createObjectStub(url);
        this._stubMap.put(url, stub);
        return stub;
    }

    protected abstract EJBObject createObjectStub(String var1) throws Exception;

    public String toString() {
        return new CharBuffer().append("ClientContainer[").append(this._serverId).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.ejb.protocol.ClientContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

