/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.naming;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EnvServerManager;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;

public class LocalModel
extends AbstractModel {
    protected EjbProtocolManager _protocolManager;
    protected String _prefix;

    public LocalModel(EjbProtocolManager protocolManager) {
        this._protocolManager = protocolManager;
        this._prefix = "";
    }

    public LocalModel(EjbProtocolManager protocolManager, String prefix) {
        this._protocolManager = protocolManager;
        if (!prefix.endsWith("/")) {
            prefix = new CharBuffer().append(prefix).append("/").toString();
        }
        if (!prefix.startsWith("/")) {
            prefix = new CharBuffer().append("/").append(prefix).toString();
        }
        this._prefix = prefix;
    }

    protected AbstractModel create() {
        return new LocalModel(this._protocolManager, this._prefix);
    }

    public EnvServerManager getServerContainer() {
        return this._protocolManager.getServerManager();
    }

    public Object lookup(String name) throws NamingException {
        try {
            AbstractServer server = this._protocolManager.getServerByEJBName(new CharBuffer().append(this._prefix).append(name).toString());
            if (server != null) {
                return server.getEJBLocalHome();
            }
            String newPrefix = new CharBuffer().append(this._prefix).append(name).append("/").toString();
            ArrayList<String> list = this._protocolManager.getLocalChildren(newPrefix);
            if (list != null && list.size() > 0) {
                return new LocalModel(this._protocolManager, newPrefix);
            }
            if (newPrefix.equals("caucho-ejb-admin/")) {
                return this._protocolManager.getServerManager().getAdmin();
            }
            return null;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public void bind(String name, Object value) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public List list() {
        ArrayList<String> list = this._protocolManager.getLocalChildren(this._prefix);
        return list;
    }

    public AbstractModel createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new CharBuffer().append("[LocalModel ").append(this._prefix).append("]").toString();
    }
}

