/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.metadata;

import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitProgram;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbSessionBean;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.entity2.EntityIntrospector;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.ejb.TransactionAttributeType;

public class Bean {
    private static final L10N L = new L10N(Bean._resin_compat_class_8());
    private static final Logger log = Log.open(Bean._resin_compat_class_8());
    private ClassLoader _loader;
    private EjbServerManager _ejbManager;
    private EntityIntrospector _introspector;
    private JClass _type;
    private String _name;
    private ArrayList<InitProgram> _initList = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;

    public Bean(EjbServerManager ejbManager, EntityIntrospector introspector) {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._ejbManager = ejbManager;
        this._introspector = introspector;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(String typeName) throws ConfigException, ClassNotFoundException {
        this._type = this._ejbManager.getJClassLoader().forName(typeName);
        if (this._type == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type", typeName));
        }
        if (this._type.getAnnotation(Bean._resin_compat_class_0()) == null && this._type.getAnnotation(Bean._resin_compat_class_1()) == null && this._type.getAnnotation(Bean._resin_compat_class_2()) == null) {
            throw new ConfigException(L.l("{0} is an unknown bean type.  Beans expect Entity, Stateful, or Stateless class annotations.", this._type.getName()));
        }
    }

    public void addInit(InitProgram init) {
        this._initList.add(init);
    }

    public void init() throws ConfigException {
        block8: {
            if (this._type == null) {
                throw new ConfigException(L.l("type is a require attribute of ejb-server"));
            }
            JAnnotation stateless = this._type.getAnnotation(Bean._resin_compat_class_0());
            JAnnotation stateful = this._type.getAnnotation(Bean._resin_compat_class_1());
            try {
                if (stateless != null) {
                    this.configureStateless(this._type);
                    break block8;
                }
                if (stateful != null) {
                    this.configureStateful(this._type);
                    break block8;
                }
                if (this._type.getAnnotation(Bean._resin_compat_class_2()) != null) {
                    this._introspector.introspect(this._type);
                    break block8;
                }
                throw new ConfigException(L.l("only stateless beans are currently supported."));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException(e);
            }
        }
    }

    private void configureStateless(JClass type) throws ConfigException {
        String className = type.getName();
        JAnnotation stateless = type.getAnnotation(Bean._resin_compat_class_0());
        EjbSessionBean bean = new EjbSessionBean(this._ejbManager.getConfig());
        bean.setAllowPOJO(true);
        bean.setSessionType("Stateless");
        bean.setTransactionType("Container");
        this.configureBean(bean, type, stateless.getString("name"));
    }

    private void configureStateful(JClass type) throws ConfigException {
        String className = type.getName();
        JAnnotation stateful = type.getAnnotation(Bean._resin_compat_class_1());
        EjbSessionBean bean = new EjbSessionBean(this._ejbManager.getConfig());
        bean.setAllowPOJO(true);
        bean.setSessionType("Stateful");
        bean.setTransactionType("Container");
        this.configureBean(bean, type, stateful.getString("name"));
    }

    private void configureBean(EjbBean bean, JClass type, String defaultName) throws ConfigException {
        try {
            JAnnotation perms;
            JAnnotation xa;
            bean.setEJBClassWrapper(type);
            String name = this._name;
            if (name == null || name.equals("")) {
                name = defaultName;
            }
            if (name == null || name.equals("")) {
                String className = type.getName();
                int p = className.lastIndexOf(46);
                name = p > 0 ? className.substring(p + 1) : className;
            }
            bean.setEJBName(name);
            JClass[] ifs = type.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                JAnnotation local = ifs[i].getAnnotation(Bean._resin_compat_class_3());
                if (local != null) {
                    bean.setLocalWrapper(ifs[i]);
                    continue;
                }
                JAnnotation remote = ifs[i].getAnnotation(Bean._resin_compat_class_4());
                if (remote == null && !ifs[i].isAssignableTo(Bean._resin_compat_class_5())) continue;
                bean.setRemoteWrapper(ifs[i]);
            }
            if (bean.getLocal() == null && bean.getRemote() == null) {
                if (ifs.length == 0) {
                    throw new ConfigException(L.l("'{0}' has no interfaces.  Can't currently generate.", type.getName()));
                }
                if (ifs.length != 1) {
                    throw new ConfigException(L.l("'{0}' has multiple interfaces, but none are marked as @Local or @Remote.", type.getName()));
                }
                bean.setLocalWrapper(ifs[0]);
            }
            if ((xa = type.getAnnotation(Bean._resin_compat_class_6())) != null) {
                MethodSignature sig = new MethodSignature();
                sig.setMethodName("*");
                EjbMethodPattern pattern = bean.createMethod(sig);
                this.setPatternTransaction(pattern, xa);
            }
            if ((perms = type.getAnnotation(Bean._resin_compat_class_7())) != null) {
                MethodSignature sig = new MethodSignature();
                sig.setMethodName("*");
                EjbMethodPattern pattern = bean.createMethod(sig);
            }
            this.configureMethods(bean, type);
            for (int i = 0; i < this._initList.size(); ++i) {
                bean.addInitProgram(this._initList.get(i).getBuilderProgram());
            }
            bean.init();
            this._ejbManager.getConfig().setBeanConfig(bean.getEJBName(), bean);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private void configureMethods(EjbBean bean, JClass type) throws ConfigException {
        JMethod[] methods = type.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            JAnnotation perms;
            JMethod method = methods[i];
            JAnnotation xa = method.getAnnotation(Bean._resin_compat_class_6());
            if (xa != null) {
                EjbMethodPattern pattern = bean.createMethod(this.getSignature(method));
                this.setPatternTransaction(pattern, xa);
            }
            if ((perms = method.getAnnotation(Bean._resin_compat_class_7())) == null) continue;
            EjbMethodPattern pattern = bean.createMethod(this.getSignature(method));
        }
    }

    private void setPatternTransaction(EjbMethodPattern pattern, JAnnotation xa) throws ConfigException {
        TransactionAttributeType xaType = (TransactionAttributeType)xa.get("value");
        switch (1.$SwitchMap$javax$ejb$TransactionAttributeType[xaType.ordinal()]) {
            case 1: {
                pattern.setTransaction(3);
                break;
            }
            case 2: {
                pattern.setTransaction(4);
                break;
            }
            case 3: {
                pattern.setTransaction(5);
                break;
            }
            case 4: {
                pattern.setTransaction(2);
                break;
            }
            case 5: {
                pattern.setTransaction(1);
                break;
            }
            case 6: {
                pattern.setTransaction(6);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private MethodSignature getSignature(JMethod method) throws ConfigException {
        MethodSignature sig = new MethodSignature();
        sig.setMethodName(method.getName());
        JClass[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.addParam(paramTypes[i].getName());
        }
        return sig;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.Stateless");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.Stateful");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.Entity");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.ejb.Local");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.ejb.Remote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.rmi.Remote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("javax.ejb.TransactionAttribute");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("javax.ejb.MethodPermissions");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("com.caucho.ejb.metadata.Bean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$javax$ejb$TransactionAttributeType;

        static {
            $SwitchMap$javax$ejb$TransactionAttributeType = new int[TransactionAttributeType.values().length];
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.REQUIRESNEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.MANDATORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.SUPPORTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.NOTSUPPORTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$ejb$TransactionAttributeType[TransactionAttributeType.NEVER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

