/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.Version;
import com.caucho.ejb.hessian.MarshalGenerator;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.MergePath;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class StubGenerator
extends MarshalGenerator {
    private ArrayList<PersistentDependency> _dependList;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;

    StubGenerator() {
    }

    Class createHomeStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", true);
    }

    Class createObjectStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", false);
    }

    Class createStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", true);
    }

    Class makeClient(Class cl, String genSuffix, boolean isHome) throws ConfigException {
        this._cl = cl;
        try {
            this.setFullClassName(new CharBuffer().append("_ejb.").append(cl.getName()).append(genSuffix).toString());
            if (cl.getClassLoader() != null) {
                this.setParentLoader(cl.getClassLoader());
            }
            MergePath mergePath = new MergePath();
            if (cl.getClassLoader() != null) {
                mergePath.addClassPath(cl.getClassLoader());
            } else {
                mergePath.addClassPath(Thread.currentThread().getContextClassLoader());
            }
            this.setSearchPath(mergePath);
            this._dependList = new ArrayList();
            this._dependList.add(new ClassDependency(cl));
            Class stubClass = this.preload();
            if (stubClass != null) {
                return stubClass;
            }
            this.generate();
            return this.compile();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public void generateJava() throws IOException {
        this.generateJava(this._cl.getMethods());
    }

    private void generateJava(Method[] methods) throws IOException {
        if (StubGenerator._resin_compat_class_0().isAssignableFrom(this._cl)) {
            this.printHeader("HomeStub");
        } else if (StubGenerator._resin_compat_class_2().isAssignableFrom(this._cl)) {
            this.printHeader("ObjectStub");
        } else {
            this.printHeader("ObjectStub");
        }
        this.println("public String getHessianType()");
        this.println("{");
        this.println(new CharBuffer().append("  return \"").append(this._cl.getName()).append("\";").toString());
        this.println("}");
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> declaringClass = method.getDeclaringClass();
            String prefix = "";
            if (declaringClass.getName().startsWith("javax.ejb.")) {
                prefix = "_ejb_";
            }
            Class<?>[] exns = method.getExceptionTypes();
            for (int j = 0; j < exns.length; ++j) {
                if (!exns[j].isAssignableFrom(StubGenerator._resin_compat_class_1())) continue;
                this.printMethod(new CharBuffer().append(prefix).append(method.getName()).toString(), method);
                continue block0;
            }
        }
        this.printDependList(this._dependList);
        this.printFooter();
    }

    void printHeader(String stubClassName) throws IOException {
        if (this.getPackageName() != null) {
            this.println(new CharBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println("import com.caucho.vfs.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.ejb.hessian.*;");
        this.println("import com.caucho.hessian.io.*;");
        this.println(new CharBuffer().append("import ").append(this._cl.getName()).append(";").toString());
        this.println();
        this.println(new CharBuffer().append("public class ").append(this.getClassName()).append(" extends ").append(stubClassName).toString());
        this.print(new CharBuffer().append("  implements ").append(this._cl.getName()).toString());
        this.println(" {");
        this.pushDepth();
    }

    void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodDeclaration(name, method);
        this.println("{");
        this.pushDepth();
        this.println("HessianWriter out = _hessian_openWriter();");
        this.println("try {");
        this.pushDepth();
        String mangleName = this.mangleMethodName(method.getName(), method, false);
        this.println("out.startCall();");
        this.println("_hessian_writeHeaders(out);");
        this.println(new CharBuffer().append("out.writeMethod(\"").append(mangleName).append("\");").toString());
        for (int i = 0; i < params.length; ++i) {
            this.printMarshalType(params[i], new CharBuffer().append("_arg").append(i).toString());
        }
        this.println("HessianInput in = out.doCall();");
        if (!Void.TYPE.equals(ret)) {
            this.printClass(ret);
            this.println(" _ret;");
            this.print("_ret = ");
            this.printUnmarshalType(ret);
        } else {
            this.println("in.readNull();");
        }
        this.println("in.completeReply();");
        this.println("_hessian_freeWriter(out);");
        this.println("out = null;");
        if (!Void.TYPE.equals(ret)) {
            this.println("return _ret;");
        }
        this.popDepth();
        Class<?>[] exn = method.getExceptionTypes();
        boolean hasThrowable = false;
        boolean hasRuntimeException = false;
        block1: for (int i = 0; i < exn.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (exn[j].isAssignableFrom(exn[i])) continue block1;
            }
            if (!hasThrowable) {
                this.println(new CharBuffer().append("} catch (").append(exn[i].getName()).append(" e) {").toString());
                this.println("  throw e;");
            }
            if (exn[i].equals(StubGenerator._resin_compat_class_3())) {
                hasThrowable = true;
                hasRuntimeException = true;
            }
            if (exn[i].equals(StubGenerator._resin_compat_class_4())) {
                hasRuntimeException = true;
            }
            if (!exn[i].equals(StubGenerator._resin_compat_class_5())) continue;
            hasRuntimeException = true;
        }
        if (!hasRuntimeException) {
            this.println("} catch (RuntimeException e) {");
            this.println("  throw e;");
        }
        if (!hasThrowable) {
            this.println("} catch (Throwable e) {");
            this.println("  throw new RemoteException(\"stub exception\", e);");
        }
        this.println("} finally {");
        this.println("  if (out != null) out.close();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    void printFooter() throws IOException {
        this.println();
        this.println("public String toString()");
        this.println("{");
        this.pushDepth();
        this.println(new CharBuffer().append("return \"[HessianStub ").append(this._cl.getName()).append(" \" + _urlPath + \"]\";").toString());
        this.popDepth();
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    protected void printVersionChange() throws IOException {
        this.println(new CharBuffer().append("if (com.caucho.ejb.Version.getVersionId() != ").append(Version.getVersionId()).append(")").toString());
        this.println("  return true;");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.rmi.RemoteException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.lang.Throwable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Exception");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.RuntimeException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

