/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.message.MessageServer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianSerializerInput;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class MessageSkeleton
extends Skeleton {
    protected static Logger log = Log.open(MessageSkeleton._resin_compat_class_0());
    protected MessageServer _server;
    protected Connection _connection;
    protected Destination _destination;
    protected Session _session;
    protected MessageProducer _producer;
    private static Class _resin_compat_class_0;

    MessageSkeleton(MessageServer server) throws JMSException {
        this._server = server;
        this._destination = server.getDestination();
        this._connection = server.getJMSConnection();
        this._session = this._connection.createSession(false, 1);
        this._producer = this._session.createProducer(this._destination);
    }

    void _setServer(AbstractServer server) {
        this._server = (MessageServer)server;
    }

    protected void _setObject(Object obj) {
    }

    public void _service(InputStream rawIs, OutputStream rawOs) throws Exception {
        HessianSerializerInput in = new HessianSerializerInput(rawIs);
        HessianWriter out = new HessianWriter(rawOs);
        try {
            in.startCall();
            String method = in.getMethod();
            if (!"send".equals(method)) {
                throw new IOException(new CharBuffer().append("no such method: ").append(method).toString());
            }
            HashMap headers = (HashMap)in.readObject();
            Object data = in.readObject();
            in.completeCall();
            if (this._destination instanceof MessageSender) {
                ((MessageSender)this._destination).send(headers, data);
            } else {
                Object message = null;
                message = data instanceof String ? this._session.createTextMessage((String)data) : this._session.createObjectMessage((Serializable)data);
                this._producer.send((Message)message);
            }
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            out.startReply();
            out.writeFault("SystemFault", String.valueOf(e), e);
            out.completeReply();
        }
    }

    protected void _execute(CharBuffer method, HessianInput in, HessianOutput out) throws Exception {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.MessageSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

