/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.java.AbstractGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

abstract class MarshalGenerator
extends AbstractGenerator {
    static IntMap immutableClasses;
    protected static Class readerClass;
    protected static Class inputStreamClass;
    protected static Class remoteClass;
    protected static Class nodeClass;
    protected Class _cl;
    String objClass;
    String fullName;
    String pkg;
    String className;
    protected int unique;
    protected ArrayList marshallClasses;
    protected ArrayList unmarshallClasses;
    protected ArrayList marshallArrays;
    protected ArrayList unmarshallArrays;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;
    private static Class _resin_compat_class_13;
    private static Class _resin_compat_class_14;
    private static Class _resin_compat_class_15;

    MarshalGenerator() {
    }

    Path initClassNames(Class beanClass, String suffix) throws Exception {
        ClassLoader parentLoader = this.getParentLoader();
        if (parentLoader instanceof DynamicClassLoader) {
            DynamicClassLoader dcl = (DynamicClassLoader)parentLoader;
            dcl.make();
        }
        Path workPath = CauchoSystem.getWorkPath();
        this._cl = beanClass;
        this.fullName = new CharBuffer().append(this._cl.getName()).append(suffix).toString();
        this.objClass = this._cl.getName();
        int p = this.objClass.lastIndexOf(46);
        if (p > 0) {
            this.objClass = this.objClass.substring(p + 1);
        }
        if ((p = this.fullName.lastIndexOf(46)) > 0) {
            this.pkg = this.fullName.substring(0, p);
            this.className = this.fullName.substring(p + 1);
        } else {
            this.className = this.fullName;
        }
        Path path = workPath.lookup(new CharBuffer().append(this.fullName.replace('.', '/')).append(".java").toString());
        path.getParent().mkdirs();
        return path;
    }

    protected String mangleMethodName(String name, Method method, boolean isFull) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(name);
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            cb.append('_');
            this.mangleClass(cb, params[i], isFull);
        }
        return cb.close();
    }

    protected String mangleMethodName(String name, Class[] param, boolean isFull) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(name);
        for (int i = 0; i < param.length; ++i) {
            cb.append('_');
            this.mangleClass(cb, param[i], isFull);
        }
        return cb.close();
    }

    private void mangleClass(CharBuffer cb, Class cl, boolean isFull) {
        String name = cl.getName();
        if (name.equals("boolean")) {
            cb.append("boolean");
        } else if (name.equals("int") || name.equals("short") || name.equals("byte")) {
            cb.append("int");
        } else if (name.equals("long")) {
            cb.append("long");
        } else if (name.equals("double") || name.equals("float")) {
            cb.append("double");
        } else if (name.equals("java.lang.String") || name.equals("com.caucho.util.CharBuffer") || name.equals("char") || name.equals("java.io.Reader")) {
            cb.append("string");
        } else if (name.equals("java.util.Date") || name.equals("com.caucho.util.QDate")) {
            cb.append("date");
        } else if (inputStreamClass.isAssignableFrom(cl) || name.equals("[B")) {
            cb.append("binary");
        } else if (cl.isArray()) {
            cb.append("[");
            this.mangleClass(cb, cl.getComponentType(), isFull);
        } else if (name.equals("org.w3c.dom.Node") || name.equals("org.w3c.dom.Element") || name.equals("org.w3c.dom.Document")) {
            cb.append("xml");
        } else if (isFull) {
            cb.append(name);
        } else {
            int p = name.lastIndexOf(46);
            if (p > 0) {
                cb.append(name.substring(p + 1));
            } else {
                cb.append(name);
            }
        }
    }

    protected void printMethodDeclaration(String name, Method method) throws IOException {
        int i;
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        Class<?>[] exns = method.getExceptionTypes();
        this.println();
        this.print("public ");
        this.printClass(ret);
        this.print(new CharBuffer().append(" ").append(name).append("(").toString());
        for (i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(params[i]);
            this.print(new CharBuffer().append(" _arg").append(i).toString());
        }
        this.println(")");
        if (exns.length > 0) {
            this.print("  throws ");
        }
        for (i = 0; i < exns.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(exns[i]);
        }
        if (exns.length > 0) {
            this.println();
        }
    }

    protected void printUnmarshalType(Class cl) throws IOException {
        String name = cl.getName();
        if (cl.equals(Boolean.TYPE)) {
            this.println("in.readBoolean();");
        } else if (cl.equals(Integer.TYPE)) {
            this.println("in.readInt();");
        } else if (cl.equals(Short.TYPE) || cl.equals(Character.TYPE) || cl.equals(Byte.TYPE)) {
            this.println(new CharBuffer().append("(").append(name).append(") in.readInt();").toString());
        } else if (cl.equals(Long.TYPE)) {
            this.println("in.readLong();");
        } else if (cl.equals(Double.TYPE)) {
            this.println("in.readDouble();");
        } else if (cl.equals(Float.TYPE)) {
            this.println(new CharBuffer().append("(").append(name).append(") in.readDouble();").toString());
        } else if (cl.equals(MarshalGenerator._resin_compat_class_0())) {
            this.println("in.readString();");
        } else if (cl.equals(MarshalGenerator._resin_compat_class_1())) {
            this.println("new java.util.Date(in.readUTCDate());");
        } else if (cl.equals(MarshalGenerator._resin_compat_class_2())) {
            this.println("in.readBytes();");
        } else if (MarshalGenerator._resin_compat_class_3().isAssignableFrom(cl)) {
            this.println("in.readNode();");
        } else if (cl.equals(MarshalGenerator._resin_compat_class_4())) {
            this.println("in.readObject();");
        } else {
            this.print("(");
            this.printClass(cl);
            this.print(") in.readObject(");
            this.printClass(cl);
            this.println(".class);");
        }
    }

    protected void printMarshalType(Class cl, String var) throws IOException {
        String name = cl.getName();
        if (cl.equals(Void.TYPE)) {
            this.println("out.writeNull();");
        } else if (cl.equals(Boolean.TYPE)) {
            this.println(new CharBuffer().append("out.writeBoolean(").append(var).append(");").toString());
        } else if (cl.equals(Integer.TYPE) || cl.equals(Short.TYPE) || cl.equals(Character.TYPE) || cl.equals(Byte.TYPE)) {
            this.println(new CharBuffer().append("out.writeInt(").append(var).append(");").toString());
        } else if (cl.equals(Long.TYPE)) {
            this.println(new CharBuffer().append("out.writeLong(").append(var).append(");").toString());
        } else if (cl.equals(Double.TYPE) || cl.equals(Float.TYPE)) {
            this.println(new CharBuffer().append("out.writeDouble(").append(var).append(");").toString());
        } else if (cl.equals(MarshalGenerator._resin_compat_class_0())) {
            this.println(new CharBuffer().append("out.writeString(").append(var).append(");").toString());
        } else if (cl.equals(MarshalGenerator._resin_compat_class_1())) {
            this.println(new CharBuffer().append("out.writeUTCDate(").append(var).append(" == null ? 0 : ").append(var).append(".getTime());").toString());
        } else if (MarshalGenerator._resin_compat_class_3().isAssignableFrom(cl)) {
            this.println(new CharBuffer().append("out.writeXml(").append(var).append(");").toString());
        } else if (cl.equals(MarshalGenerator._resin_compat_class_2())) {
            this.println(new CharBuffer().append("out.writeBytes(").append(var).append(");").toString());
        } else {
            this.println(new CharBuffer().append("out.writeObject(").append(var).append(");").toString());
        }
    }

    boolean needsSerialization(Class cl) {
        if (cl.isPrimitive()) {
            return false;
        }
        return immutableClasses.get(cl) < 0;
    }

    public void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName());
        } else {
            this.printClass(cl.getComponentType());
            this.print("[]");
        }
    }

    protected void printNewArray(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName());
            this.print("[length]");
        } else {
            this.printNewArray(cl.getComponentType());
            this.print("[]");
        }
    }

    static {
        readerClass = MarshalGenerator._resin_compat_class_5();
        inputStreamClass = MarshalGenerator._resin_compat_class_6();
        remoteClass = MarshalGenerator._resin_compat_class_7();
        nodeClass = MarshalGenerator._resin_compat_class_3();
        immutableClasses = new IntMap();
        immutableClasses.put(MarshalGenerator._resin_compat_class_0(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_8(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_9(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_10(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_11(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_12(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_13(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_14(), 1);
        immutableClasses.put(MarshalGenerator._resin_compat_class_15(), 1);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.util.Date");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("[B");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("org.w3c.dom.Node");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.io.Reader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.io.InputStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.rmi.Remote");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("java.lang.Character");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_13() {
        try {
            Class<?> clazz = _resin_compat_class_13;
            if (clazz == null) {
                clazz = _resin_compat_class_13 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_14() {
        try {
            Class<?> clazz = _resin_compat_class_14;
            if (clazz == null) {
                clazz = _resin_compat_class_14 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_15() {
        try {
            Class<?> clazz = _resin_compat_class_15;
            if (clazz == null) {
                clazz = _resin_compat_class_15 = Class.forName("java.lang.Class");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

