/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianProtocol;
import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HessianSkeleton
extends Skeleton {
    protected static final Logger log = Log.open(HessianSkeleton._resin_compat_class_0());
    private AbstractServer _server;
    private HessianRemoteResolver _resolver;
    private boolean _isDebug;
    private static Class _resin_compat_class_0;

    void _setServer(AbstractServer server) {
        this._server = server;
    }

    public void setDebug(boolean isDebug) {
        this._isDebug = isDebug;
    }

    void _setResolver(HessianRemoteResolver resolver) {
        this._resolver = resolver;
    }

    protected abstract void _setObject(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _service(InputStream is, OutputStream os) throws Exception {
        String header;
        StringWriter debugWriter = null;
        if (this._isDebug) {
            debugWriter = new StringWriter();
            is = new HessianDebugInputStream(is, new PrintWriter(debugWriter));
        }
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.setRemoteResolver(this._resolver);
        in.readCall();
        String xid = null;
        while ((header = in.readHeader()) != null) {
            Object value = in.readObject();
            if (!"xid".equals(header)) continue;
            xid = (String)value;
        }
        String method = in.readMethod();
        CharBuffer cb = new CharBuffer();
        cb.append(method);
        String oldProtocol = EjbProtocolManager.setThreadProtocol("hessian");
        try {
            TransactionContext xa = null;
            if (xid != null) {
                xa = this._server.getTransactionManager().startTransaction(xid);
            }
            this._execute(cb, in, out, xa);
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
        finally {
            EjbProtocolManager.setThreadProtocol(oldProtocol);
            if (debugWriter != null) {
                log.fine(debugWriter.toString());
            }
            if (xid != null) {
                this._server.getTransactionManager().finishTransaction(xid);
            }
        }
    }

    protected void startReply(HessianOutput out, TransactionContext xa) throws IOException {
        EjbProtocolManager pm;
        HessianProtocol hessian;
        out.startReply();
        if (xa != null && !xa.isEmpty() && (hessian = (HessianProtocol)(pm = this._server.getServerManager().getProtocolManager()).getProtocol("hessian")) != null) {
            out.writeHeader("xa-resource");
            out.writeString(hessian.calculateURL("/_ejb_xa_resource"));
        }
    }

    protected abstract void _execute(CharBuffer var1, HessianInput var2, HessianOutput var3, TransactionContext var4) throws Throwable;

    protected void _executeUnknown(CharBuffer method, HessianInput in, HessianOutput out) throws Exception {
        if (method.matches("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else if ("home-class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", new CharBuffer().append("no such method: ").append((Object)method).toString(), null);
            out.completeReply();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.HessianSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

