/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianClientContainer;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.services.name.NameServerRemote;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.NamingException;

public class HessianModel
extends AbstractModel {
    private static L10N L = new L10N(HessianModel._resin_compat_class_0());
    private String _urlPrefix;
    private String _namePrefix;
    private HessianModel _root;
    private Hashtable _cache;
    private HessianClientContainer _client;
    private NameServerRemote _remoteRoot;
    private NameServerRemote _remote;
    private static Class _resin_compat_class_0;

    public HessianModel(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = new CharBuffer().append(prefix).append('/').toString();
        }
        this._urlPrefix = prefix;
        this._namePrefix = "/";
        this._root = this;
        this._cache = new Hashtable();
    }

    public HessianModel(String namePrefix, HessianModel root) {
        if (!namePrefix.endsWith("/")) {
            namePrefix = new CharBuffer().append(namePrefix).append('/').toString();
        }
        this._namePrefix = namePrefix;
        this._root = root;
    }

    void setRemote(NameServerRemote remote) {
        this._remote = remote;
    }

    void setClientContainer(HessianClientContainer client) {
        this._root._client = client;
    }

    public AbstractModel copy() {
        return this;
    }

    String getURLPrefix() {
        return this._root._urlPrefix;
    }

    public Object lookup(String name) throws NamingException {
        try {
            Object obj = this._root._cache.get(new CharBuffer().append(this.getURLPrefix()).append(this._namePrefix).append(name).toString());
            if (obj != null) {
                return obj;
            }
            if (this._root._remoteRoot == null) {
                if (this._root._client == null) {
                    this._root._client = HessianClientContainer.find(this.getURLPrefix());
                }
                EJBObject stub = this._client.createObjectStub(this.getURLPrefix());
                this._root._remoteRoot = (NameServerRemote)stub;
            }
            if ((obj = this._root._remoteRoot.lookup(new CharBuffer().append(this._namePrefix).append(name).toString())) instanceof EJBHome) {
                this._root._cache.put(name, obj);
            } else if (obj instanceof NameServerRemote) {
                HessianModel model = new HessianModel(new CharBuffer().append(this._namePrefix).append(name).toString(), this._root);
                this._remote = (NameServerRemote)obj;
                model.setRemote(this._remote);
                obj = model;
                this._root._cache.put(name, obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public List list() throws NamingException {
        try {
            if (this._remote == null) {
                Object obj;
                if (this._root._remoteRoot == null) {
                    if (this._root._client == null) {
                        this._root._client = HessianClientContainer.find(this.getURLPrefix());
                    }
                    this._root._remoteRoot = (NameServerRemote)this._client.createObjectStub(this.getURLPrefix());
                }
                if ((obj = this._root._remoteRoot.lookup(this._namePrefix)) instanceof NameServerRemote) {
                    this._remote = (NameServerRemote)obj;
                }
            }
            if (this._remote == null) {
                throw new NamingException(L.l("Hessian object `{0}' is not a context.", new CharBuffer().append(this.getURLPrefix()).append(this._namePrefix).toString()));
            }
            String[] list = this._remote.list();
            ArrayList<String> value = new ArrayList<String>();
            for (int i = 0; list != null && i < list.length; ++i) {
                value.add(list[i]);
            }
            return value;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public String toString() {
        return new CharBuffer().append("HessianModel[url= ").append(this.getURLPrefix()).append(",name=").append(this._namePrefix).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.hessian.HessianModel");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

