/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.bytecode.JClass;
import com.caucho.ejb.gen.SessionPoolChain;
import com.caucho.ejb.gen.StatelessPoolChain;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class SessionView
extends ViewClass {
    private static L10N L = new L10N(SessionView._resin_compat_class_0());
    private JClass _remoteClass;
    private String _prefix;
    private String _contextClassName;
    private boolean _isStateless;
    private static Class _resin_compat_class_0;

    public SessionView(JClass remoteClass, String contextClassName, String prefix, boolean isStateless) {
        super(prefix, isStateless ? "StatelessObject" : "SessionObject");
        this.addInterfaceName(remoteClass.getName());
        this._contextClassName = contextClassName;
        this._prefix = prefix;
        this._isStateless = isStateless;
        this.setStatic(true);
    }

    public CallChain createPoolChain(CallChain call) {
        if (this._isStateless) {
            return new StatelessPoolChain(call);
        }
        return new SessionPoolChain(call);
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateGetter(out);
        out.println();
        super.generate(out);
    }

    private void generateGetter(JavaWriter out) throws IOException {
        out.println(new CharBuffer().append("private ").append(this._prefix).append(" _view").append(this._prefix).append(";").toString());
        out.println();
        if (this._prefix.equals("Local")) {
            out.println("public EJBLocalObject getEJBLocalObject()");
        } else {
            out.println("public EJBObject getRemoteView()");
        }
        out.println("{");
        out.println(new CharBuffer().append("  if (_view").append(this._prefix).append(" == null)").toString());
        out.println(new CharBuffer().append("    _view").append(this._prefix).append(" = new ").append(this._prefix).append("(this);").toString());
        out.println();
        out.println(new CharBuffer().append("  return _view").append(this._prefix).append(";").toString());
        out.println("}");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println(new CharBuffer().append("private final ").append(this._contextClassName).append(" _context;").toString());
        out.println("private final EjbTransactionManager _xaManager;");
        out.println();
        out.println(new CharBuffer().append(this._prefix).append("(").append(this._contextClassName).append(" context)").toString());
        out.println("{");
        if (this._isStateless) {
            out.println("  super(context.getStatelessServer());");
        } else {
            out.println("  super(context.getSessionServer());");
        }
        out.println("  _context = context;");
        out.println("  _xaManager = _server.getTransactionManager();");
        out.println("}");
        out.println();
        out.println(new CharBuffer().append("private ").append(this._contextClassName).append(" getContext()").toString());
        out.println("{");
        out.println("  return _context;");
        out.println("}");
        if (!this._isStateless) {
            out.println();
            out.println("public String __caucho_getId()");
            out.println("{");
            out.println("  return _context.getPrimaryKey();");
            out.println("}");
        }
        out.println();
        this.generateComponents(out);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.gen.SessionView");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

