/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.Version;
import com.caucho.java.AbstractGenerator;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

abstract class JVMStubGenerator
extends AbstractGenerator {
    protected static final L10N L = new L10N(JVMStubGenerator._resin_compat_class_4());
    static IntMap _immutableClasses = new IntMap();
    protected boolean _isProxy = false;
    protected ArrayList<Method> _proxyMethods = new ArrayList();
    protected Class _remoteClass;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;
    private static Class _resin_compat_class_13;

    JVMStubGenerator() {
    }

    void setProxy(boolean isProxy) {
        this._isProxy = isProxy;
    }

    protected abstract void printHeader() throws IOException;

    protected void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        boolean needsSerialization = this.printMethodHead(params, ret);
        this.printCall(method.getName(), params, ret);
        this.printMethodFooter(ret, needsSerialization);
    }

    protected boolean printMethodHead(Class[] params, Class ret) throws IOException {
        this.println("{");
        this.pushDepth();
        this.println("Thread thread = Thread.currentThread();");
        this.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        boolean needsSerialization = false;
        for (int i = 0; i < params.length; ++i) {
            if (!this.needsSerialization(params[i])) continue;
            if (!needsSerialization) {
                this.println("com.caucho.ejb.protocol.SelfSerializer ser;");
                this.println("ser = com.caucho.ejb.protocol.SelfSerializer.allocate();");
            }
            this.println(new CharBuffer().append("ser.write(a").append(i).append(");").toString());
            needsSerialization = true;
        }
        if (this.needsSerialization(ret) && !needsSerialization) {
            this.println("com.caucho.ejb.protocol.SelfSerializer ser;");
            this.println("ser = com.caucho.ejb.protocol.SelfSerializer.allocate();");
            needsSerialization = true;
        }
        if (!ret.getName().equals("void")) {
            this.printClass(ret);
            this.println(" _ret;");
        }
        this.println();
        if (!this._isProxy) {
            this.println(new CharBuffer().append(this._remoteClass.getName()).append(" obj;").toString());
            this.println(new CharBuffer().append("obj = (").append(this._remoteClass.getName()).append(") _caucho_getObject();").toString());
        } else {
            this.println("Object obj = _caucho_getObject();");
        }
        this.println("thread.setContextClassLoader(_caucho_getClassLoader());");
        this.println("try {");
        this.pushDepth();
        return needsSerialization;
    }

    protected void printMethodFooter(Class ret, boolean needsSerialization) throws IOException {
        if (this.needsSerialization(ret)) {
            if (needsSerialization) {
                this.println("ser.clear();");
            }
            needsSerialization = true;
            this.println("ser.write(_ret);");
            this.println("thread.setContextClassLoader(oldLoader);");
            this.print("_ret = (");
            this.printClass(ret);
            this.println(") ser.read();");
        }
        this.popDepth();
        this.println("} finally {");
        this.pushDepth();
        this.println("thread.setContextClassLoader(oldLoader);");
        if (needsSerialization) {
            this.println("ser.close();");
        }
        this.popDepth();
        this.println("}");
        if (!ret.getName().equals("void")) {
            this.println("return _ret;");
        }
        this.popDepth();
        this.println("}");
    }

    void printCall(String name, Class[] params, Class retType) throws IOException {
        if (this._isProxy) {
            this.printProxyCall(name, params, retType);
            return;
        }
        if (!retType.equals(Void.TYPE)) {
            this.print("_ret = ");
        }
        this.print(new CharBuffer().append("obj.").append(name).append("(").toString());
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            if (this.needsSerialization(params[i])) {
                this.print("(");
                this.printClass(params[i]);
                this.print(") ser.read()");
                continue;
            }
            this.print(new CharBuffer().append("a").append(i).toString());
        }
        this.println(");");
    }

    void printProxyCall(String name, Class[] params, Class retType) throws IOException {
        Method method;
        try {
            method = this._remoteClass.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw new IOExceptionWrapper(e);
        }
        this._proxyMethods.add(method);
        if (this._isProxy) {
            this.println("try {");
            this.pushDepth();
        }
        int index = this._proxyMethods.size() - 1;
        boolean retNeedsSerialization = this.needsSerialization(retType);
        if (!retType.equals(Void.TYPE)) {
            if (!retNeedsSerialization) {
                this.print("_ret = (");
                this.printClass(retType);
                this.print(")");
            } else {
                this.print("Object _oret = ");
            }
        }
        if (retType.isPrimitive()) {
            this.print(new CharBuffer().append("com.caucho.ejb.JVMObject.to_").append(retType.getName()).append("(").toString());
        }
        this.print(new CharBuffer().append("method").append(index).append(".invoke(obj, new Object[] {").toString());
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            if (this.needsSerialization(params[i])) {
                this.print("(");
                this.printClass(params[i]);
                this.print(") ser.read()");
                continue;
            }
            if (params[i].isPrimitive()) {
                this.printToObject(new CharBuffer().append("a").append(i).toString(), params[i]);
                continue;
            }
            this.print(new CharBuffer().append("a").append(i).toString());
        }
        if (retType.isPrimitive()) {
            this.println("}));");
        } else {
            this.println("});");
        }
        if (retNeedsSerialization) {
            this.println("ser.clear();");
            this.println("ser.write(_oret);");
            this.println("thread.setContextClassLoader(oldLoader);");
            this.print("_ret = (");
            this.printClass(method.getReturnType());
            this.println(") ser.read();");
        }
        this.popDepth();
        this.println("} catch (java.lang.IllegalAccessException e) {");
        this.println("  throw com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
        this.println("} catch (java.lang.reflect.InvocationTargetException e) {");
        this.println("  throw com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
        this.println("}");
    }

    void printToObject(String name, Class cl) throws IOException {
        if (Boolean.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Boolean(").append(name).append(")").toString());
        } else if (Byte.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Byte(").append(name).append(")").toString());
        } else if (Short.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Short(").append(name).append(")").toString());
        } else if (Character.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Character(").append(name).append(")").toString());
        } else if (Integer.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Integer(").append(name).append(")").toString());
        } else if (Long.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Long(").append(name).append(")").toString());
        } else if (Float.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Float(").append(name).append(")").toString());
        } else if (Double.TYPE.equals(cl)) {
            this.print(new CharBuffer().append("new Double(").append(name).append(")").toString());
        } else {
            throw new RuntimeException(L.l("can't create object for type {0}", cl.getName()));
        }
    }

    void printFooter() throws IOException {
        int i;
        for (i = 0; i < this._proxyMethods.size(); ++i) {
            this.println(new CharBuffer().append("static java.lang.reflect.Method method").append(i).append(";").toString());
        }
        if (this._proxyMethods.size() > 0) {
            this.println("protected void _caucho_init_methods(Class cl)");
            this.println("{");
            this.pushDepth();
            this.println("try {");
            this.pushDepth();
            for (i = 0; i < this._proxyMethods.size(); ++i) {
                Method method = this._proxyMethods.get(i);
                this.print(new CharBuffer().append("method").append(i).append(" = cl.getMethod(\"").toString());
                this.print(method.getName());
                this.print("\", new Class[] {");
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (j != 0) {
                        this.print(", ");
                    }
                    this.printClass(paramTypes[j]);
                    this.print(".class");
                }
                this.println("});");
            }
            this.popDepth();
            this.println("} catch (Exception e) {");
            this.println("  com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
            this.println("}");
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        this.println("}");
    }

    boolean needsSerialization(Class cl) {
        if (cl.isPrimitive()) {
            return false;
        }
        if (!this._isProxy && JVMStubGenerator._resin_compat_class_0().isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && JVMStubGenerator._resin_compat_class_1().isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && JVMStubGenerator._resin_compat_class_2().isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && JVMStubGenerator._resin_compat_class_3().isAssignableFrom(cl)) {
            return false;
        }
        return _immutableClasses.get(cl) < 0;
    }

    protected void printVersionChange() throws IOException {
        this.println(new CharBuffer().append("if (com.caucho.ejb.Version.getVersionId() != ").append(Version.getVersionId()).append(")").toString());
        this.println("  return true;");
    }

    static {
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_5(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_6(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_7(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_8(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_9(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_10(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_11(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_12(), 1);
        _immutableClasses.put(JVMStubGenerator._resin_compat_class_13(), 1);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.ejb.EJBLocalHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("com.caucho.ejb.gen.JVMStubGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Byte");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("java.lang.Character");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("java.lang.Short");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("java.lang.Integer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("java.lang.Long");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("java.lang.Float");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("java.lang.Double");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_13() {
        try {
            Class<?> clazz = _resin_compat_class_13;
            if (clazz == null) {
                clazz = _resin_compat_class_13 = Class.forName("java.lang.Class");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

