/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.JVMStubGenerator;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.MergePath;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JVMObjectStubGenerator
extends JVMStubGenerator {
    private ArrayList<PersistentDependency> _dependList;
    private static Class _resin_compat_class_0;

    public JVMObjectStubGenerator(Class remoteClass, boolean isProxy) {
        this._remoteClass = remoteClass;
        this._isProxy = isProxy;
        if (isProxy) {
            this.setFullClassName(new CharBuffer().append(remoteClass.getName()).append("__JVMProxy").toString());
        } else {
            this.setFullClassName(new CharBuffer().append(remoteClass.getName()).append("__JVMStub").toString());
        }
        MergePath mergePath = new MergePath();
        this.setSearchPath(mergePath);
        this._dependList = new ArrayList();
        this._dependList.add(new ClassDependency(remoteClass));
    }

    public Class generateStub() throws Exception {
        Class object = this.preload();
        if (object != null) {
            return object;
        }
        this.generate();
        return this.compile();
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this._remoteClass.getMethods();
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.")) continue;
            Class<?>[] exns = method.getExceptionTypes();
            for (int j = 0; j < exns.length; ++j) {
                if (!exns[j].isAssignableFrom(JVMObjectStubGenerator._resin_compat_class_0())) continue;
                this.printMethod(method.getName(), method);
                continue block0;
            }
        }
        this.printRemove();
        this.printDependList(this._dependList);
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println(new CharBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println(new CharBuffer().append("import ").append(this._remoteClass.getName()).append(";").toString());
        this.println();
        this.println(new CharBuffer().append("public class ").append(this.getClassName()).toString());
        this.println("  extends com.caucho.ejb.JVMObject");
        this.println(new CharBuffer().append("  implements ").append(this._remoteClass.getName()).toString());
        this.println("{");
        this.pushDepth();
    }

    protected void printRemove() throws IOException {
        Class<Void> ret = Void.TYPE;
        Class[] params = new Class[]{};
        this.println();
        this.println("public void remove() throws java.rmi.RemoteException, javax.ejb.RemoveException");
        this.printMethodHead(params, ret);
        this.printCall("remove", params, Void.TYPE);
        this.printMethodFooter(ret, false);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.rmi.RemoteException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

