/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.java.AbstractGenerator;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Method;

class EJBObjectGenerator
extends AbstractGenerator {
    protected Class _skelClass;
    protected Class _remoteClass;
    protected String prefix = "_ejb_lo_";

    public EJBObjectGenerator(Class remoteClass, Class skelClass) {
        this._remoteClass = remoteClass;
        this._skelClass = skelClass;
        this.setFullClassName(new CharBuffer().append("_ejb.").append(this._remoteClass.getName()).append("__Stub").toString());
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this._remoteClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.")) continue;
            this.printMethod(method.getName(), method);
        }
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println(new CharBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println(new CharBuffer().append("import ").append(this._skelClass.getName()).append(";").toString());
        this.println(new CharBuffer().append("import ").append(this._remoteClass.getName()).append(";").toString());
        this.println();
        this.println(new CharBuffer().append("public class ").append(this.getClassName()).toString());
        this.println("  extends com.caucho.ejb.SessionObject");
        this.println(new CharBuffer().append("  implements ").append(this._remoteClass.getName()).toString());
        this.println("{");
        this.pushDepth();
        this.println(new CharBuffer().append("private ").append(this._skelClass.getName()).append(" _obj;").toString());
        this.println();
        this.println("public javax.ejb.SessionBean _getObject()");
        this.println("{");
        this.println("  return _obj;");
        this.println("}");
        this.println();
        this.println("public void _setObject(javax.ejb.SessionBean bean)");
        this.println("{");
        this.println(new CharBuffer().append("  _obj = (").append(this._skelClass.getName()).append(") bean;").toString());
        this.println("}");
    }

    protected void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        this.println("{");
        this.pushDepth();
        if (!ret.getName().equals("void")) {
            this.printClass(ret);
            this.println(" _ret;");
        }
        if (!ret.getName().equals("void")) {
            this.print("_ret = ");
        }
        this.print(new CharBuffer().append("_obj.").append(this.prefix).append(method.getName()).append("(").toString());
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(new CharBuffer().append("a").append(i).toString());
        }
        this.println(");");
        if (!ret.getName().equals("void")) {
            this.println("return _ret;");
        }
        this.popDepth();
        this.println("}");
    }

    void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }
}

