/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.java.AbstractGenerator;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Method;

class EJBHomeGenerator
extends AbstractGenerator {
    protected Class skelClass;
    protected Class remoteClass;
    protected String prefix = "_ejb_lh_";

    EJBHomeGenerator(Class remoteClass, Class skelClass) {
        this.skelClass = skelClass;
        this.remoteClass = remoteClass;
        this.setFullClassName(new CharBuffer().append("_ejb.").append(remoteClass.getName()).append("__Stub").toString());
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this.remoteClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.") && !methodName.equals("getPrimaryKey") && !methodName.equals("getEJBMetaData")) continue;
            if (methodName.startsWith("create")) {
                this.printCreateMethod(method.getName(), method);
                continue;
            }
            this.printMethod(method.getName(), method);
        }
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println(new CharBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println(new CharBuffer().append("import ").append(this.skelClass.getName()).append(";").toString());
        this.println(new CharBuffer().append("import ").append(this.remoteClass.getName()).append(";").toString());
        this.println();
        this.println(new CharBuffer().append("public class ").append(this.getClassName()).toString());
        this.println("  extends com.caucho.ejb.SessionHome");
        this.println(new CharBuffer().append("  implements ").append(this.remoteClass.getName()).toString());
        this.println("{");
        this.pushDepth();
        this.println(new CharBuffer().append("private ").append(this.skelClass.getName()).append(" obj;").toString());
        this.println();
        this.println("protected void _init(com.caucho.ejb.SessionServer server, javax.ejb.SessionBean obj)");
        this.println("{");
        this.println("  this.server = server;");
        this.println(new CharBuffer().append("  this.obj = (").append(this.skelClass.getName()).append(") obj;").toString());
        this.println("}");
    }

    protected void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        this.println("{");
        this.pushDepth();
        if (!ret.getName().equals("void")) {
            this.printClass(ret);
            this.println(" _ret;");
        }
        if (!ret.getName().equals("void")) {
            this.print("_ret = ");
        }
        this.print(new CharBuffer().append("obj.").append(this.prefix).append(method.getName()).append("(").toString());
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(new CharBuffer().append("a").append(i).toString());
        }
        this.println(");");
        if (!ret.getName().equals("void")) {
            this.println("return _ret;");
        }
        this.popDepth();
        this.println("}");
    }

    protected void printCreateMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        this.println("{");
        this.pushDepth();
        this.println("com.caucho.ejb.AbstractContext cxt;");
        this.print("cxt = ");
        this.print(new CharBuffer().append("obj.").append(this.prefix).append(method.getName()).append("(").toString());
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(new CharBuffer().append("a").append(i).toString());
        }
        this.println(");");
        this.println(new CharBuffer().append("return (").append(ret.getName()).append(") cxt.getEJBLocalObject();").toString());
        this.popDepth();
        this.println("}");
    }

    void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }
}

