/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.amber.field.IdField;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.gen.IdFieldCompare;
import com.caucho.ejb.ql.EjbSelectQuery;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseMethod;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractQueryMethod
extends BaseMethod {
    private static final L10N L = new L10N(AbstractQueryMethod._resin_compat_class_5());
    private JMethod _method;
    private EjbEntityBean _bean;
    private EjbSelectQuery _query;
    private boolean _queryLoadsBean = true;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;

    protected AbstractQueryMethod(EjbEntityBean bean, JMethod method, EjbSelectQuery query) throws ConfigException {
        super(method);
        this._bean = bean;
        this._query = query;
        this._method = method;
    }

    public void setQueryLoadsBean(boolean queryLoadsBean) {
        this._queryLoadsBean = queryLoadsBean;
    }

    public JClass[] getParameterTypes() {
        return this._method.getParameterTypes();
    }

    public JClass getReturnType() {
        return this._method.getReturnType();
    }

    protected String generateBeanId() {
        return "bean.__caucho_getPrimaryKey()";
    }

    void generatePrepareQuery(JavaWriter out, String[] args) throws IOException {
        out.println("com.caucho.amber.AmberQuery query;");
        out.print("query = trans.getAmberConnection().prepareQuery(\"");
        out.print(this._query.toAmberQuery(args));
        out.println("\");");
        int len = args.length;
        if (this._query.getMaxArg() < len) {
            len = this._query.getMaxArg();
        }
        if (len > 0 || this._query.getThisExpr() != null) {
            out.println("int index = 1;");
        }
        JClass[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < len; ++i) {
            this.generateSetParameter(out, paramTypes[i], args[i]);
        }
        if (this._query.getThisExpr() != null) {
            AbstractQueryMethod.generateSetThis(out, this._bean, "query");
        }
        if (this._query.getOffsetValue() > 0) {
            out.println(new CharBuffer().append("query.setFirstResult(").append(this._query.getOffsetValue()).append(");").toString());
        } else if (this._query.getOffsetArg() > 0) {
            out.println(new CharBuffer().append("query.setFirstResult(").append(args[this._query.getOffsetArg() - 1]).append(");").toString());
        }
        if (this._query.getLimitValue() > 0) {
            out.println(new CharBuffer().append("query.setMaxResults(").append(this._query.getLimitValue()).append(");").toString());
        } else if (this._query.getLimitArg() > 0) {
            out.println(new CharBuffer().append("query.setMaxResults(").append(args[this._query.getLimitArg() - 1]).append(");").toString());
        }
        if (!this._queryLoadsBean) {
            out.println("query.setLoadOnQuery(false);");
        }
    }

    public static void generateSetThis(JavaWriter out, EjbEntityBean bean, String query) throws IOException {
        EntityType amberType = bean.getEntityType();
        ArrayList<IdField> keys = new ArrayList<IdField>();
        keys.addAll(amberType.getId().getKeys());
        Collections.sort(keys, new IdFieldCompare());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            IdField field = (IdField)i$.next();
            field.generateSet(out, new CharBuffer().append(query).append("").toString(), "index", "super");
        }
    }

    public void generateSetParameter(JavaWriter out, JClass type, String arg) throws IOException {
        AbstractQueryMethod.generateSetParameter(out, this._bean.getConfig(), type, "query", arg);
    }

    public static void generateSetParameter(JavaWriter out, EjbConfig config, JType type, String query, String arg) throws IOException {
        if (type.getName().equals("boolean")) {
            out.println(new CharBuffer().append(query).append(".setBoolean(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("byte")) {
            out.println(new CharBuffer().append(query).append(".setInt(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("short")) {
            out.println(new CharBuffer().append(query).append(".setInt(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("int")) {
            out.println(new CharBuffer().append(query).append(".setInt(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("long")) {
            out.println(new CharBuffer().append(query).append(".setLong(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("char")) {
            out.println(new CharBuffer().append(query).append(".setString(index++, String.valueOf(").append(arg).append("));").toString());
        } else if (type.getName().equals("float")) {
            out.println(new CharBuffer().append(query).append(".setFloat(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("double")) {
            out.println(new CharBuffer().append(query).append(".setDouble(index++, ").append(arg).append(");").toString());
        } else if (type.isAssignableTo(AbstractQueryMethod._resin_compat_class_0())) {
            out.println(new CharBuffer().append(query).append(".setTimestamp(index++, ").append(arg).append(");").toString());
        } else if (type.isAssignableTo(AbstractQueryMethod._resin_compat_class_1())) {
            out.println(new CharBuffer().append(query).append(".setDate(index++, ").append(arg).append(");").toString());
        } else if (type.isAssignableTo(AbstractQueryMethod._resin_compat_class_2())) {
            out.println(new CharBuffer().append(query).append(".setTime(index++, ").append(arg).append(");").toString());
        } else if (type.isAssignableTo(AbstractQueryMethod._resin_compat_class_3())) {
            out.println("{");
            out.println(new CharBuffer().append("  java.util.Date _caucho_tmp_date = ").append(arg).append(";").toString());
            out.println("  if (_caucho_tmp_date == null)");
            out.println(new CharBuffer().append("    ").append(query).append(".setNull(index++, java.sql.Types.TIMESTAMP);").toString());
            out.println("  else");
            out.println(new CharBuffer().append("    ").append(query).append(".setTimestamp(index++, new java.sql.Timestamp(_caucho_tmp_date.getTime()));").toString());
            out.println("}");
        } else if (type.getName().equals("java.lang.Boolean")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.BIT);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setBoolean(index++, ").append(arg).append(".booleanValue());").toString());
        } else if (type.getName().equals("java.lang.Character")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.VARCHAR);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setString(index++, ").append(arg).append(".toString());").toString());
        } else if (type.getName().equals("java.lang.String")) {
            out.println(new CharBuffer().append("  ").append(query).append(".setString(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("java.lang.Byte")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.TINYINT);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setInt(index++, ").append(arg).append(".byteValue());").toString());
        } else if (type.getName().equals("java.lang.Short")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.SMALLINT);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setInt(index++, ").append(arg).append(".shortValue());").toString());
        } else if (type.getName().equals("java.lang.Integer")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.INTEGER);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setInt(index++, ").append(arg).append(".intValue());").toString());
        } else if (type.getName().equals("java.lang.Long")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.BIGINT);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setLong(index++, ").append(arg).append(".longValue());").toString());
        } else if (type.getName().equals("java.lang.Float")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.REAL);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setDouble(index++, ").append(arg).append(".floatValue());").toString());
        } else if (type.getName().equals("java.lang.Double")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.DOUBLE);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setDouble(index++, ").append(arg).append(".doubleValue());").toString());
        } else if (type.getName().equals("java.math.BigDecimal")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.NUMERIC);").toString());
            out.println("else");
            out.println(new CharBuffer().append("  ").append(query).append(".setBigDecimal(index++, ").append(arg).append(");").toString());
        } else if (type.getName().equals("[B")) {
            out.println(new CharBuffer().append("if (").append(arg).append(" == null)").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setNull(index++, java.sql.Types.VARBINARY);").toString());
            out.println("else {");
            out.println(new CharBuffer().append("  byte []bArray = (byte []) ").append(arg).append(";").toString());
            out.println(new CharBuffer().append("  ").append(query).append(".setBinaryStream(index++, new java.io.ByteArrayInputStream(bArray), bArray.length);").toString());
            out.println("}");
        } else if (type.isAssignableTo(AbstractQueryMethod._resin_compat_class_4())) {
            IdField field;
            EjbEntityBean bean = config.findEntityByLocal(type.getRawType());
            if (bean == null) {
                throw new IllegalStateException(L.l("can't find bean for {0}", type.getName()));
            }
            EntityType amberType = bean.getEntityType();
            ArrayList<IdField> keys = new ArrayList<IdField>();
            keys.addAll(amberType.getId().getKeys());
            Collections.sort(keys, new IdFieldCompare());
            String var = new CharBuffer().append("_expr").append(out.generateId()).toString();
            out.print(type.getPrintName());
            out.println(new CharBuffer().append(" ").append(var).append(" = ").append(arg).append(";").toString());
            out.println(new CharBuffer().append("if (").append(var).append(" != null) {").toString());
            out.pushDepth();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                field = (IdField)i$.next();
                field.generateSet(out, new CharBuffer().append(query).append("").toString(), "index", arg);
            }
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            i$ = keys.iterator();
            while (i$.hasNext()) {
                field = (IdField)i$.next();
                field.generateSet(out, new CharBuffer().append(query).append("").toString(), "index", null);
            }
            out.popDepth();
            out.println("}");
        } else {
            int i;
            JField[] fields = type.getFields();
            String var = new CharBuffer().append("_expr").append(out.generateId()).toString();
            out.print(type.getPrintName());
            out.println(new CharBuffer().append(" ").append(var).append(" = ").append(arg).append(";").toString());
            out.println(new CharBuffer().append("if (").append(var).append(" != null) {").toString());
            out.pushDepth();
            for (i = 0; i < fields.length; ++i) {
                JField field = fields[i];
                AbstractQueryMethod.generateSetParameter(out, config, field.getType(), query, new CharBuffer().append(arg).append(".").append(field.getName()).toString());
            }
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            for (i = 0; i < fields.length; ++i) {
                out.println(new CharBuffer().append(query).append(".setNull(index++, 0);").toString());
            }
            out.popDepth();
            out.println("}");
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.sql.Timestamp");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.sql.Date");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.sql.Time");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("java.util.Date");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("com.caucho.ejb.gen.AbstractQueryMethod");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

