/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.entity2;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.EntityManyToManyField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.EntityOneToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.field.SubId;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.PrimitiveCharType;
import com.caucho.amber.type.PrimitiveIntType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JAccessibleObject;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.EjbServerManager;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.AccessType;
import javax.ejb.DiscriminatorType;
import javax.ejb.FetchType;
import javax.ejb.GeneratorType;
import javax.ejb.InheritanceType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIntrospector {
    private static final L10N L = new L10N(EntityIntrospector._resin_compat_class_20());
    private static HashSet<String> _propertyAnnotations = new HashSet();
    private EjbServerManager _ejbManager;
    private HashMap<String, EntityType> _entityMap = new HashMap();
    private ArrayList<Completion> _linkCompletions = new ArrayList();
    private ArrayList<Completion> _depCompletions = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;
    private static Class _resin_compat_class_13;
    private static Class _resin_compat_class_14;
    private static Class _resin_compat_class_15;
    private static Class _resin_compat_class_16;
    private static Class _resin_compat_class_17;
    private static Class _resin_compat_class_18;
    private static Class _resin_compat_class_19;
    private static Class _resin_compat_class_20;

    public EntityIntrospector(EjbServerManager manager) {
        this._ejbManager = manager;
    }

    public EntityType introspect(JClass type) throws ConfigException, SQLException {
        EntityType entityType;
        String entityName;
        int p;
        JAnnotation entityAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_0());
        if (entityAnn == null) {
            throw new ConfigException(L.l("'{0}' is not an @Entity class.", type));
        }
        this.validateType(type);
        boolean isField = entityAnn.get("access") == AccessType.FIELD;
        EjbServerManager serverManager = this._ejbManager;
        AmberManager amberManager = serverManager.getAmberManager();
        JAnnotation inheritanceAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_1());
        EntityType parentType = null;
        if (inheritanceAnn != null) {
            for (JClass parentClass = type.getSuperClass(); parentClass != null; parentClass = parentClass.getSuperClass()) {
                JAnnotation parentEntity = parentClass.getAnnotation(EntityIntrospector._resin_compat_class_0());
                if (parentEntity == null) continue;
                parentType = this.introspect(parentClass);
                break;
            }
        }
        if ((p = (entityName = type.getName()).lastIndexOf(46)) > 0) {
            entityName = entityName.substring(p + 1);
        }
        if ((entityType = this._entityMap.get(entityName)) != null) {
            return entityType;
        }
        entityType = amberManager.createEntity(entityName, type);
        this._entityMap.put(entityName, entityType);
        if (isField) {
            entityType.setFieldAccess(true);
        }
        entityType.setInstanceClassName(new CharBuffer().append(type.getName()).append("__ResinExt").toString());
        entityType.setEnhanced(true);
        Object table = null;
        JAnnotation tableAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_2());
        String tableName = null;
        if (tableAnn != null) {
            tableName = (String)tableAnn.get("name");
        }
        if (tableName == null || tableName.equals("")) {
            tableName = entityName;
        }
        if (parentType == null) {
            entityType.setTable(amberManager.createTable(tableName));
        } else if (parentType.isJoinedSubClass()) {
            entityType.setTable(amberManager.createTable(tableName));
        } else {
            entityType.setTable(parentType.getTable());
        }
        JAnnotation tableCache = type.getAnnotation(EntityIntrospector._resin_compat_class_3());
        if (tableCache != null) {
            entityType.getTable().setReadOnly(tableCache.getBoolean("readOnly"));
            long cacheTimeout = Period.toPeriod(tableCache.getString("timeout"));
            entityType.getTable().setCacheTimeout(cacheTimeout);
        }
        JAnnotation secondaryTableAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_4());
        Table secondaryTable = null;
        if (inheritanceAnn != null) {
            this.introspectInheritance(amberManager, entityType, type);
        }
        if (secondaryTableAnn != null) {
            String secondaryName = (String)secondaryTableAnn.get("name");
            secondaryTable = amberManager.createTable(secondaryName);
            entityType.addSecondaryTable(secondaryTable);
        }
        if (entityType.getId() == null) {
            if (isField) {
                this.introspectIdField(amberManager, entityType, parentType, type);
            } else {
                this.introspectIdMethod(amberManager, entityType, parentType, type);
            }
        }
        if (isField) {
            this.introspectFields(amberManager, entityType, parentType, type);
        } else {
            this.introspectMethods(amberManager, entityType, parentType, type);
        }
        for (JMethod method : type.getMethods()) {
            this.introspectCallbacks(entityType, method);
        }
        if (secondaryTableAnn != null) {
            Object[] join = (Object[])secondaryTableAnn.get("join");
            JAnnotation[] joinAnn = new JAnnotation[join.length];
            System.arraycopy(join, 0, joinAnn, 0, join.length);
            this.linkSecondaryTable(entityType.getTable(), secondaryTable, joinAnn);
        }
        return entityType;
    }

    public void introspectCallbacks(EntityType type, JMethod method) throws ConfigException {
        JClass[] param = method.getParameterTypes();
        if (method.getAnnotation(EntityIntrospector._resin_compat_class_5()) != null) {
            type.addPrePersistCallback(method);
        }
        if (method.getAnnotation(EntityIntrospector._resin_compat_class_6()) != null) {
            type.addPostPersistCallback(method);
        }
    }

    public void validateType(JClass type) throws ConfigException {
        if (type.isFinal()) {
            throw new ConfigException(L.l("'{0}' must not be final.  Entity beans may not be final.", type.getName()));
        }
        if (type.isAbstract()) {
            throw new ConfigException(L.l("'{0}' must not be abstract.  Entity beans may not be abstract.", type.getName()));
        }
        this.validateConstructor(type);
        for (JMethod method : type.getMethods()) {
            if (!method.isFinal()) continue;
            throw new ConfigException(L.l("'{0}' must not be final.  Entity beans methods may not be final.", method.getFullName()));
        }
    }

    public void validateConstructor(JClass type) throws ConfigException {
        for (JMethod ctor : type.getConstructors()) {
            JClass[] param = ctor.getParameterTypes();
            if (param.length != 0 || !ctor.isPublic()) continue;
            return;
        }
        throw new ConfigException(L.l("'{0}' needs a public, no-arg constructor.", type.getName()));
    }

    public void validateNonGetter(JMethod method) throws ConfigException {
        JAnnotation ann = this.isAnnotatedMethod(method);
        if (ann != null) {
            throw new ConfigException(L.l("'{0}' is not a valid annotation for {1}.  Only public getters and fields may have property annotations.", (Object)ann.getType(), method.getFullName()));
        }
    }

    private JAnnotation isAnnotatedMethod(JMethod method) throws ConfigException {
        for (JAnnotation ann : method.getDeclaredAnnotations()) {
            if (!_propertyAnnotations.contains(ann.getType())) continue;
            return ann;
        }
        return null;
    }

    public void init() throws ConfigException {
        while (this._depCompletions.size() > 0 || this._linkCompletions.size() > 0) {
            Completion completion;
            while (this._linkCompletions.size() > 0) {
                completion = this._linkCompletions.remove(0);
                completion.complete();
            }
            if (this._depCompletions.size() <= 0) continue;
            completion = this._depCompletions.remove(0);
            completion.complete();
        }
    }

    private void introspectInheritance(AmberManager manager, EntityType entityType, JClass type) throws ConfigException, SQLException {
        JAnnotation inheritanceAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_1());
        String discriminatorValue = inheritanceAnn.getString("discriminatorValue");
        if (discriminatorValue == null || discriminatorValue.equals("")) {
            String name = entityType.getBeanClass().getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                name = name.substring(p + 1);
            }
            discriminatorValue = name;
        }
        entityType.setDiscriminatorValue(discriminatorValue);
        if (entityType instanceof SubEntityType) {
            SubEntityType subType = (SubEntityType)entityType;
            subType.getParentType().addSubClass(subType);
            JAnnotation joinAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_7());
            if (subType.isJoinedSubClass()) {
                this.linkInheritanceTable(subType.getRootType().getTable(), subType.getTable(), joinAnn);
                subType.setId(new SubId((EntityType)subType, subType.getRootType()));
            }
            return;
        }
        switch ((InheritanceType)inheritanceAnn.get("strategy")) {
            case JOINED: {
                entityType.setJoinedSubClass(true);
            }
        }
        JAnnotation discriminatorAnn = type.getAnnotation(EntityIntrospector._resin_compat_class_8());
        String columnName = null;
        if (discriminatorAnn != null) {
            columnName = discriminatorAnn.getString("name");
        }
        if (columnName == null || columnName.equals("")) {
            columnName = "TYPE";
        }
        Type columnType = null;
        switch ((DiscriminatorType)inheritanceAnn.get("discriminatorType")) {
            case STRING: {
                columnType = StringType.create();
                break;
            }
            case CHAR: {
                columnType = PrimitiveCharType.create();
                break;
            }
            case INTEGER: {
                columnType = PrimitiveIntType.create();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Column column = entityType.getTable().createColumn(columnName, columnType);
        if (discriminatorAnn != null) {
            column.setNotNull(!discriminatorAnn.getBoolean("nullable"));
            column.setLength(discriminatorAnn.getInt("length"));
            if (!"".equals(discriminatorAnn.get("columnDefinition"))) {
                column.setSQLType(discriminatorAnn.getString("columnDefinition"));
            }
        } else {
            column.setNotNull(true);
            column.setLength(10);
        }
        entityType.setDiscriminator(column);
    }

    private void introspectIdMethod(AmberManager manager, EntityType entityType, EntityType parentType, JClass type) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        for (JMethod method : type.getMethods()) {
            IdField idField;
            JAnnotation id;
            String methodName = method.getName();
            JClass[] paramTypes = method.getParameterTypes();
            if (!methodName.startsWith("get") || paramTypes.length != 0) continue;
            String fieldName = EntityIntrospector.toFieldName(methodName.substring(3));
            if (parentType != null && parentType.getField(fieldName) != null || (id = method.getAnnotation(EntityIntrospector._resin_compat_class_9())) == null || (idField = this.introspectId(manager, entityType, method, fieldName, method.getReturnType())) == null) continue;
            keys.add(idField);
        }
        if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            entityType.setId(new CompositeId(entityType, keys));
        }
    }

    private void introspectIdField(AmberManager manager, EntityType entityType, EntityType parentType, JClass type) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        for (JField field : type.getDeclaredFields()) {
            IdField idField;
            JAnnotation id;
            String fieldName = field.getName();
            if (parentType != null && parentType.getField(fieldName) != null || (id = field.getAnnotation(EntityIntrospector._resin_compat_class_9())) == null || (idField = this.introspectId(manager, entityType, field, fieldName, field.getType())) == null) continue;
            keys.add(idField);
        }
        if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            entityType.setId(new CompositeId(entityType, keys));
        }
    }

    private IdField introspectId(AmberManager manager, EntityType entityType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException, SQLException {
        JAnnotation id = field.getAnnotation(EntityIntrospector._resin_compat_class_9());
        JAnnotation column = field.getAnnotation(EntityIntrospector._resin_compat_class_10());
        Type amberType = manager.createType(fieldType);
        Column keyColumn = this.createColumn(entityType, "ID", column, amberType);
        KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
        JdbcMetaData metaData = manager.getMetaData();
        if (GeneratorType.IDENTITY.equals(id.get("generate"))) {
            if (!metaData.supportsIdentity()) {
                throw new ConfigException(L.l("'{0}' does not support identity.", metaData.getDatabaseName()));
            }
            keyColumn.setGeneratorType("identity");
            idField.setGenerator("identity");
        } else if (GeneratorType.SEQUENCE.equals(id.get("generate"))) {
            if (!metaData.supportsSequences()) {
                throw new ConfigException(L.l("'{0}' does not support sequence.", metaData.getDatabaseName()));
            }
            this.addSequenceIdGenerator(manager, idField, id);
        } else if (GeneratorType.TABLE.equals(id.get("generate"))) {
            this.addTableIdGenerator(manager, idField, id);
        } else if (GeneratorType.AUTO.equals(id.get("generate"))) {
            if (metaData.supportsIdentity()) {
                keyColumn.setGeneratorType("identity");
                idField.setGenerator("identity");
            } else if (metaData.supportsSequences()) {
                this.addSequenceIdGenerator(manager, idField, id);
            } else {
                this.addTableIdGenerator(manager, idField, id);
            }
        }
        return idField;
    }

    private void addSequenceIdGenerator(AmberManager manager, KeyPropertyField idField, JAnnotation idAnn) throws ConfigException {
        idField.setGenerator("sequence");
        idField.getColumn().setGeneratorType("sequence");
        String name = idAnn.getString("generator");
        if (name == null || "".equals(name)) {
            name = new CharBuffer().append(idField.getSourceType().getTable().getName()).append("_cseq").toString();
        }
        SequenceIdGenerator gen = manager.createSequenceGenerator(name, 1);
        idField.getSourceType().setGenerator(idField.getName(), gen);
    }

    private void addTableIdGenerator(AmberManager manager, KeyPropertyField idField, JAnnotation idAnn) throws ConfigException {
        IdGenerator gen;
        idField.setGenerator("table");
        idField.getColumn().setGeneratorType("table");
        String name = idAnn.getString("generator");
        if (name == null || "".equals(name)) {
            name = "caucho";
        }
        if ((gen = manager.getTableGenerator(name)) == null) {
            String genName = "GEN_TABLE";
            GeneratorTableType genTable = manager.createGeneratorTable(genName);
            gen = genTable.createGenerator(name);
            manager.putTableGenerator(name, gen);
        }
        idField.getSourceType().setGenerator(idField.getName(), gen);
    }

    private void linkSecondaryTable(Table primaryTable, Table secondaryTable, JAnnotation[] joinColumnsAnn) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (Column column : primaryTable.getIdColumns()) {
            JAnnotation joinAnn = this.getJoinColumn(joinColumnsAnn, column.getName());
            String name = joinAnn == null ? column.getName() : joinAnn.getString("name");
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    private void linkInheritanceTable(Table primaryTable, Table secondaryTable, JAnnotation joinAnn) throws ConfigException {
        if (joinAnn != null) {
            this.linkInheritanceTable(primaryTable, secondaryTable, new JAnnotation[]{joinAnn});
        } else {
            this.linkInheritanceTable(primaryTable, secondaryTable, (JAnnotation[])null);
        }
    }

    private void linkInheritanceTable(Table primaryTable, Table secondaryTable, JAnnotation[] joinColumnsAnn) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (Column column : primaryTable.getIdColumns()) {
            JAnnotation join = this.getJoinColumn(joinColumnsAnn, column.getName());
            String name = join == null ? column.getName() : join.getString("name");
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    private void introspectMethods(AmberManager manager, EntityType entityType, EntityType parentType, JClass type) throws ConfigException {
        if (entityType.getId() == null) {
            throw new IllegalStateException(L.l("{0} has no key", entityType));
        }
        for (JMethod method : type.getMethods()) {
            String propName;
            String methodName = method.getName();
            JClass[] paramTypes = method.getParameterTypes();
            this.introspectCallbacks(entityType, method);
            if (paramTypes.length != 0) {
                this.validateNonGetter(method);
                continue;
            }
            if (methodName.startsWith("get")) {
                propName = methodName.substring(3);
            } else if (methodName.startsWith("is") && (method.getReturnType().getName().equals("boolean") || method.getReturnType().getName().equals("java.lang.Boolean"))) {
                propName = methodName.substring(2);
            } else {
                this.validateNonGetter(method);
                continue;
            }
            if (type.getMethod(new CharBuffer().append("set").append(propName).toString(), new JClass[]{method.getReturnType()}) == null) {
                JAnnotation ann = this.isAnnotatedMethod(method);
            }
            if (method.isStatic() || !method.isPublic()) {
                this.validateNonGetter(method);
                continue;
            }
            String fieldName = EntityIntrospector.toFieldName(propName);
            if (parentType != null && parentType.getField(fieldName) != null) continue;
            JClass fieldType = method.getReturnType();
            this.introspectField(manager, entityType, method, fieldName, fieldType);
        }
    }

    private void introspectFields(AmberManager manager, EntityType entityType, EntityType parentType, JClass type) throws ConfigException {
        if (entityType.getId() == null) {
            throw new IllegalStateException(L.l("{0} has no key", entityType));
        }
        for (JField field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (parentType != null && parentType.getField(fieldName) != null || field.isStatic() || field.isTransient()) continue;
            JClass fieldType = field.getType();
            this.introspectField(manager, entityType, field, fieldName, fieldType);
        }
    }

    private void introspectField(AmberManager manager, EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        if (!field.isAnnotationPresent(EntityIntrospector._resin_compat_class_9())) {
            if (field.isAnnotationPresent(EntityIntrospector._resin_compat_class_11())) {
                this.addBasic(sourceType, field, fieldName, fieldType);
            } else if (field.isAnnotationPresent(EntityIntrospector._resin_compat_class_12())) {
                this._linkCompletions.add(new ManyToOneCompletion(sourceType, field, fieldName, fieldType));
            } else if (field.isAnnotationPresent(EntityIntrospector._resin_compat_class_13())) {
                this._depCompletions.add(new OneToManyCompletion(sourceType, field, fieldName, fieldType));
            } else if (field.isAnnotationPresent(EntityIntrospector._resin_compat_class_14())) {
                this._depCompletions.add(new OneToOneCompletion(sourceType, field, fieldName, fieldType));
            } else if (field.isAnnotationPresent(EntityIntrospector._resin_compat_class_15())) {
                this._depCompletions.add(new ManyToManyCompletion(sourceType, field, fieldName, fieldType));
            } else if (!field.isAnnotationPresent(EntityIntrospector._resin_compat_class_16())) {
                this.addBasic(sourceType, field, fieldName, fieldType);
            }
        }
    }

    private void addBasic(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        AmberManager manager = sourceType.getAmberManager();
        JAnnotation basicAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_11());
        JAnnotation columnAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_10());
        Type amberType = manager.createType(fieldType);
        Column fieldColumn = this.createColumn(sourceType, fieldName, columnAnn, amberType);
        PropertyField property = new PropertyField(sourceType, fieldName);
        property.setColumn(fieldColumn);
        if (basicAnn != null) {
            property.setLazy(basicAnn.get("fetch") == FetchType.LAZY);
        }
        sourceType.addField(property);
    }

    private Column createColumn(EntityType entityType, String name, JAnnotation columnAnn, Type amberType) throws ConfigException {
        Column column;
        if (columnAnn != null && !columnAnn.get("name").equals("")) {
            name = (String)columnAnn.get("name");
        }
        if (columnAnn != null && !columnAnn.get("secondaryTable").equals("")) {
            String tableName = columnAnn.getString("secondaryTable");
            Table table = entityType.getSecondaryTable(tableName);
            if (table == null) {
                throw new ConfigException(L.l("'{0}' is an unknown secondary table.", tableName));
            }
            column = table.createColumn(name, amberType);
        } else {
            column = entityType.getTable().createColumn(name, amberType);
        }
        if (columnAnn != null) {
            column.setUnique(columnAnn.getBoolean("unique"));
            column.setNotNull(!columnAnn.getBoolean("nullable"));
            if (!"".equals(columnAnn.getString("columnDefinition"))) {
                column.setSQLType(columnAnn.getString("columnDefinition"));
            }
            column.setLength(columnAnn.getInt("length"));
            int precision = columnAnn.getInt("precision");
            if (precision < 0) {
                throw new ConfigException(L.l("precision cannot be less than 0."));
            }
            int scale = columnAnn.getInt("scale");
            if (scale < 0) {
                throw new ConfigException(L.l("scale cannot be less than 0."));
            }
            if (scale > precision) {
                throw new ConfigException(L.l("Scale cannot be greater than precision. Must set precision to a non-zero value before setting scale."));
            }
            if (precision > 0) {
                column.setPrecision(precision);
                column.setScale(scale);
            }
        }
        return column;
    }

    private void addManyToOne(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        AmberManager manager = sourceType.getAmberManager();
        JAnnotation manyToOneAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_12());
        if (manyToOneAnn == null) {
            manyToOneAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_14());
        }
        JAnnotation joinColumns = field.getAnnotation(EntityIntrospector._resin_compat_class_17());
        JAnnotation[] joinColumnsAnn = null;
        if (joinColumns != null) {
            joinColumnsAnn = (JAnnotation[])joinColumns.get("value");
        }
        JAnnotation joinColumnAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_18());
        String targetName = manyToOneAnn.getString("targetEntity");
        if (targetName == null || targetName.equals("")) {
            targetName = fieldType.getName();
        }
        EntityManyToOneField manyToOneField = new EntityManyToOneField(sourceType, fieldName);
        EntityType targetType = manager.createEntity(targetName, fieldType);
        manyToOneField.setType(targetType);
        manyToOneField.setLazy(manyToOneAnn.get("fetch") == FetchType.LAZY);
        sourceType.addField(manyToOneField);
        Table sourceTable = sourceType.getTable();
        ArrayList<ForeignColumn> foreignColumns = new ArrayList<ForeignColumn>();
        for (Column keyColumn : targetType.getId().getColumns()) {
            JAnnotation joinAnn = this.getJoinColumn(joinColumnsAnn, keyColumn.getName());
            if (joinAnn == null) {
                joinAnn = joinColumnAnn;
            }
            String columnName = keyColumn.getName();
            if (joinAnn != null) {
                columnName = joinAnn.getString("name");
            }
            ForeignColumn foreignColumn = sourceTable.createForeignColumn(columnName, keyColumn);
            if (joinAnn != null) {
                foreignColumn.setNotNull(!joinAnn.getBoolean("nullable"));
                foreignColumn.setUnique(joinAnn.getBoolean("unique"));
            }
            foreignColumns.add(foreignColumn);
        }
        LinkColumns linkColumns = new LinkColumns(sourceType.getTable(), targetType.getTable(), foreignColumns);
        manyToOneField.setLinkColumns(linkColumns);
        manyToOneField.init();
    }

    private JAnnotation getJoinColumn(JAnnotation joinColumns, String keyName) {
        if (joinColumns == null) {
            return null;
        }
        return this.getJoinColumn((JAnnotation[])joinColumns.get("value"), keyName);
    }

    private JAnnotation getJoinColumn(JAnnotation[] columnsAnn, String keyName) {
        if (columnsAnn == null || columnsAnn.length == 0) {
            return null;
        }
        for (int i = 0; i < columnsAnn.length; ++i) {
            String ref = columnsAnn[i].getString("referencedColumnName");
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return columnsAnn[i];
        }
        return null;
    }

    private void addManyToMany(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        JAnnotation manyToManyAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_15());
        AmberManager manager = sourceType.getAmberManager();
        JType retType = field instanceof JField ? ((JField)field).getGenericType() : ((JMethod)field).getGenericReturnType();
        JType[] typeArgs = retType.getActualTypeArguments();
        String targetName = manyToManyAnn.getString("targetEntity");
        if (targetName == null || targetName.equals("")) {
            if (typeArgs.length > 0) {
                targetName = typeArgs[0].getName();
            } else {
                throw new ConfigException(L.l("can't determine target name for {0}", fieldName));
            }
        }
        EntityType targetType = manager.getEntity(targetName);
        EntityManyToManyField manyToManyField = new EntityManyToManyField(sourceType, fieldName);
        manyToManyField.setType(targetType);
        JAnnotation associationTableAnn = field.getAnnotation(EntityIntrospector._resin_compat_class_19());
        String sqlTable = new CharBuffer().append(sourceType.getTable().getName()).append("_").append(targetType.getTable().getName()).toString();
        Table mapTable = null;
        ArrayList<ForeignColumn> sourceColumns = null;
        ArrayList<ForeignColumn> targetColumns = null;
        if (associationTableAnn != null) {
            JAnnotation table = associationTableAnn.getAnnotation("table");
            if (!table.getString("name").equals("")) {
                sqlTable = table.getString("name");
            }
            mapTable = manager.createTable(sqlTable);
            sourceColumns = EntityIntrospector.calculateColumns(mapTable, sourceType, (Object[])associationTableAnn.get("joinColumns"));
            targetColumns = EntityIntrospector.calculateColumns(mapTable, targetType, (Object[])associationTableAnn.get("inverseJoinColumns"));
        } else {
            mapTable = manager.createTable(sqlTable);
            sourceColumns = EntityIntrospector.calculateColumns(mapTable, sourceType);
            targetColumns = EntityIntrospector.calculateColumns(mapTable, targetType);
        }
        manyToManyField.setAssociationTable(mapTable);
        manyToManyField.setTable(sqlTable);
        manyToManyField.setSourceLink(new LinkColumns(mapTable, sourceType.getTable(), sourceColumns));
        manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
        sourceType.addField(manyToManyField);
    }

    static String toFieldName(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        if (name.length() == 1 || Character.isLowerCase(name.charAt(1))) {
            return new CharBuffer().append(Character.toLowerCase(name.charAt(0))).append(name.substring(1)).toString();
        }
        return name;
    }

    static ArrayList<ForeignColumn> calculateColumns(Table mapTable, EntityType type, Object[] joinColumnsAnn) {
        if (joinColumnsAnn == null || joinColumnsAnn.length == 0) {
            return EntityIntrospector.calculateColumns(mapTable, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        for (int i = 0; i < joinColumnsAnn.length; ++i) {
            JAnnotation joinColumnAnn = (JAnnotation)joinColumnsAnn[i];
            ForeignColumn foreignColumn = mapTable.createForeignColumn(joinColumnAnn.getString("name"), type.getId().getKey().getColumns().get(0));
            columns.add(foreignColumn);
        }
        return columns;
    }

    static ArrayList<ForeignColumn> calculateColumns(Table mapTable, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        for (Column key : type.getId().getColumns()) {
            columns.add(mapTable.createForeignColumn(key.getName(), key));
        }
        return columns;
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i > 0 && i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    static {
        _propertyAnnotations.add("javax.ejb.Basic");
        _propertyAnnotations.add("javax.ejb.Column");
        _propertyAnnotations.add("javax.ejb.Id");
        _propertyAnnotations.add("javax.ejb.Transient");
        _propertyAnnotations.add("javax.ejb.OneToOne");
        _propertyAnnotations.add("javax.ejb.ManyToOne");
        _propertyAnnotations.add("javax.ejb.OneToMany");
        _propertyAnnotations.add("javax.ejb.ManyToMany");
        _propertyAnnotations.add("javax.ejb.JoinColumn");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.Entity");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.Inheritance");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.Table");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("com.caucho.amber.AmberTableCache");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.ejb.SecondaryTable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("javax.ejb.PrePersist");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("javax.ejb.PostPersist");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("javax.ejb.InheritanceJoinColumn");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("javax.ejb.DiscriminatorColumn");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("javax.ejb.Id");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("javax.ejb.Column");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("javax.ejb.Basic");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("javax.ejb.ManyToOne");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_13() {
        try {
            Class<?> clazz = _resin_compat_class_13;
            if (clazz == null) {
                clazz = _resin_compat_class_13 = Class.forName("javax.ejb.OneToMany");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_14() {
        try {
            Class<?> clazz = _resin_compat_class_14;
            if (clazz == null) {
                clazz = _resin_compat_class_14 = Class.forName("javax.ejb.OneToOne");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_15() {
        try {
            Class<?> clazz = _resin_compat_class_15;
            if (clazz == null) {
                clazz = _resin_compat_class_15 = Class.forName("javax.ejb.ManyToMany");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_16() {
        try {
            Class<?> clazz = _resin_compat_class_16;
            if (clazz == null) {
                clazz = _resin_compat_class_16 = Class.forName("javax.ejb.Transient");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_17() {
        try {
            Class<?> clazz = _resin_compat_class_17;
            if (clazz == null) {
                clazz = _resin_compat_class_17 = Class.forName("javax.ejb.JoinColumns");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_18() {
        try {
            Class<?> clazz = _resin_compat_class_18;
            if (clazz == null) {
                clazz = _resin_compat_class_18 = Class.forName("javax.ejb.JoinColumn");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_19() {
        try {
            Class<?> clazz = _resin_compat_class_19;
            if (clazz == null) {
                clazz = _resin_compat_class_19 = Class.forName("javax.ejb.AssociationTable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_20() {
        try {
            Class<?> clazz = _resin_compat_class_20;
            if (clazz == null) {
                clazz = _resin_compat_class_20 = Class.forName("com.caucho.ejb.entity2.EntityIntrospector");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class ManyToOneCompletion
    extends Completion {
        private EntityType _entityType;
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;

        ManyToOneCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            EntityIntrospector.this.addManyToOne(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class ManyToManyCompletion
    extends Completion {
        private EntityType _entityType;
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;

        ManyToManyCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            EntityIntrospector.this.addManyToMany(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class OneToOneCompletion
    extends Completion {
        private EntityType _entityType;
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;
        private static Class _resin_compat_class_0;

        OneToOneCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            JAnnotation oneToOneAnn = this._field.getAnnotation(OneToOneCompletion._resin_compat_class_0());
            AmberManager manager = this._entityType.getAmberManager();
            String targetName = oneToOneAnn.getString("targetEntity");
            String mappedBy = oneToOneAnn.getString("mappedBy");
            EntityType targetType = null;
            if (targetName != null && !targetName.equals("")) {
                targetType = manager.getEntity(targetName);
                if (targetType == null) {
                    throw new ConfigException(L.l("{0}: '{1}' is an unknown entity for '{2}'.", this._field.getDeclaringClass().getName(), targetName, this._field.getName()));
                }
            } else {
                targetType = manager.getEntity(this._field.getReturnType().getName());
                if (targetType == null) {
                    throw new ConfigException(L.l("{0} can't determine target name for '{1}'", (Object)this._field.getDeclaringClass().getName(), this._field.getName()));
                }
            }
            if (mappedBy == null || mappedBy.equals("")) {
                EntityIntrospector.this.addManyToOne(this._entityType, this._field, this._fieldName, this._field.getReturnType());
            } else {
                EntityManyToOneField sourceField = this.getSourceField(targetType, mappedBy);
                if (sourceField == null) {
                    throw new ConfigException(L.l("{0}: OneToOne target '{1}' does not have a matching ManyToOne relation.", (Object)this._field.getDeclaringClass().getName(), targetType.getName()));
                }
                DependentEntityOneToOneField oneToOne = new DependentEntityOneToOneField(this._entityType, this._fieldName);
                oneToOne.setTargetField(sourceField);
                this._entityType.addField(oneToOne);
            }
        }

        private EntityManyToOneField getSourceField(EntityType targetType, String mappedBy) {
            Iterator<AmberField> i$ = targetType.getFields().iterator();
            while (i$.hasNext()) {
                AmberField field = i$.next();
                if (!field.getName().equals(mappedBy)) continue;
                return (EntityManyToOneField)field;
            }
            return null;
        }

        private static Class _resin_compat_class_0() {
            try {
                Class<?> clazz = _resin_compat_class_0;
                if (clazz == null) {
                    clazz = _resin_compat_class_0 = Class.forName("javax.ejb.OneToOne");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    class OneToManyCompletion
    extends Completion {
        private EntityType _entityType;
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;
        private static Class _resin_compat_class_0;

        OneToManyCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            EntityType targetType;
            JAnnotation oneToManyAnn = this._field.getAnnotation(OneToManyCompletion._resin_compat_class_0());
            AmberManager manager = this._entityType.getAmberManager();
            JType retType = this._field instanceof JField ? ((JField)this._field).getGenericType() : ((JMethod)this._field).getGenericReturnType();
            JType[] typeArgs = retType.getActualTypeArguments();
            String targetName = oneToManyAnn.getString("targetEntity");
            if (targetName == null || targetName.equals("")) {
                if (typeArgs.length > 0) {
                    targetName = typeArgs[0].getName();
                } else {
                    throw new ConfigException(L.l("can't determine target name for {0}", this._fieldName));
                }
            }
            if ((targetType = manager.getEntity(targetName)) == null) {
                throw new ConfigException(L.l("'{0}' is an unknown entity.", targetName));
            }
            EntityManyToOneField sourceField = this.getSourceField(targetType, this._entityType);
            if (sourceField == null) {
                throw new ConfigException(L.l("'{0}' does not have a matching ManyToOne relation.", targetType.getName()));
            }
            EntityOneToManyField oneToMany = new EntityOneToManyField(this._entityType, this._fieldName);
            oneToMany.setSourceField(sourceField);
            this._entityType.addField(oneToMany);
        }

        private EntityManyToOneField getSourceField(EntityType targetType, EntityType entity) {
            Iterator<AmberField> i$ = targetType.getFields().iterator();
            while (i$.hasNext()) {
                EntityManyToOneField manyToOne;
                AmberField field = i$.next();
                if (!(field instanceof EntityManyToOneField) || !(manyToOne = (EntityManyToOneField)field).getEntityType().equals(entity)) continue;
                return manyToOne;
            }
            return null;
        }

        private static Class _resin_compat_class_0() {
            try {
                Class<?> clazz = _resin_compat_class_0;
                if (clazz == null) {
                    clazz = _resin_compat_class_0 = Class.forName("javax.ejb.OneToMany");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    class Completion {
        Completion() {
        }

        void complete() throws ConfigException {
        }
    }
}

