/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbView;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;

public class EjbMethod {
    private static final L10N L = new L10N(EjbMethod._resin_compat_class_0());
    public static final int TRANS_BEAN = 0;
    public static final int TRANS_NOT_SUPPORTED = 1;
    public static final int TRANS_SUPPORTS = 2;
    public static final int TRANS_REQUIRED = 3;
    public static final int TRANS_REQUIRES_NEW = 4;
    public static final int TRANS_MANDATORY = 5;
    public static final int TRANS_NEVER = 6;
    public static final int TRANS_SINGLE_READ = 7;
    public static final int RESIN_DATABASE = 0;
    public static final int RESIN_READ_ONLY = 1;
    public static final int RESIN_ROW_LOCKING = 2;
    private EjbView _view;
    private JMethod _apiMethod;
    private JMethod _implMethod;
    private static Class _resin_compat_class_0;

    public EjbMethod(EjbView view, JMethod apiMethod, JMethod implMethod) {
        if (apiMethod == null) {
            throw new NullPointerException();
        }
        this._view = view;
        this._apiMethod = apiMethod;
        this._implMethod = implMethod;
    }

    public EjbView getView() {
        return this._view;
    }

    public String getViewPrefix() {
        return this._view.getPrefix();
    }

    public JMethod getApiMethod() {
        return this._apiMethod;
    }

    public JMethod getImplMethod() {
        return this._implMethod;
    }

    public void assembleBean(BeanAssembler beanAssembler, String fullClassName) throws ConfigException {
    }

    public BaseMethod assemble(ViewClass viewAssembler, String fullClassName) throws ConfigException {
        if (this.getImplMethod() == null) {
            throw new NullPointerException(new CharBuffer().append("no impl: ").append(this.getApiMethod()).toString());
        }
        BaseMethod method = viewAssembler.createBusinessMethod(this);
        method.setCall(this.assembleCallChain(method.getCall()));
        return method;
    }

    protected CallChain assembleCallChain(CallChain call) {
        call = this.getView().getTransactionChain(call, this.getApiMethod(), this.getViewPrefix());
        call = this.getView().getSecurityChain(call, this.getApiMethod(), this.getViewPrefix());
        return call;
    }

    protected void pushRequired(JavaWriter out) throws IOException {
        out.println("com.caucho.ejb.xa.TransactionContext xa = _xaManager.beginRequired();");
        out.println("try {");
        out.pushDepth();
    }

    protected void popRequired(JavaWriter out) throws IOException {
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw trans.setRollbackOnly(e);");
        out.println("} finally {");
        out.println("  trans.commit();");
        out.println("}");
    }

    public boolean equals(Object o) {
        if (!(o instanceof EjbMethod)) {
            return false;
        }
        EjbMethod method = (EjbMethod)o;
        if (this._view != method._view) {
            return false;
        }
        return this._apiMethod.equals(method._apiMethod);
    }

    public String toString() {
        return new CharBuffer().append("EJBMethod[").append(this._apiMethod).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.cfg.EjbMethod");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

