/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbAmberFindMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbEntityCreateMethod;
import com.caucho.ejb.cfg.EjbEntityFindMethod;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class EjbEntityHomeView
extends EjbHomeView {
    private static final Logger log = Log.open(EjbEntityHomeView._resin_compat_class_0());
    private static final L10N L = new L10N(EjbEntityHomeView._resin_compat_class_0());
    private boolean _hasFindByPrimaryKey;
    private static Class _resin_compat_class_0;

    public EjbEntityHomeView(EjbBean bean, JClass apiClass, String prefix) throws ConfigException {
        super(bean, apiClass, prefix);
    }

    protected boolean isCMP() {
        return ((EjbEntityBean)this.getBean()).isCMP();
    }

    protected void introspect() throws ConfigException {
        super.introspect();
        if (!this._hasFindByPrimaryKey) {
            throw new ConfigException(L.l("{0}: expected 'findByPrimaryKey'.  All entity homes must define findByPrimaryKey.", this.getApiClass().getName()));
        }
    }

    protected EjbMethod introspectEJBMethod(JMethod method) throws ConfigException {
        String methodName = method.getName();
        JClass[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbCreate")) {
            String apiMethodName = new CharBuffer().append("c").append(methodName.substring(4)).toString();
            JMethod apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            String postMethodName = new CharBuffer().append("ejbPost").append(methodName.substring(3)).toString();
            JMethod postCreateMethod = EjbBean.getMethod(this.getImplClass(), postMethodName, method.getParameterTypes());
            return new EjbEntityCreateMethod(this, apiMethod, method, postCreateMethod);
        }
        if (methodName.startsWith("ejbFind")) {
            if (methodName.equals("ejbFindByPrimaryKey")) {
                this._hasFindByPrimaryKey = true;
                JClass primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
                if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass)) {
                    throw this.error(L.l("{0}: '{1}' expected as only argument of {2}. ejbFindByPrimaryKey must take the primary key as its only argument.", method.getDeclaringClass().getName(), primKeyClass.getName(), methodName));
                }
            }
            String apiMethodName = new CharBuffer().append("f").append(methodName.substring(4)).toString();
            JMethod apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod != null) {
                return new EjbEntityFindMethod(this, apiMethod, method);
            }
        } else if (methodName.startsWith("ejbHome")) {
            String apiMethodName = new CharBuffer().append(Character.toLowerCase(methodName.charAt(7))).append(methodName.substring(8)).toString();
            JMethod apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            this.validateImplMethod(method);
            return new EjbMethod(this, apiMethod, method);
        }
        return null;
    }

    protected EjbMethod introspectApiMethod(JMethod apiMethod) throws ConfigException {
        String methodName = apiMethod.getName();
        JClass[] paramTypes = apiMethod.getParameterTypes();
        if (methodName.equals("findByPrimaryKey")) {
            this._hasFindByPrimaryKey = true;
            JClass primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
            if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass)) {
                throw this.error(L.l("{0}: `{1}' expected as only argument of {2}. findByPrimaryKey must take the primary key as its only argument.", apiMethod.getDeclaringClass().getName(), primKeyClass.getName(), methodName));
            }
            return new EjbEntityFindMethod(this, apiMethod);
        }
        if (methodName.startsWith("find")) {
            if (this.isCMP()) {
                EjbMethodPattern pattern = this.findMethodPattern(apiMethod, this.getPrefix());
                if (pattern == null) {
                    throw this.error(L.l("{0}: '{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
                }
                String query = pattern.getQuery();
                EjbAmberFindMethod findMethod = new EjbAmberFindMethod(this, apiMethod, query, pattern.getQueryLocation());
                findMethod.setQueryLoadsBean(pattern.getQueryLoadsBean());
                return findMethod;
            }
            String name = methodName;
            name = new CharBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
            throw this.errorMissingMethod(this.getImplClass(), new CharBuffer().append("ejb").append(name).toString(), apiMethod);
        }
        if (methodName.startsWith("create")) {
            String name = apiMethod.getName();
            name = new CharBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
            throw this.errorMissingMethod(this.getImplClass(), new CharBuffer().append("ejb").append(name).toString(), apiMethod);
        }
        if (methodName.startsWith("ejb")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  ejbXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        if (methodName.startsWith("remove")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  removeXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        String name = apiMethod.getName();
        name = new CharBuffer().append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
        throw this.errorMissingMethod(this.getImplClass(), new CharBuffer().append("ejbHome").append(name).toString(), apiMethod);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.cfg.EjbEntityHomeView");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

