/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmpFieldProxy;
import com.caucho.ejb.cfg.CmpProperty;
import com.caucho.ejb.cfg.CmrMap;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbAmberSelectMethod;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbCmpView;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityHomeView;
import com.caucho.ejb.cfg.EjbEntityView;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg.Query;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.gen.AmberAssembler;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.EntityAssembler;
import com.caucho.ejb.gen.EntityCreateMethod;
import com.caucho.ejb.gen.EntityFindMethod;
import com.caucho.ejb.gen.EntityHomePoolChain;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbEntityBean
extends EjbBean {
    private static final L10N L = new L10N(EjbEntityBean._resin_compat_class_12());
    private JClassWrapper _primKeyClass;
    private String _primKeyField;
    private JClass _compositeKeyClass;
    private String _cmpVersion = "2.x";
    private boolean _isCMP = false;
    private DataSource _dataSource;
    private String _abstractSchemaName;
    private String _sqlTable;
    private long _cacheTimeout = 2000L;
    private int _cacheSize = -666;
    private boolean _loadLazyOnTransaction = true;
    private boolean _isReadOnly = false;
    private boolean _isReentrant = true;
    private ArrayList<CmpField> _fields = new ArrayList();
    private ArrayList<CmrRelation> _relations = new ArrayList();
    private ArrayList<JMethod> _stubMethods = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;

    public EjbEntityBean(EjbConfig ejbConfig) {
        super(ejbConfig);
        EjbServerManager ejbManager = ejbConfig.getEJBManager();
        this._cacheTimeout = ejbManager.getCacheTimeout();
        this._loadLazyOnTransaction = ejbManager.isEntityLoadLazyOnTransaction();
    }

    @Override
    public String getEJBKind() {
        return "entity";
    }

    @Override
    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (!EjbEntityBean._resin_compat_class_0().isAssignableFrom(ejbClass) && !this.isAllowPOJO()) {
            throw this.error(L.l("`{0}' must implement EntityBean.  Entity beans must implement javax.ejb.EntityBean.", ejbClass.getName()));
        }
        this.validateNonFinalMethod("setEntityContext", new JClass[]{JClassLoader.systemForName(EjbEntityBean._resin_compat_class_1().getName())}, this.isAllowPOJO());
        this.validateNonFinalMethod("unsetEntityContext", new JClass[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbActivate", new JClass[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbPassivate", new JClass[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbRemove", new JClass[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbLoad", new JClass[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbStore", new JClass[0], this.isAllowPOJO());
    }

    public EntityType getEntityType() {
        AmberManager amberManager = this.getConfig().getEJBManager().getAmberManager();
        EntityType type = amberManager.createEntity(this.getAbstractSchemaName(), this.getEJBClassWrapper());
        type.setProxyClass(this.getLocal());
        return type;
    }

    public JClass getPrimKeyClass() {
        return this._primKeyClass;
    }

    public void setPrimKeyClass(Class cl) {
        this._primKeyClass = new JClassWrapper(cl, this._jClassLoader);
    }

    public JClass getCompositeKeyClass() {
        return this._compositeKeyClass;
    }

    public String getPrimKeyField() {
        return this._primKeyField;
    }

    public void setPrimKeyField(String field) {
        this._primKeyField = field;
    }

    public void setPersistenceType(String type) throws ConfigException {
        if ("Bean".equals(type)) {
            this._isCMP = false;
        } else if ("Container".equals(type)) {
            this._isCMP = true;
        } else {
            throw new ConfigException(L.l("`{0}' is an known persistence-type.  <persistence-type> must either be `Bean' or `Container'.", type));
        }
    }

    public boolean isCMP() {
        return this._isCMP && "2.x".equals(this._cmpVersion);
    }

    public void setCMP(boolean isCMP) {
        this._isCMP = isCMP;
    }

    public boolean isCMP1() {
        return this._isCMP && "1.x".equals(this._cmpVersion);
    }

    @Override
    public String getFullImplName() {
        if (this.isCMP()) {
            String name = new CharBuffer().append("_ejb.").append(this.getEJBName()).append(".").append(this.getEJBClassName()).append("__Amber").toString();
            return JavaClassGenerator.cleanClassName(name);
        }
        return super.getFullImplName();
    }

    public void setCmpVersion(String version) throws ConfigException {
        this._cmpVersion = version;
        if (!version.equals("1.x") && !version.equals("2.x")) {
            throw this.error(L.l("CMP version `{0}' is not currently supported.  Only CMP version 1.x and 2.x are supported.", version));
        }
    }

    public void setReentrant(boolean reentrant) throws ConfigException {
        this._isReentrant = reentrant;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getAbstractSchemaName() {
        if (this._abstractSchemaName != null) {
            return this._abstractSchemaName;
        }
        String name = this.getEJBName();
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return name;
        }
        return name.substring(p + 1);
    }

    public void setAbstractSchemaName(String abstractSchema) throws ConfigException {
        this._abstractSchemaName = abstractSchema;
        EjbEntityBean bean = this.getConfig().findEntityBySchema(abstractSchema);
        if (bean != null && this != bean) {
            throw new ConfigException(L.l("Entity bean '{0}' already has abstract schema '{1}'.  abstract-schema-name values must be distinct.", (Object)bean.getEJBName(), abstractSchema));
        }
    }

    public String getSQLTable() {
        return this._sqlTable;
    }

    public void setSQLTable(String sqlTable) {
        this._sqlTable = sqlTable;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public void setCacheTimeout(Period cacheTimeout) {
        this._cacheTimeout = cacheTimeout.getPeriod();
    }

    public long getCacheTimeout() {
        return this._cacheTimeout;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public CmpFieldProxy createCmpField() {
        return new CmpFieldProxy(this);
    }

    public ArrayList<CmpField> getCmpFields() {
        return this._fields;
    }

    public CmpField getCmpField(String fieldName) {
        for (int i = 0; i < this._fields.size(); ++i) {
            CmpField field = this._fields.get(i);
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public CmpField addField(String fieldName) throws ConfigException {
        CmpField field = this.getCmpField(fieldName);
        if (field == null) {
            field = new CmpField(this);
            field.setFieldName(fieldName);
            field.init();
            this._fields.add(field);
        }
        return field;
    }

    public JMethod getFieldGetter(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String methodName = new CharBuffer().append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
        try {
            return EjbEntityBean.getMethod(this.getEJBClassWrapper(), methodName, new JClass[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void addRelation(CmrRelation relation) throws ConfigException {
        String fieldName = relation.getName();
        JMethod method = this.getMethodField(fieldName);
        if (method == null && !(relation instanceof CmrMap)) {
            throw this.error(L.l("'{0}' is a missing method", fieldName));
        }
        this._relations.add(relation);
    }

    public CmrRelation getRelation(String relationName) {
        for (int i = 0; i < this._relations.size(); ++i) {
            CmrRelation relation = this._relations.get(i);
            if (!relationName.equals(relation.getName())) continue;
            return relation;
        }
        return null;
    }

    public ArrayList<CmrRelation> getRelations() {
        return this._relations;
    }

    public ArrayList<JMethod> getStubMethods() {
        return this._stubMethods;
    }

    public void addStubMethod(JMethod method) {
        if (!this._stubMethods.contains(method)) {
            this._stubMethods.add(method);
        }
    }

    public JClass getFieldType(String fieldName) {
        JMethod method = this.getMethodField(fieldName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }

    public Query createQuery() {
        return new Query(this);
    }

    public void addQuery(Query query) {
        MethodSignature sig = query.getSignature();
        EjbMethodPattern method = this.getMethod(sig);
        if (method == null) {
            method = new EjbMethodPattern(this, sig);
            method.setLocation(query.getConfigLocation());
            this._methodList.add(method);
        }
        method.setQueryLocation(query.getConfigLocation());
        method.setQuery(query.getEjbQl());
    }

    public EjbMethodPattern getMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = (EjbMethodPattern)this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        return null;
    }

    public EjbMethodPattern getQuery(JMethod method, String intf) {
        return this.getMethodPattern(method, intf);
    }

    public ArrayList<EjbMethodPattern> getQueryList() {
        return this._methodList;
    }

    @Override
    public void init() throws ConfigException {
        try {
            if (!this.isCMP() && this.getEJBClassWrapper().isAbstract()) {
                throw this.error(L.l("'{0}' must not be abstract. BMP entity beans may not be abstract.", this.getEJBClass().getName()));
            }
            super.init();
            if (!(this._primKeyClass != null || this.isAllowPOJO() || this.getRemote() == null && this.getLocal() == null)) {
                throw new ConfigException(L.l("{0}: <entity> has no primary key class.  Entity beans must define a prim-key-class.", this.getEJBClass().getName()));
            }
            if (this.getRemoteHome() != null) {
                this.validateHome(this.getRemoteHome());
            }
            if (this.getLocalHome() != null) {
                this.validateHome(this.getLocalHome());
            }
            if (this.getRemote() != null) {
                this.validateRemote(this.getRemote());
            }
            if (this.getLocal() != null) {
                this.validateRemote(this.getLocal());
            }
            this.validateMethods();
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(new CharBuffer().append(this.getLocation()).append(e.getMessage()).toString(), e);
        }
    }

    @Override
    public void introspect() throws ConfigException {
        if (this.isCMP()) {
            this.introspectCMPFields();
            this.introspectCMPId();
            this.validateCMPFields();
        }
    }

    protected void introspectCMPFields() throws ConfigException {
        JMethod[] methods;
        for (JMethod method : methods = EjbEntityBean.getMethods(this.getEJBClassWrapper())) {
            String fieldName;
            CmrRelation rel;
            String name;
            if (!method.isAbstract() || !(name = method.getName()).startsWith("get") || name.length() <= 3 || method.getParameterTypes().length != 0 || (rel = this.getRelation(fieldName = EjbEntityBean.getterToFieldName(name))) != null) continue;
            JClass type = method.getReturnType();
            if (type.isAssignableTo(EjbEntityBean._resin_compat_class_2())) {
                throw this.error(L.l("'{0}' needs to be a relation", fieldName));
            }
            if (type.isAssignableTo(EjbEntityBean._resin_compat_class_3())) {
                throw this.error(L.l("{0}: '{1}' needs to be defined in an ejb-relation for getter method {2}.", this.getEJBClass().getName(), fieldName, method.getFullName()));
            }
            if (type.isAssignableTo(EjbEntityBean._resin_compat_class_4())) {
                throw this.error(L.l("'{0}' needs to be a relation", fieldName));
            }
            CmpField cmpField = this.addField(fieldName);
            cmpField.setJavaType(method.getReturnType());
        }
    }

    protected void validateCMPFields() throws ConfigException {
        JMethod[] methods;
        for (JMethod method : methods = EjbEntityBean.getMethods(this.getEJBClassWrapper())) {
            String fieldName;
            String name;
            if (!method.isAbstract() || (name = method.getName()).startsWith("ejb")) continue;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                if (this.getCmpField(fieldName) != null || this.getRelation(fieldName) != null) {
                    continue;
                }
            } else if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 1) {
                CmrMap map;
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmrRelation rel = this.getRelation(fieldName);
                if (rel instanceof CmrMap && method.equals((map = (CmrMap)rel).getMapMethod())) {
                    continue;
                }
            } else if (name.startsWith("set") && name.length() > 3 && method.getParameterTypes().length == 1) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmpField field = this.getCmpField(fieldName);
                if (field != null) {
                    if (EjbEntityBean.isMatch(method, field.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", this.getEJBClass().getName(), method.getFullName(), field.getGetter().getFullName()));
                }
                CmrRelation rel = this.getRelation(fieldName);
                if (rel != null) {
                    if (method.equals(rel.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", this.getEJBClass().getName(), method.getFullName(), rel.getGetter().getFullName()));
                }
            }
            throw this.error(L.l("{0}: '{1}' must not be abstract.  Business methods must be implemented.", (Object)this.getEJBClass().getName(), method.getFullName()));
        }
    }

    protected void introspectCMPId() throws ConfigException {
        CmpProperty property;
        if (!(this._primKeyClass == null || this._primKeyClass.isPrimitive() || this._primKeyClass.getName().startsWith("java.lang.") || this._primKeyClass.getName().equals("java.util.Date") || this._primKeyClass.getName().equals("java.sql.Date") || this._primKeyClass.getName().equals("java.sql.Time") || this._primKeyClass.getName().equals("java.sql.Timestamp") || this._primKeyClass.isAssignableTo(EjbEntityBean._resin_compat_class_3()))) {
            if (this._primKeyField != null) {
                throw this.error(L.l("{0}: 'primkey-field' must not be defined for a composite primkey-class.", this.getEJBClass().getName()));
            }
            this._compositeKeyClass = this._primKeyClass;
            this.introspectCMPCompositeId();
            return;
        }
        String id = this._primKeyField;
        if (id == null) {
            id = "id";
        }
        if ((property = this.getCmpField(id)) == null) {
            property = this.getRelation(id);
        }
        if (property == null) {
            throw this.error(L.l("{0}: primary key field '{1}' is an unknown cmp-field", (Object)this.getEJBClass().getName(), id));
        }
        property.setId(true);
    }

    protected void introspectCMPCompositeId() throws ConfigException {
        try {
            JMethod equals = this._primKeyClass.getMethod("equals", new JClass[]{JClass.OBJECT});
            if (equals.getDeclaringClass().equals(JClass.OBJECT)) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'equals' method.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            JMethod hashCode = this._primKeyClass.getMethod("hashCode", new JClass[0]);
            if (hashCode.getDeclaringClass().getName().equals(EjbEntityBean._resin_compat_class_5().getName())) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'hashCode' method.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this._primKeyClass.getFields().length == 0) {
            throw this.error(L.l("{0}: compound key '{1}' has no public accessible fields.  Compound key fields must be public.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
        }
        for (JField field : this._primKeyClass.getFields()) {
            CmpProperty cmpProperty = this.getCmpField(field.getName());
            if (cmpProperty == null) {
                cmpProperty = this.getRelation(field.getName());
            }
            if (cmpProperty == null) {
                throw this.error(L.l("{0}: primary key field '{1}' is an unknown field.", (Object)this.getEJBClass().getName(), field.getName()));
            }
            cmpProperty.setId(true);
        }
    }

    private static String getterToFieldName(String name) {
        String fieldName = name.substring(3);
        char ch = fieldName.charAt(0);
        if (Character.isUpperCase(ch) && (fieldName.length() == 1 || Character.isLowerCase(fieldName.charAt(1)))) {
            fieldName = new CharBuffer().append(Character.toLowerCase(ch)).append(fieldName.substring(1)).toString();
        }
        return fieldName;
    }

    @Override
    public void configureAmber(AmberConfig config) throws ConfigException {
        if (this.isCMP()) {
            try {
                config.addBean(this);
            }
            catch (LineConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LineConfigException(new CharBuffer().append(this.getLocation()).append(e.getMessage()).toString(), e);
            }
        }
    }

    @Override
    protected BeanAssembler createAssembler(String fullClassName) {
        if (this.isCMP()) {
            return new AmberAssembler(this, fullClassName);
        }
        return new EntityAssembler(this, fullClassName);
    }

    @Override
    protected void addImports(BeanAssembler assembler) {
        super.addImports(assembler);
        assembler.addImport("com.caucho.ejb.FinderExceptionWrapper");
        assembler.addImport("com.caucho.ejb.entity.EntityServer");
        assembler.addImport("com.caucho.ejb.entity.QEntityContext");
        assembler.addImport("com.caucho.ejb.entity.EntityHome");
        assembler.addImport("com.caucho.ejb.entity.EntityLocalHome");
        assembler.addImport("com.caucho.ejb.entity.EntityRemoteHome");
        assembler.addImport("com.caucho.ejb.entity.EntityObject");
        assembler.addImport("com.caucho.ejb.entity.QEntity");
    }

    @Override
    protected EjbBaseMethod introspectEJBMethod(JMethod method) throws ConfigException {
        String methodName = method.getName();
        JClass[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbSelect") && method.isAbstract()) {
            this.validateSelectMethod(method);
            EjbMethodPattern pattern = this.getMethodPattern(method, "Local");
            if (pattern == null) {
                throw this.error(L.l("{0}: '{1}' expects an ejb-ql query. ejbSelect methods must have an ejb-ql query in the deployment descriptor.", (Object)this.getEJBClass().getName(), method.getFullName()));
            }
            String query = pattern.getQuery();
            EjbAmberSelectMethod select = new EjbAmberSelectMethod(this, method, query, pattern.getQueryLocation());
            select.setQueryLoadsBean(pattern.getQueryLoadsBean());
            return select;
        }
        return null;
    }

    @Override
    protected void validateImplMethod(JMethod method) throws ConfigException {
        String methodName = method.getName();
        JClass[] paramTypes = method.getParameterTypes();
        if (!(method.isAbstract() && methodName.startsWith("get") && paramTypes.length == 0 || method.isAbstract() && methodName.startsWith("get") && paramTypes.length == 1 || method.isAbstract() && methodName.startsWith("set") && paramTypes.length == 1 || methodName.startsWith("ejb") || !method.isAbstract())) {
            throw this.error(L.l("{0}: '{1}' must not be abstract.  The bean must implement its business methods.", (Object)this.getEJBClass().getName(), method.getFullName()));
        }
    }

    private void validateSelectMethod(JMethod method) throws ConfigException {
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public. ejbSelect methods must be public.", (Object)this.getEJBClass().getName(), method.getFullName()));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static. ejbSelect methods must not be static.", (Object)this.getEJBClass().getName(), method.getFullName()));
        }
        if (!method.isAbstract()) {
            throw this.error(L.l("{0}: `{1}' must be abstract. ejbSelect methods must be abstract.", (Object)this.getEJBClass().getName(), method.getFullName()));
        }
    }

    @Override
    protected EjbHomeView createHomeView(JClass homeClass, String prefix) throws ConfigException {
        return new EjbEntityHomeView(this, homeClass, prefix);
    }

    @Override
    protected EjbObjectView createObjectView(JClass apiClass, String prefix) throws ConfigException {
        if (this.isCMP()) {
            return new EjbCmpView(this, apiClass, prefix);
        }
        return new EjbEntityView(this, apiClass, prefix);
    }

    @Override
    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        EntityServer server = new EntityServer(ejbManager);
        server.setEJBName(this.getEJBName());
        server.setJndiName(this.getJndiName());
        server.setRemoteHomeClass(this.getRemoteHomeClass());
        server.setRemoteObjectClass(this.getRemoteClass());
        Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
        server.setContextImplClass(contextImplClass);
        server.setCMP(this.isCMP());
        if (this._primKeyClass != null) {
            server.setPrimaryKeyClass(this._primKeyClass.getWrappedClass());
        }
        server.setLoadLazyOnTransaction(this._loadLazyOnTransaction);
        server.setInitProgram(this.getInitProgram());
        if (this.isCMP()) {
            server.setAmberEntityHome(this.getEntityType().getHome());
        }
        return server;
    }

    private void validateMethods() throws ConfigException {
        JMethod[] methods;
        JClass primKeyClass = this.getPrimKeyClass();
        for (JMethod method : methods = EjbEntityBean.getMethods(this.getEJBClassWrapper())) {
            String name = method.getName();
            try {
                JMethod cleanMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
                if (cleanMethod != null) {
                    method = cleanMethod;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (method.getReturnType().isAssignableTo(EjbEntityBean._resin_compat_class_0())) {
                throw this.error(L.l("{0}: `{1}' must not return entity bean `{2}'.  Entity bean methods must always return local or remote interfaces.", this.getEJBClass().getName(), method.getFullName(), method.getReturnType().getShortName()));
            }
            if (name.startsWith("ejbFind")) {
                if (!this.isCMP()) {
                    this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                    continue;
                }
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.startsWith("ejbSelect")) {
                if (!method.isAbstract()) {
                    throw this.error(L.l("{0}: `{1}' must be abstract. ejbSelect methods must be abstract.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
                }
                if (!method.isPublic()) {
                    throw this.error(L.l("{0}: `{1}' must be public.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
                }
                this.validateException(method, EjbEntityBean._resin_compat_class_6());
                continue;
            }
            if (name.startsWith("ejbCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (!this.isPrimaryKeyClass(method.getReturnType())) {
                    throw this.error(L.l("{0}: `{1}' must return `{2}'.  ejbCreate methods must return the primary key.", method.getDeclaringClass().getName(), method.getFullName(), EjbEntityBean.getClassName(primKeyClass)));
                }
                if (!this.isCMP()) continue;
                this.validateException(method, EjbEntityBean._resin_compat_class_7());
                continue;
            }
            if (name.startsWith("ejbPostCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (method.getReturnType().getName().equals("void")) continue;
                throw this.error(L.l("{0}: `{1}' must return void. ejbPostCreate methods must return void.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
            }
            if (name.startsWith("create") && method.isAbstract()) continue;
            if (name.startsWith("ejbHome")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.equals("ejbRemove")) {
                if (method.getParameterTypes().length == 0) continue;
                throw this.error(L.l("{0}: `{1}' must have no arguments.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
            }
            if (name.equals("ejbTimeout")) {
                JClass[] types = method.getParameterTypes();
                if (types.length == 1 && types[0].getName().equals("javax.ejb.Timer")) continue;
                throw this.error(L.l("{0}: `{1}' must have one javax.ejb.Timer argument.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
            }
            if (this.classHasMethod(method, JClassLoader.systemForName(EjbEntityBean._resin_compat_class_0().getName()))) continue;
            if (name.equals("finalize") && method.getParameterTypes().length == 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw this.error(L.l("{0}: Entity beans must not define `finalize'.", this.getEJBClass().getClass()));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: `{1}' must not start with `ejb'.  ejbXXX methods are reserved by the EJB spec.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
            }
            boolean isAbstract = method.isAbstract();
            Object persist = null;
            if (!isAbstract || !this.isCMP() || method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("ejbSelect")) continue;
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Only CMP methods may be abstract.", (Object)method.getDeclaringClass().getName(), method.getFullName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateHome(JClass homeClass) throws ConfigException {
        JClass beanClass = this.getEJBClassWrapper();
        String beanName = beanClass.getName();
        String homeName = homeClass.getName();
        JClass objectClass = homeClass.isAssignableTo(EjbEntityBean._resin_compat_class_8()) ? this.getRemote() : this.getLocal();
        String objectName = objectClass != null ? objectClass.getName() : null;
        boolean hasFindByPrimaryKey = false;
        JClass primKeyClass = this.getPrimKeyClass();
        if (!homeClass.isPublic()) {
            throw this.error(L.l("`{0}' must be public. Entity beans must be public.", homeName));
        }
        if (beanClass.isFinal()) {
            throw this.error(L.l("`{0}' must not be final.  Entity beans must not be final.", beanName));
        }
        if (!this.isCMP() && beanClass.isAbstract()) {
            throw this.error(L.l("`{0}' must not be abstract. BMP entity beans must not be abstract.", beanName));
        }
        if (!homeClass.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface.", homeName));
        }
        JMethod[] methods = EjbEntityBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            JMethod implMethod;
            JMethod method = methods[i];
            String name = method.getName();
            JClass[] param = method.getParameterTypes();
            JClass retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(EjbEntityBean._resin_compat_class_8()) || method.getDeclaringClass().isAssignableFrom(EjbEntityBean._resin_compat_class_9())) continue;
            if (homeClass.isAssignableTo(EjbEntityBean._resin_compat_class_8())) {
                this.validateException(method, EjbEntityBean._resin_compat_class_10());
            }
            if (name.startsWith("create")) {
                this.validateException(method, EjbEntityBean._resin_compat_class_7());
                if (!retType.equals(objectClass)) {
                    throw this.error(L.l("{0}: `{1}' must return {2}.  Create methods must return the local or remote interface.", homeName, method.getFullName(), objectName));
                }
                String createName = new CharBuffer().append("ejbC").append(name.substring(1)).toString();
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!this.isPrimaryKeyClass(implMethod.getReturnType())) {
                    throw this.error(L.l("{0}: `{1}' must return `{2}'.  ejbCreate methods must return the primary key.", beanName, EjbEntityBean.getFullMethodName(createName, param), EjbEntityBean.getClassName(primKeyClass)));
                }
                if (!this.hasException(implMethod, EjbEntityBean._resin_compat_class_7())) {
                    throw this.error(L.l("{0}: `{1}' must throw {2}.  ejbCreate methods must throw CreateException.", implMethod.getDeclaringClass().getName(), implMethod.getFullName(), "CreateException"));
                }
                this.validateExceptions(method, implMethod);
                createName = new CharBuffer().append("ejbPostC").append(name.substring(1)).toString();
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!implMethod.getReturnType().getName().equals("void")) {
                    throw this.error(L.l("{0}: `{1}' must return {2}. ejbPostCreate methods must return void.", beanName, EjbEntityBean.getFullMethodName(createName, param), "void"));
                }
                this.validateExceptions(method, implMethod);
                continue;
            }
            if (name.startsWith("find")) {
                String query;
                if (name.equals("findByPrimaryKey")) {
                    hasFindByPrimaryKey = true;
                    if (!objectClass.equals(method.getReturnType())) {
                        throw this.error(L.l("{0}: `{1}' must return `{2}'.  Find methods must return the remote or local interface.", homeName, method.getFullName(), objectName));
                    }
                }
                String findName = new CharBuffer().append("ejbF").append(name.substring(1)).toString();
                if (!this.isCMP() && !this.isCMP1() || EjbEntityBean.getMethod(beanClass, findName, param) != null) {
                    JMethod impl = this.validateNonFinalMethod(findName, param, this.isAllowPOJO());
                    if (impl != null) {
                        this.validateExceptions(method, impl);
                    }
                    if (objectClass.equals(method.getReturnType())) {
                        if (impl != null && !this.isPrimaryKeyClass(impl.getReturnType())) {
                            throw this.error(L.l("{0}: `{1}' must return primary key `{2}'.  ejbFind methods must return the primary key", beanName, impl.getFullName(), EjbEntityBean.getClassName(primKeyClass)));
                        }
                    } else if (method.getReturnType().isAssignableTo(EjbEntityBean._resin_compat_class_2())) {
                        if (impl != null && !impl.getReturnType().isAssignableTo(EjbEntityBean._resin_compat_class_2())) {
                            throw this.error(L.l("{0}: `{1}' must return collection.", (Object)beanName, impl.getFullName()));
                        }
                    } else {
                        if (!method.getReturnType().isAssignableTo(EjbEntityBean._resin_compat_class_11())) throw this.error(L.l("{0}: `{1}' must return `{2}' or a collection. ejbFind methods must return the primary key or a collection.", homeName, method.getFullName(), objectName));
                        if (!impl.getReturnType().isAssignableTo(EjbEntityBean._resin_compat_class_11())) {
                            throw this.error(L.l("{0}: `{1}' must return enumeration.", (Object)beanName, impl.getFullName()));
                        }
                    }
                } else if (this.isCMP() && !name.equals("findByPrimaryKey") && (query = this.findQuery(method)) == null) {
                    throw this.error(L.l("{0}: `{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)homeName, method.getFullName()));
                }
                this.validateException(method, EjbEntityBean._resin_compat_class_6());
                if (retType.equals(objectClass) || (retType.isAssignableTo(EjbEntityBean._resin_compat_class_2()) || EjbEntityBean._resin_compat_class_11().getName().equals(retType.getName())) && !name.equals("findByPrimaryKey")) continue;
                throw this.error(L.l("{0}: `{1}' must return {2} or a collection. ejbFind methods must return the primary key or a collection.", homeName, method.getFullName(), objectName));
            }
            if (name.startsWith("ejbSelect")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  ejbSelect methods may not be exposed in the remote or local interface.", (Object)homeName, method.getFullName()));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  Only ejbXXX methods defined by the spec are allowed.", (Object)homeName, method.getFullName()));
            }
            if (name.startsWith("remove")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  removeXXX methods are reserved by the spec.", (Object)homeName, method.getFullName()));
            }
            retType = method.getReturnType();
            if (homeClass.isAssignableTo(EjbEntityBean._resin_compat_class_8()) && (retType.isAssignableTo(EjbEntityBean._resin_compat_class_3()) || retType.isAssignableTo(EjbEntityBean._resin_compat_class_9()))) {
                throw this.error(L.l("{1}: `{0}' must not return local interface.", (Object)homeClass.getName(), method.getFullName()));
            }
            String homeMethodName = new CharBuffer().append("ejbHome").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
            implMethod = this.validateMethod(homeMethodName, param, method, homeClass);
            if (!retType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: `{1}' must return {2}.", beanName, implMethod.getFullName(), method.getReturnType().getName()));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
        if (hasFindByPrimaryKey || this.isAllowPOJO() || objectClass == null) return;
        throw this.error(L.l("{0}: expected `{1}'. All entity homes must define findByPrimaryKey.", (Object)homeName, EjbEntityBean.getFullMethodName("findByPrimaryKey", new JClass[]{primKeyClass})));
    }

    @Override
    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, JClass homeClass, String prefix) throws NoSuchMethodException {
        JMethod[] methods = EjbEntityBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            String name;
            JMethod beanMethod;
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            if (className.startsWith("javax.ejb.") || EjbEntityBean.isOld(methods, methods[i], i)) continue;
            if (methodName.startsWith("create")) {
                this.assembleCreateMethod(methods[i], baseClass, contextClassName, prefix);
                continue;
            }
            if (methodName.startsWith("find")) {
                beanMethod = null;
                name = new CharBuffer().append("ejb").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
                try {
                    beanMethod = this.getEJBClassWrapper().getMethod(name, methods[i].getParameterTypes());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (beanMethod == null) continue;
                EntityFindMethod findMethod = new EntityFindMethod(methods[i], beanMethod, contextClassName, prefix);
                CallChain call = findMethod.getCall();
                call = new EntityHomePoolChain(call);
                findMethod.setCall(call);
                baseClass.addMethod(findMethod);
                continue;
            }
            beanMethod = null;
            name = new CharBuffer().append("ejbHome").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
            try {
                beanMethod = this.getEJBClassWrapper().getMethod(name, methods[i].getParameterTypes());
            }
            catch (Exception e) {
                throw new NoSuchMethodException(new CharBuffer().append("can't find method ").append(name).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = this.getTransactionChain(call, beanMethod, prefix);
            baseClass.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected void assembleCreateMethod(JMethod method, BaseClass baseClass, String contextClassName, String prefix) {
        String methodName = method.getName();
        JMethod beanCreateMethod = null;
        JMethod beanPostCreateMethod = null;
        String name = new CharBuffer().append("ejb").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
        try {
            beanCreateMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (beanCreateMethod == null) {
            throw new IllegalStateException(name);
        }
        name = new CharBuffer().append("ejbPost").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
        try {
            beanPostCreateMethod = this.getEJBClassWrapper().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        EntityCreateMethod createMethod = new EntityCreateMethod(this, method, beanCreateMethod, beanPostCreateMethod, contextClassName);
        createMethod.setCall(this.getTransactionChain(createMethod.getCall(), method, prefix));
        baseClass.addMethod(createMethod);
    }

    private boolean isPrimaryKeyClass(JClass type) {
        return type.equals(this.getPrimKeyClass());
    }

    private JMethod getMethodField(String fieldName) {
        String getter = new CharBuffer().append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
        JMethod[] methods = EjbEntityBean.getMethods(this.getEJBClassWrapper());
        for (int i = 0; i < methods.length; ++i) {
            if (!getter.equals(methods[i].getName()) || methods[i].getParameterTypes().length != 0) continue;
            return methods[i];
        }
        return null;
    }

    private String findQuery(JMethod method) throws ConfigException {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, null);
        if (ejbMethod != null && ejbMethod.getQuery() != null) {
            return ejbMethod.getQuery();
        }
        EjbMethodPattern ejbQuery = this.getQuery(method, null);
        if (ejbQuery != null) {
            return ejbQuery.getQuery();
        }
        return null;
    }

    public boolean dependsOn(EjbEntityBean target) {
        for (CmrRelation rel : this._relations) {
            EjbEntityBean targetBean;
            if (!rel.isId() || target != (targetBean = rel.getTargetBean()) && (targetBean == null || !targetBean.dependsOn(target))) continue;
            return true;
        }
        return false;
    }

    public void generateBeanPrologue(JavaWriter out) throws IOException {
    }

    public void generateAfterCommit(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateAfterCommit(out);
        }
    }

    public void generateDestroy(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateDestroy(out);
        }
    }

    public String toString() {
        return new CharBuffer().append("EjbEntityBean[").append(this.getEJBName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.ejb.EntityBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.EntityContext");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.util.Collection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("javax.ejb.FinderException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("javax.ejb.CreateException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("javax.ejb.EJBLocalHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("java.rmi.RemoteException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("java.util.Enumeration");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("com.caucho.ejb.cfg.EjbEntityBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

