/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.CmpRelation;
import com.caucho.ejb.cfg.CmpRelationRole;
import com.caucho.ejb.cfg.CmrManyToMany;
import com.caucho.ejb.cfg.CmrManyToOne;
import com.caucho.ejb.cfg.CmrMap;
import com.caucho.ejb.cfg.CmrOneToMany;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbJar;
import com.caucho.ejb.cfg.FunctionSignature;
import com.caucho.ejb.ql.FunExpr;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbConfig {
    private static final L10N L = new L10N(EjbConfig._resin_compat_class_2());
    private static final Logger log = Log.open(EjbConfig._resin_compat_class_2());
    private EjbServerManager _ejbManager;
    private ArrayList<FileSetType> _fileSetList = new ArrayList();
    private ArrayList<Path> _pathList = new ArrayList();
    private HashMap<String, EjbBean> _cfgBeans = new HashMap();
    private ArrayList<CmpRelation> _relations = new ArrayList();
    private ArrayList<EjbBean> _pendingBeans = new ArrayList();
    private ArrayList<EjbBean> _deployingBeans = new ArrayList();
    private ArrayList<FunctionSignature> _functions = new ArrayList();
    private String _booleanTrue = "1";
    private String _booleanFalse = "0";
    private boolean _isAllowPOJO;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public EjbConfig(EjbServerManager ejbManager) {
        this._ejbManager = ejbManager;
        this._functions.addAll(FunExpr.getStandardFunctions());
    }

    public void addFileSet(FileSetType fileSet) {
        if (this._fileSetList.contains(fileSet)) {
            return;
        }
        this._fileSetList.add(fileSet);
    }

    public void addEJBPath(Path path) throws ConfigException {
        if (this._pathList.contains(path)) {
            return;
        }
        this._pathList.add(path);
        if (path.getScheme().equals("jar")) {
            path.setUserPath(path.getURL());
        }
        Environment.addDependency(path);
        EjbJar ejbJar = new EjbJar(this);
        try {
            new Config().configure((Object)ejbJar, path, this.getSchema());
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public String getSchema() {
        return "com/caucho/ejb/cfg/resin-ejb.rnc";
    }

    public EjbServerManager getEJBManager() {
        return this._ejbManager;
    }

    public void setBooleanTrue(String trueLiteral) {
        this._booleanTrue = trueLiteral;
    }

    public String getBooleanTrue() {
        return this._booleanTrue;
    }

    public void setBooleanFalse(String falseLiteral) {
        this._booleanFalse = falseLiteral;
    }

    public String getBooleanFalse() {
        return this._booleanFalse;
    }

    public EjbBean getBeanConfig(String name) {
        return this._cfgBeans.get(name);
    }

    public void setBeanConfig(String name, EjbBean bean) {
        if (name == null || bean == null) {
            throw new NullPointerException();
        }
        if (this._cfgBeans.get(name) == null) {
            this._pendingBeans.add(bean);
        }
        this._cfgBeans.put(name, bean);
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public EjbEntityBean findEntityBySchema(String schemaName) {
        for (EjbBean bean : this._cfgBeans.values()) {
            EjbEntityBean entity;
            if (!(bean instanceof EjbEntityBean) || !schemaName.equals((entity = (EjbEntityBean)bean).getAbstractSchemaName())) continue;
            return entity;
        }
        return null;
    }

    public EjbEntityBean findEntityByLocal(JClass cl) {
        for (EjbBean bean : this._cfgBeans.values()) {
            EjbEntityBean entity;
            if (!(bean instanceof EjbEntityBean) || !cl.equals((entity = (EjbEntityBean)bean).getLocal())) continue;
            return entity;
        }
        return null;
    }

    public CmpRelation addRelation(String relationName, String sourceEJB, String sourceField) {
        CmpRelation relation = this.findRelation(relationName, sourceEJB, sourceField);
        if (relation != null) {
            return relation;
        }
        relation = new CmpRelation();
        relation.setName(relationName);
        relation.setSourceEJB(sourceEJB);
        relation.setSourceField(sourceField);
        this._relations.add(relation);
        return relation;
    }

    public CmpRelation findRelation(String relationName, String sourceEJB, String sourceField) {
        for (int i = 0; i < this._relations.size(); ++i) {
            CmpRelation relation = this._relations.get(i);
            if (relationName != null && relationName.equals(relation.getName())) {
                return relation;
            }
            if (!relation.getSourceEJB().equals(sourceEJB) || !relation.getSourceField().equals(sourceField)) continue;
            return relation;
        }
        return null;
    }

    public void addRelation(CmpRelation rel) throws ConfigException {
        CmpRelation oldRel = this.findRelation(rel.getName(), rel.getSourceEJB(), rel.getSourceField());
        if (oldRel == null) {
            this._relations.add(rel);
            return;
        }
        if (!rel.getTargetEJB().equals(oldRel.getTargetEJB())) {
            throw new ConfigException(L.l("relationship '{0}.{1}' target EJB '{2}' does not match old target EJB '{3}' from {4}", rel.getSourceEJB(), rel.getSourceField(), rel.getTargetEJB(), oldRel.getTargetEJB(), oldRel.getLocation()));
        }
        if (!(rel.getTargetField() == oldRel.getTargetField() || rel.getTargetField() != null && rel.getTargetField().equals(oldRel.getTargetField()))) {
            throw new ConfigException(L.l("relationship '{0}.{1}' target field '{2}' does not match old target field '{3}' from {4}", rel.getSourceEJB(), rel.getSourceField(), rel.getTargetEJB(), oldRel.getTargetEJB(), oldRel.getLocation()));
        }
        oldRel.merge(rel);
    }

    public CmpRelation[] getRelations() {
        return this._relations.toArray(new CmpRelation[this._relations.size()]);
    }

    public void addFunction(FunctionSignature sig, String sql) {
        this._functions.add(sig);
    }

    public ArrayList<FunctionSignature> getFunctions() {
        return this._functions;
    }

    public void configure() throws ConfigException {
        this.findConfigurationFiles();
        try {
            ArrayList<EjbBean> beanConfig = new ArrayList<EjbBean>(this._pendingBeans);
            this._pendingBeans.clear();
            this._deployingBeans.addAll(beanConfig);
            EnvironmentClassLoader parentLoader = this._ejbManager.getClassLoader();
            Path workPath = this._ejbManager.getWorkPath();
            JavaClassGenerator javaGen = new JavaClassGenerator();
            javaGen.setWorkDir(workPath);
            javaGen.setParentLoader(parentLoader);
            this.configureRelations();
            for (EjbBean bean : beanConfig) {
                bean.init();
            }
            Collections.sort(beanConfig, new BeanComparator());
            AmberConfig amberConfig = new AmberConfig(this);
            for (EjbBean bean : beanConfig) {
                bean.configureAmber(amberConfig);
            }
            amberConfig.configureRelations();
            if (this._ejbManager.isAutoCompile()) {
                amberConfig.generate(javaGen);
            }
            for (EjbBean bean : beanConfig) {
                bean.generate(javaGen, this._ejbManager.isAutoCompile());
            }
            javaGen.compilePendingJava();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private void findConfigurationFiles() throws ConfigException {
        for (FileSetType fileSet : this._fileSetList) {
            for (Path path : fileSet.getPaths()) {
                this.addEJBPath(path);
            }
        }
    }

    public void deploy() throws ConfigException {
        try {
            EnvironmentClassLoader parentLoader = this._ejbManager.getClassLoader();
            Path workPath = this._ejbManager.getWorkPath();
            if (workPath == null) {
                workPath = WorkDir.getLocalWorkDir();
            }
            JavaClassGenerator javaGen = new JavaClassGenerator();
            javaGen.setWorkDir(workPath);
            javaGen.setParentLoader(parentLoader);
            this.deployBeans(this._deployingBeans, javaGen);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployBeans(ArrayList<EjbBean> beanConfig, JavaClassGenerator javaGen) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._ejbManager.getClassLoader());
            this._ejbManager.getAmberManager().initEntityHomes();
            for (EjbBean bean : beanConfig) {
                thread.setContextClassLoader(this._ejbManager.getClassLoader());
                AbstractServer server = bean.deployServer(this._ejbManager, javaGen);
                thread.setContextClassLoader(server.getClassLoader());
                if (bean.getServerProgram() != null) {
                    bean.getServerProgram().configure(server);
                }
                server.init();
                this._ejbManager.addServer(server);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void configureRelations() throws ConfigException {
        for (CmpRelation relation : this._relations) {
            try {
                CmrRelation dstRel;
                CmrRelation dstRel2;
                CmrRelation srcRel;
                CmpRelationRole sourceRole = relation.getSourceRole();
                CmpRelationRole targetRole = relation.getTargetRole();
                String sourceEJB = sourceRole.getEJBName();
                EjbEntityBean sourceEntity = (EjbEntityBean)this._cfgBeans.get(sourceEJB);
                if (sourceEntity == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown EJB bean.", sourceEJB));
                }
                String sourceField = sourceRole.getFieldName();
                JMethod sourceMethod = sourceEntity.getFieldGetter(sourceField);
                JMethod sourceMapMethod = null;
                if (sourceField != null) {
                    sourceMapMethod = this.getMapMethod(sourceEntity, sourceField);
                }
                if (sourceField != null && sourceMethod == null && sourceMapMethod == null) {
                    throw new ConfigException(L.l("{0}: relation field '{1}' does not have a corresponding getter method.  cmr-relations must define abstract getter methods returning a local interface.", (Object)sourceEntity.getEJBClass().getName(), sourceField));
                }
                String targetEJB = targetRole.getEJBName();
                EjbEntityBean targetEntity = (EjbEntityBean)this._cfgBeans.get(targetEJB);
                if (targetEntity == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown EJB bean.", targetEJB));
                }
                String targetField = targetRole.getFieldName();
                JMethod targetMethod = targetEntity.getFieldGetter(targetField);
                JMethod targetMapMethod = null;
                if (targetField != null) {
                    targetMapMethod = this.getMapMethod(targetEntity, targetField);
                }
                if (targetField != null && targetMethod == null && targetMapMethod == null) {
                    throw new ConfigException(L.l("{0}: relation field '{1}' does not have a corresponding getter method.  cmr-relations must define abstract getter methods returning a local interface.", (Object)targetEntity.getEJBClass().getName(), targetField));
                }
                boolean sourceOneToMany = false;
                boolean sourceManyToOne = false;
                boolean sourceMap = false;
                if (sourceMethod != null) {
                    if (sourceMethod.getReturnType().isAssignableTo(EjbConfig._resin_compat_class_0())) {
                        sourceOneToMany = true;
                    } else if (sourceMethod.getReturnType().isAssignableTo(EjbConfig._resin_compat_class_1())) {
                        sourceMap = true;
                    } else {
                        sourceManyToOne = true;
                    }
                }
                boolean targetOneToMany = false;
                boolean targetManyToOne = false;
                boolean targetMap = false;
                if (targetMapMethod != null) {
                    targetMap = true;
                }
                if (targetMethod != null) {
                    if (targetMethod.getReturnType().isAssignableTo(EjbConfig._resin_compat_class_0())) {
                        targetOneToMany = true;
                    } else if (targetMethod.getReturnType().isAssignableTo(EjbConfig._resin_compat_class_1())) {
                        targetMap = true;
                    } else {
                        targetManyToOne = true;
                    }
                }
                if (sourceMap) {
                    this.createMap(targetEntity, targetField, targetRole, sourceEntity, sourceField, sourceRole, sourceMapMethod);
                    continue;
                }
                if (targetMap) {
                    this.createMap(sourceEntity, sourceField, sourceRole, targetEntity, targetField, targetRole, targetMapMethod);
                    continue;
                }
                if (sourceOneToMany && targetManyToOne) {
                    srcRel = new CmrOneToMany(sourceEntity, sourceField, targetEntity, targetField);
                    ((CmrOneToMany)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrOneToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    ((CmrManyToOne)dstRel2).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToOne)dstRel2).setSourceCascadeDelete(targetRole.getCascadeDelete());
                    ((CmrManyToOne)dstRel2).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    targetEntity.addRelation(dstRel2);
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    continue;
                }
                if (sourceOneToMany && targetOneToMany) {
                    srcRel = new CmrManyToMany(sourceEntity, sourceField, targetEntity, targetField);
                    srcRel.setLocation(relation.getLocation());
                    srcRel.setRelationName(relation.getName());
                    ((CmrManyToMany)srcRel).setSQLTable(relation.getSQLTable());
                    ((CmrManyToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    ((CmrManyToMany)srcRel).setKeySQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setDstSQLColumns(targetRole.getSQLColumns());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToMany(targetEntity, targetField, sourceEntity, sourceField);
                    dstRel2.setLocation(relation.getLocation());
                    dstRel2.setRelationName(relation.getName());
                    ((CmrManyToMany)dstRel2).setSQLTable(relation.getSQLTable());
                    ((CmrManyToMany)dstRel2).setOrderBy(targetRole.getOrderBy());
                    ((CmrManyToMany)dstRel2).setKeySQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToMany)dstRel2).setDstSQLColumns(sourceRole.getSQLColumns());
                    targetEntity.addRelation(dstRel2);
                    continue;
                }
                if (sourceOneToMany) {
                    srcRel = new CmrManyToMany(sourceEntity, sourceField, targetEntity, targetField);
                    srcRel.setLocation(relation.getLocation());
                    if (relation.getName() != null) {
                        srcRel.setRelationName(relation.getName());
                    } else if (relation.getSQLTable() != null) {
                        srcRel.setRelationName(relation.getSQLTable());
                    } else {
                        srcRel.setRelationName(sourceField);
                    }
                    if (relation.getSQLTable() != null || relation.getName() != null) {
                        ((CmrManyToMany)srcRel).setSQLTable(relation.getSQLTable());
                    } else {
                        ((CmrManyToMany)srcRel).setSQLTable(sourceField);
                    }
                    ((CmrManyToMany)srcRel).setOrderBy(sourceRole.getOrderBy());
                    ((CmrManyToMany)srcRel).setKeySQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setDstSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToMany)srcRel).setTargetUnique("One".equals(sourceRole.getMultiplicity()));
                    sourceEntity.addRelation(srcRel);
                    continue;
                }
                if (sourceManyToOne && targetManyToOne) {
                    if (relation.getSQLTable() != null) {
                        throw new ConfigException(L.l("cmr-field '{0}' may not have a sql-table '{1}'.  one-to-one relations do not have association tables.", (Object)sourceField, relation.getSQLTable()));
                    }
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    srcRel.setLocation(relation.getLocation());
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                    ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    dstRel2.setLocation(relation.getLocation());
                    ((CmrManyToOne)dstRel2).setSQLColumns(targetRole.getSQLColumns());
                    targetEntity.addRelation(dstRel2);
                    if ((sourceRole.getSQLColumns() == null || sourceRole.getSQLColumns().length == 0) && targetRole.getSQLColumns() != null && targetRole.getSQLColumns().length > 0) {
                        ((CmrManyToOne)srcRel).setDependent(true);
                        ((CmrManyToOne)dstRel2).setSourceCascadeDelete(targetRole.getCascadeDelete());
                        ((CmrManyToOne)dstRel2).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    }
                    if (targetRole.getSQLColumns() == null || targetRole.getSQLColumns().length == 0) {
                        ((CmrManyToOne)dstRel2).setDependent(true);
                        ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                        ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    }
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    continue;
                }
                if (sourceManyToOne && targetOneToMany) {
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    srcRel.setLocation(relation.getLocation());
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    sourceEntity.addRelation(srcRel);
                    dstRel2 = new CmrOneToMany(targetEntity, targetField, sourceEntity, sourceField);
                    dstRel2.setLocation(relation.getLocation());
                    ((CmrOneToMany)dstRel2).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrOneToMany)dstRel2).setOrderBy(targetRole.getOrderBy());
                    targetEntity.addRelation(dstRel2);
                    srcRel.setTargetRelation(dstRel2);
                    dstRel2.setTargetRelation(srcRel);
                    if (!targetRole.getCascadeDelete() || !"Many".equals(sourceRole.getMultiplicity())) continue;
                    throw new ConfigException(L.l("'{0}' may not set cascade-delete because '{1}' has multiplicity 'Many'", (Object)targetField, sourceField));
                }
                if (sourceManyToOne) {
                    srcRel = new CmrManyToOne(sourceEntity, sourceField, targetEntity);
                    ((CmrManyToOne)srcRel).setSQLColumns(sourceRole.getSQLColumns());
                    ((CmrManyToOne)srcRel).setSourceCascadeDelete(sourceRole.getCascadeDelete());
                    ((CmrManyToOne)srcRel).setTargetCascadeDelete(targetRole.getCascadeDelete());
                    sourceEntity.addRelation(srcRel);
                    continue;
                }
                if (targetManyToOne) {
                    dstRel = new CmrManyToOne(targetEntity, targetField, sourceEntity);
                    ((CmrManyToOne)dstRel).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrManyToOne)dstRel).setSourceCascadeDelete(targetRole.getCascadeDelete());
                    ((CmrManyToOne)dstRel).setTargetCascadeDelete(sourceRole.getCascadeDelete());
                    targetEntity.addRelation(dstRel);
                    continue;
                }
                if (targetOneToMany) {
                    dstRel = new CmrOneToMany(targetEntity, targetField, sourceEntity, sourceField);
                    ((CmrOneToMany)dstRel).setSQLColumns(targetRole.getSQLColumns());
                    ((CmrOneToMany)dstRel).setOrderBy(targetRole.getOrderBy());
                    targetEntity.addRelation(dstRel);
                    continue;
                }
                throw new ConfigException(L.l("unsupported relation"));
            }
            catch (LineConfigException e) {
                throw e;
            }
            catch (ConfigException e) {
                throw new LineConfigException(new CharBuffer().append(relation.getLocation()).append(e.getMessage()).toString(), e);
            }
        }
    }

    private void createMap(EjbEntityBean sourceEntity, String idField, CmpRelationRole sourceRole, EjbEntityBean targetEntity, String targetField, CmpRelationRole targetRole, JMethod targetMapMethod) throws ConfigException {
        CmrManyToOne srcRel = new CmrManyToOne(sourceEntity, idField, targetEntity);
        srcRel.setSQLColumns(sourceRole.getSQLColumns());
        sourceEntity.addRelation(srcRel);
        CmrMap map = new CmrMap(targetEntity, targetField, sourceEntity, srcRel);
        map.setMapMethod(targetMapMethod);
        targetEntity.addRelation(map);
    }

    public JMethod getMapMethod(EjbEntityBean entityBean, String field) {
        String methodName = new CharBuffer().append("get").append(Character.toUpperCase(field.charAt(0))).append(field.substring(1)).toString();
        JMethod[] methods = EjbEntityBean.getMethods(entityBean.getEJBClassWrapper());
        for (int i = 0; i < methods.length; ++i) {
            JMethod method = methods[i];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1 || "void".equals(method.getReturnType().getName()) || !method.isAbstract()) continue;
            return method;
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.util.Collection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.util.Map");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.ejb.cfg.EjbConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class BeanComparator
    implements Comparator {
        BeanComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            EjbBean beanA = (EjbBean)a;
            EjbBean beanB = (EjbBean)b;
            if (!(a instanceof EjbEntityBean) && !(b instanceof EjbEntityBean)) {
                return beanA.getEJBName().compareTo(beanB.getEJBName());
            }
            if (!(a instanceof EjbEntityBean)) {
                return 1;
            }
            if (!(b instanceof EjbEntityBean)) {
                return -1;
            }
            EjbEntityBean entityB = (EjbEntityBean)b;
            EjbEntityBean entityA = (EjbEntityBean)a;
            if (entityB.dependsOn(entityA)) {
                return -1;
            }
            if (entityA.dependsOn(entityB)) {
                return 1;
            }
            return entityA.getEJBName().compareTo(entityB.getEJBName());
        }
    }
}

