/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassDependency;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JClassLoaderWrapper;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.bytecode.JMethod;
import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.EjbSecurityIdentity;
import com.caucho.ejb.cfg.EjbView;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.TransactionChain;
import com.caucho.ejb.gen.UserInRoleChain;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBean
implements EnvironmentBean,
DependencyBean {
    private static Logger log = Log.open(EjbBean._resin_compat_class_6());
    private static L10N L = new L10N(EjbBean._resin_compat_class_6());
    private static EnvironmentLocal<Map<JClass, SoftReference<JMethod[]>>> _methodCache = new EnvironmentLocal();
    private EjbConfig _ejbConfig;
    private ClassLoader _loader;
    protected JClassLoader _jClassLoader;
    private String _ejbName;
    private String _jndiName;
    private String _location = "";
    private JClass _ejbClass;
    protected JClass _remoteHome;
    protected JClass _remote;
    protected JClass _localHome;
    protected JClass _local;
    protected EjbView _remoteHomeView;
    protected EjbView _remoteView;
    protected EjbView _localHomeView;
    protected EjbView _localView;
    private boolean _isAllowPOJO;
    private boolean _isContainerTransaction = true;
    ArrayList<PersistentDependency> _dependList = new ArrayList();
    ArrayList<PersistentDependency> _configDependList = new ArrayList();
    ArrayList<String> _beanDependList = new ArrayList();
    ArrayList<EjbMethodPattern> _methodList = new ArrayList();
    private HashMap<String, EjbBaseMethod> _methodMap = new HashMap();
    private BuilderProgramContainer _initProgram;
    private BuilderProgramContainer _serverProgram;
    private long _transactionTimeout;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;

    public EjbBean(EjbConfig ejbConfig) {
        this._ejbConfig = ejbConfig;
        this._loader = Thread.currentThread().getContextClassLoader();
        this._jClassLoader = JClassLoaderWrapper.create(this._loader);
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = new CharBuffer().append(filename).append(":").append(line).append(": ").toString();
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void addDescription(String description) {
    }

    public void addDisplayName(String displayName) {
    }

    public void addIcon(String icon) {
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getEJBKind() {
        return "unknown";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        this.setEJBClassWrapper(new JClassWrapper(ejbClass, this._jClassLoader));
    }

    public void setEJBClassWrapper(JClass ejbClass) throws ConfigException {
        if (this._ejbClass != null && !this._ejbClass.getName().equals(ejbClass.getName())) {
            throw this.error(L.l("ejb-class '{0}' cannot be redefined.  Old value is '{1}'.", (Object)this._ejbClass.getName(), ejbClass.getName()));
        }
        this._ejbClass = ejbClass;
        if (!this._ejbClass.isPublic()) {
            throw this.error(L.l("`{0}' must be public.  Bean implementations must be public.", ejbClass.getName()));
        }
        if (this._ejbClass.isFinal()) {
            throw this.error(L.l("`{0}' must not be final.  Bean implementations must not be final.", ejbClass.getName()));
        }
        if (this._ejbClass.isInterface()) {
            throw this.error(L.l("`{0}' must not be an interface.  Bean implementations must be classes.", ejbClass.getName()));
        }
        JMethod constructor = null;
        try {
            constructor = ejbClass.getConstructor(new JClass[0]);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (constructor == null) {
            throw this.error(L.l("`{0}' needs a public zero-arg constructor.  Bean implementations need a public zero-argument constructor.", ejbClass.getName()));
        }
        JClass[] exn = constructor.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (exn[i].isAssignableTo(EjbBean._resin_compat_class_0())) continue;
            throw this.error(L.l("{0}: constructor must not throw `{1}'.  Bean constructors must not throw checked exceptions.", (Object)ejbClass.getName(), exn[i].getName()));
        }
        JMethod method = ejbClass.getMethod("finalize", new JClass[0]);
        if (method != null && !method.getDeclaringClass().equals(JClass.OBJECT)) {
            throw this.error(L.l("`{0}' may not implement finalize().  Bean implementations may not implement finalize().", ejbClass.getName()));
        }
    }

    public Class getEJBClass() {
        try {
            return Class.forName(this._ejbClass.getName(), false, this.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JClass getEJBClassWrapper() {
        return this._ejbClass;
    }

    public String getEJBFullClassName() {
        return this._ejbClass.getName();
    }

    public String getEJBClassName() {
        String s = this._ejbClass.getName();
        int p = s.lastIndexOf(46);
        if (p > 0) {
            return s.substring(p + 1);
        }
        return s;
    }

    public String getFullImplName() {
        return this.getEJBFullClassName();
    }

    public void setHome(Class home) throws ConfigException {
        this.setHomeWrapper(new JClassWrapper(home, this._jClassLoader));
    }

    public void setHomeWrapper(JClass remoteHome) throws ConfigException {
        this._remoteHome = remoteHome;
        if (!remoteHome.isPublic()) {
            throw this.error(L.l("`{0}' must be public.  <home> interfaces must be public.", remoteHome.getName()));
        }
        if (!remoteHome.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface. <home> interfaces must be interfaces.", remoteHome.getName()));
        }
        if (!remoteHome.isAssignableTo(EjbBean._resin_compat_class_1()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBHome.  <home> interfaces must extend javax.ejb.EJBHome.", remoteHome.getName()));
        }
    }

    public JClass getRemoteHome() {
        return this._remoteHome;
    }

    public Class getRemoteHomeClass() {
        if (this._remoteHome == null) {
            return null;
        }
        try {
            return Class.forName(this._remoteHome.getName(), false, this.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setRemote(Class remote) throws ConfigException {
        this.setRemoteWrapper(new JClassWrapper(remote, this._jClassLoader));
    }

    public void setRemoteWrapper(JClass remote) throws ConfigException {
        this._remote = remote;
        if (!this._remote.isPublic()) {
            throw this.error(L.l("`{0}' must be public.  <remote> interfaces must be public.", remote.getName()));
        }
        if (!this._remote.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface. <remote> interfaces must be interfaces.", remote.getName()));
        }
        if (!remote.isAssignableTo(EjbBean._resin_compat_class_2()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBObject.  <remote> interfaces must extend javax.ejb.EJBObject.", remote.getName()));
        }
    }

    public JClass getRemote() {
        return this._remote;
    }

    public Class getRemoteClass() {
        if (this._remote == null) {
            return null;
        }
        try {
            return Class.forName(this._remote.getName(), false, this.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocalHome(Class localHome) throws ConfigException {
        this.setLocalHomeWrapper(new JClassWrapper(localHome, this._jClassLoader));
    }

    public void setLocalHomeWrapper(JClass localHome) throws ConfigException {
        this._localHome = localHome;
        if (!localHome.isPublic()) {
            throw this.error(L.l("`{0}' must be public.  <local-home> interfaces must be public.", localHome.getName()));
        }
        if (!localHome.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface. <local-home> interfaces must be interfaces.", localHome.getName()));
        }
        if (!localHome.isAssignableTo(EjbBean._resin_compat_class_3()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBLocalHome.  <local-home> interfaces must extend javax.ejb.EJBLocalHome.", localHome.getName()));
        }
    }

    public JClass getLocalHome() {
        return this._localHome;
    }

    public void setLocal(Class local) throws ConfigException {
        this.setLocalWrapper(new JClassWrapper(local, this._jClassLoader));
    }

    public void setLocalWrapper(JClass local) throws ConfigException {
        this._local = local;
        if (!local.isPublic()) {
            throw this.error(L.l("`{0}' must be public.  <local> interfaces must be public.", local.getName()));
        }
        if (!local.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface. <local> interfaces must be interfaces.", local.getName()));
        }
        if (!local.isAssignableTo(EjbBean._resin_compat_class_4()) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBLocalObject.  <local> interfaces must extend javax.ejb.EJBLocalObject.", local.getName()));
        }
    }

    public JClass getLocal() {
        return this._local;
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public EjbMethodPattern createMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        EjbMethodPattern method = new EjbMethodPattern(this, sig);
        this._methodList.add(method);
        return method;
    }

    public void addMethod(EjbMethodPattern method) {
        this._methodList.add(method);
    }

    public EjbMethodPattern getMethodPattern(JMethod method, String intf) {
        EjbMethodPattern bestMethod = null;
        int bestCost = -1;
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern ejbMethod = this._methodList.get(i);
            MethodSignature sig = ejbMethod.getSignature();
            if (!sig.isMatch(method, intf) || bestCost >= sig.getCost()) continue;
            bestMethod = ejbMethod;
            bestCost = sig.getCost();
        }
        return bestMethod;
    }

    public ArrayList<EjbMethodPattern> getMethodList() {
        return this._methodList;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setSecurityIdentity(EjbSecurityIdentity securityIdentity) {
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; dependList != null && i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDepend(Path path) {
        this.addDependency(new Depend(path));
    }

    @Override
    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public ArrayList<PersistentDependency> getDependList() {
        return this._dependList;
    }

    public void addBeanDependency(String ejbName) {
        if (!this._beanDependList.contains(ejbName)) {
            this._beanDependList.add(ejbName);
        }
    }

    public ArrayList<String> getBeanDependList() {
        return this._beanDependList;
    }

    public void addInitProgram(BuilderProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new BuilderProgramContainer();
        }
        this._initProgram.addProgram(init);
    }

    public void addBuilderProgram(BuilderProgram init) {
        if (this._serverProgram == null) {
            this._serverProgram = new BuilderProgramContainer();
        }
        this._serverProgram.addProgram(init);
    }

    public BuilderProgramContainer getInitProgram() {
        return this._initProgram;
    }

    public BuilderProgramContainer getServerProgram() {
        return this._serverProgram;
    }

    public void init() throws ConfigException {
        try {
            this.introspect();
            this.assembleBeanMethods();
            this.createViews();
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(new CharBuffer().append(this._location).append(e.getMessage()).toString(), e);
        }
    }

    public void introspect() throws ConfigException {
    }

    public void configureAmber(AmberConfig config) throws ConfigException {
    }

    protected void createViews() throws ConfigException {
        if (this._remoteHome != null) {
            this._remoteHomeView = this.createHomeView(this._remoteHome, "RemoteHome");
            this._remoteHomeView.introspect();
        }
        if (this._remote != null) {
            this._remoteView = this.createObjectView(this._remote, "Remote");
            this._remoteView.introspect();
        }
        if (this._localHome != null) {
            this._localHomeView = this.createHomeView(this._localHome, "LocalHome");
            this._localHomeView.introspect();
        }
        if (this._local != null) {
            this._localView = this.createObjectView(this._local, "Local");
            this._localView.introspect();
        }
    }

    protected EjbHomeView createHomeView(JClass homeClass, String prefix) throws ConfigException {
        return new EjbHomeView(this, homeClass, prefix);
    }

    protected EjbObjectView createObjectView(JClass apiClass, String prefix) throws ConfigException {
        return new EjbObjectView(this, apiClass, prefix);
    }

    public void generate(JavaClassGenerator javaGen, boolean isAutoCompile) throws Exception {
        GenClass genClass;
        String fullClassName = this.getSkeletonName();
        if (javaGen.preload(fullClassName) == null && isAutoCompile && (genClass = this.assembleGenerator(fullClassName)) != null) {
            javaGen.generate(genClass);
        }
    }

    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException, ConfigException {
        throw new UnsupportedOperationException();
    }

    protected void validateRemote(JClass objectClass) throws ConfigException {
        JClass beanClass = this.getEJBClassWrapper();
        String beanName = beanClass.getName();
        String objectName = objectClass.getName();
        if (!objectClass.isPublic()) {
            throw this.error(L.l("`{0}' must be public", objectName));
        }
        if (!objectClass.isInterface()) {
            throw this.error(L.l("`{0}' must be an interface", objectName));
        }
        JMethod[] methods = EjbBean.getMethods(objectClass);
        for (int i = 0; i < methods.length; ++i) {
            JMethod method = methods[i];
            String name = method.getName();
            JClass[] param = method.getParameterTypes();
            JClass retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(EjbBean._resin_compat_class_2()) || method.getDeclaringClass().isAssignableFrom(EjbBean._resin_compat_class_4())) continue;
            if (objectClass.isAssignableTo(EjbBean._resin_compat_class_2())) {
                this.validateException(method, EjbBean._resin_compat_class_5());
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("`{0}' forbidden in {1}.  Local or remote interfaces may not define ejbXXX methods.", (Object)EjbBean.getFullMethodName(method), objectName));
            }
            JClass returnType = method.getReturnType();
            if (objectClass.isAssignableTo(EjbBean._resin_compat_class_2()) && (returnType.isAssignableTo(EjbBean._resin_compat_class_4()) || returnType.isAssignableTo(EjbBean._resin_compat_class_3()))) {
                throw this.error(L.l("`{0}' must not return `{1}' in {2}.  Remote methods must not return local interfaces.", EjbBean.getFullMethodName(method), EjbBean.getShortClassName(returnType), objectClass.getName()));
            }
            JMethod implMethod = this.validateRemoteImplMethod(method.getName(), param, method, objectClass);
            if (!returnType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: `{1}' must return {2} to match {3}.{4}.  Business methods must return the same type as the interface.", method.getDeclaringClass().getName(), EjbBean.getFullMethodName(method), implMethod.getReturnType().getName(), EjbBean.getShortClassName(implMethod.getDeclaringClass()), EjbBean.getFullMethodName(implMethod)));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
    }

    private JMethod validateRemoteImplMethod(String methodName, JClass[] param, JMethod sourceMethod, JClass sourceClass) throws ConfigException {
        JMethod method = null;
        JClass beanClass = this.getEJBClassWrapper();
        method = EjbBean.getMethod(beanClass, methodName, param);
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: `{1}' expected to match {2}.{3}", beanClass.getName(), EjbBean.getFullMethodName(methodName, param), EjbBean.getShortClassName(sourceMethod.getDeclaringClass()), EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: `{1}' expected", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: `{1}' must be public", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isFinal()) {
            throw this.error(L.l("{0}: `{1}' must not be final.", beanClass.getName(), EjbBean.getFullMethodName(methodName, param), beanClass.getName()));
        }
        return method;
    }

    JMethod validateNonFinalMethod(String methodName, JClass[] param, boolean isOptional) throws ConfigException {
        if (isOptional && EjbBean.getMethod(this._ejbClass, methodName, param) == null) {
            return null;
        }
        return this.validateNonFinalMethod(methodName, param);
    }

    JMethod validateNonFinalMethod(String methodName, JClass[] param) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, null, null);
    }

    JMethod validateNonFinalMethod(String methodName, JClass[] param, JMethod sourceMethod, JClass sourceClass) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    JMethod validateNonFinalMethod(String methodName, JClass[] param, JMethod sourceMethod, JClass sourceClass, boolean isOptional) throws ConfigException {
        JMethod method = this.validateMethod(methodName, param, sourceMethod, sourceClass, isOptional);
        if (method == null && isOptional) {
            return null;
        }
        if (method.isFinal()) {
            throw this.error(L.l("{0}: `{1}' must not be final", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    JMethod validateMethod(String methodName, JClass[] param) throws ConfigException {
        return this.validateMethod(methodName, param, null, null);
    }

    JMethod validateMethod(String methodName, JClass[] param, JMethod sourceMethod, JClass sourceClass) throws ConfigException {
        return this.validateMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    JMethod validateMethod(String methodName, JClass[] param, JMethod sourceMethod, JClass sourceClass, boolean isOptional) throws ConfigException {
        JMethod method = null;
        method = EjbBean.getMethod(this._ejbClass, methodName, param);
        if (method == null && isOptional) {
            return null;
        }
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: missing `{1}' needed to match {2}.{3}", this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param), EjbBean.getShortClassName(sourceClass), EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: expected `{1}'", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        JClass declaringClass = method.getDeclaringClass();
        if (method.isAbstract()) {
            if (method.getDeclaringClass().getName().equals("javax.ejb.EntityBean")) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  Entity beans must implement the methods in EntityBean.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
            }
            if (method.getDeclaringClass().getName().equals("javax.ejb.SessionBean")) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  Session beans must implement the methods in SessionBean.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
            }
            if (sourceMethod != null) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  All methods from `{2}' must be implemented in the bean.", this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param), sourceClass.getName()));
            }
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Business methods must be implemented.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: `{1}' must be public.  Business method implementations must be public.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static.  Business method implementations must not be static.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    protected String getSkeletonName() {
        String className = this.getEJBClass().getName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        String ejbName = this.getEJBName();
        String fullClassName = new CharBuffer().append("_ejb.").append(ejbName).append(".").append(className).append("__EJB").toString();
        return JavaClassGenerator.cleanClassName(fullClassName);
    }

    protected GenClass assembleGenerator(String fullClassName) throws NoSuchMethodException, ConfigException {
        BeanAssembler assembler;
        int p = fullClassName.lastIndexOf(46);
        String className = fullClassName;
        if (p > 0) {
            className = fullClassName.substring(p + 1);
        }
        if ((assembler = this.createAssembler(fullClassName)) == null) {
            return null;
        }
        this.addImports(assembler);
        assembler.addHeaderComponent(this.getEJBClassWrapper(), fullClassName, this.getFullImplName());
        this.assembleMethods(assembler, fullClassName);
        if (this._remoteHomeView != null) {
            this._remoteHomeView.assembleView(assembler, fullClassName);
        }
        if (this._remoteView != null) {
            this._remoteView.assembleView(assembler, fullClassName);
        }
        if (this._localHomeView != null) {
            this._localHomeView.assembleView(assembler, fullClassName);
        }
        if (this._localView != null) {
            this._localView.assembleView(assembler, fullClassName);
        }
        for (PersistentDependency depend : this._dependList) {
            assembler.addDependency(depend);
        }
        assembler.addDependency(new JClassDependency(this._ejbClass));
        if (this._remoteHome != null) {
            assembler.addDependency(new JClassDependency(this._remoteHome));
        }
        if (this._remote != null) {
            assembler.addDependency(new JClassDependency(this._remote));
        }
        if (this._localHome != null) {
            assembler.addDependency(new JClassDependency(this._localHome));
        }
        if (this._local != null) {
            assembler.addDependency(new JClassDependency(this._local));
        }
        return assembler.getAssembledGenerator();
    }

    protected void addImports(BeanAssembler assembler) {
        assembler.addImport("javax.ejb.*");
        assembler.addImport("com.caucho.vfs.*");
        assembler.addImport("com.caucho.ejb.xa.EjbTransactionManager");
        assembler.addImport("com.caucho.ejb.xa.TransactionContext");
        assembler.addImport("com.caucho.ejb.AbstractContext");
    }

    protected BeanAssembler createAssembler(String fullClassName) {
        return null;
    }

    protected void assembleBeanMethods() throws ConfigException {
        JMethod[] implMethods = EjbBean.getMethods(this.getEJBClassWrapper());
        for (int i = 0; i < implMethods.length; ++i) {
            JMethod method = implMethods[i];
            EjbBaseMethod ejbMethod = null;
            String name = method.getName();
            if (name.startsWith("ejb")) {
                ejbMethod = this.introspectEJBMethod(method);
                if (ejbMethod == null) continue;
                this._methodMap.put(ejbMethod.getMethod().getFullName(), ejbMethod);
                continue;
            }
            this.validateImplMethod(method);
        }
    }

    protected void assembleMethods(BeanAssembler assembler, String fullClassName) throws ConfigException {
        for (EjbBaseMethod method : this._methodMap.values()) {
            assembler.addMethod(method.assemble(assembler, fullClassName));
        }
    }

    protected EjbBaseMethod introspectEJBMethod(JMethod method) throws ConfigException {
        return null;
    }

    protected void validateImplMethod(JMethod method) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass view, String contextClassName, JMethod[] methods, String prefix) throws NoSuchMethodException {
        for (int i = 0; i < methods.length; ++i) {
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            JClass[] args = methods[i].getParameterTypes();
            if (className.startsWith("javax.ejb.") || EjbBean.isOld(methods, methods[i], i) || methodName.equals("equals") && args.length == 1 && args[0].equals(JClass.OBJECT) || methodName.equals("hashCode") && args.length == 0) continue;
            JMethod beanMethod = null;
            JClass ejbClass = this.getEJBClassWrapper();
            beanMethod = ejbClass.getMethod(methods[i].getName(), methods[i].getParameterTypes());
            if (beanMethod == null) {
                throw new NoSuchMethodException(new CharBuffer().append("Can't find public method ").append(methods[i].getFullName()).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = view.createPoolChain(call);
            call = this.getTransactionChain(call, beanMethod, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            view.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, JClass homeClass, String prefix) throws NoSuchMethodException {
        JMethod[] methods = EjbBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            String name;
            JMethod beanMethod;
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            if (className.startsWith("javax.ejb.") || EjbBean.isOld(methods, methods[i], i)) continue;
            if (methodName.startsWith("create")) {
                beanMethod = null;
                name = new CharBuffer().append("ejbCreate").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
                try {
                    beanMethod = this.getEJBClassWrapper().getMethod(name, methods[i].getParameterTypes());
                }
                catch (Throwable e) {}
                continue;
            }
            if (methodName.startsWith("find")) continue;
            beanMethod = null;
            name = new CharBuffer().append("ejbHome").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
            try {
                beanMethod = this.getEJBClassWrapper().getMethod(name, methods[i].getParameterTypes());
            }
            catch (Exception e) {
                throw new NoSuchMethodException(new CharBuffer().append("can't find method ").append(name).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = this.getTransactionChain(call, beanMethod, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            baseClass.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected CallChain getTransactionChain(CallChain next, JMethod method, String prefix) {
        return TransactionChain.create(next, this.getTransactionAttribute(method, prefix));
    }

    protected CallChain getSecurityChain(CallChain next, JMethod method, String prefix) {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, prefix);
        ArrayList roles = null;
        if (ejbMethod != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, prefix)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(method, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles != null) {
            return new UserInRoleChain(next, roles);
        }
        return next;
    }

    protected void validatePublicMethod(JMethod method) throws ConfigException {
        if (!method.isPublic()) {
            throw this.error(L.l("{0}: '{1}' must be public.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: `{1}' must not be static.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
    }

    static boolean isOld(JMethod[] methods, JMethod method, int index) {
        for (int i = 0; i < index; ++i) {
            if (!EjbBean.isEquiv(methods[i], method)) continue;
            return true;
        }
        return false;
    }

    static boolean isEquiv(JMethod oldMethod, JMethod method) {
        JClass[] param;
        if (!oldMethod.getName().equals(method.getName())) {
            return false;
        }
        JClass[] oldParam = oldMethod.getParameterTypes();
        if (oldParam.length != (param = method.getParameterTypes()).length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (param[j].equals(oldParam[j])) continue;
            return false;
        }
        return true;
    }

    public int getTransactionAttribute(JMethod method, String intf) {
        if (!this.isContainerTransaction()) {
            return 0;
        }
        int transaction = 3;
        EjbMethodPattern ejbMethod = this.getMethodPattern(null, null);
        if (ejbMethod != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, null)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, intf)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        return transaction;
    }

    JMethod getMethod(String methodName, JClass[] paramTypes) {
        return EjbBean.getMethod(this.getEJBClassWrapper(), methodName, paramTypes);
    }

    public static JMethod getMethod(JClass cl, JMethod sourceMethod) {
        return EjbBean.getMethod(cl, sourceMethod.getName(), sourceMethod.getParameterTypes());
    }

    public static JMethod getMethod(JClass cl, String name, JClass[] param) {
        if (cl == null) {
            return null;
        }
        JMethod[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!EjbBean.isMatch(methods[i], name, param)) continue;
            return methods[i];
        }
        JMethod method = EjbBean.getMethod(cl.getSuperClass(), name, param);
        if (method != null) {
            return method;
        }
        for (JClass iface : cl.getInterfaces()) {
            method = EjbBean.getMethod(iface, name, param);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    static boolean isMatch(JMethod methodA, JMethod methodB) {
        if (methodA == methodB) {
            return true;
        }
        if (methodA == null || methodB == null) {
            return false;
        }
        return EjbBean.isMatch(methodA, methodB.getName(), methodB.getParameterTypes());
    }

    static boolean isMatch(JMethod method, String name, JClass[] param) {
        if (!method.getName().equals(name)) {
            return false;
        }
        JClass[] mparam = method.getParameterTypes();
        if (mparam.length != param.length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (mparam[j].equals(param[j])) continue;
            return false;
        }
        return true;
    }

    static JMethod findMethod(MethodSignature sig, JClass cl, String intf) {
        if (cl == null) {
            return null;
        }
        JMethod[] methods = EjbBean.getMethods(cl);
        for (int i = 0; i < methods.length; ++i) {
            if (!sig.isMatch(methods[i], intf)) continue;
            return methods[i];
        }
        return null;
    }

    static JMethod[] getMethods(JClass cl) {
        Map<JClass, SoftReference<JMethod[]>> methodMap = _methodCache.get();
        if (methodMap == null) {
            methodMap = new WeakHashMap<JClass, SoftReference<JMethod[]>>();
            _methodCache.set(methodMap);
        }
        SoftReference<JMethod[]> methodArrayRef = methodMap.get(cl);
        JMethod[] methodArray = null;
        if (methodArrayRef != null && (methodArray = methodArrayRef.get()) != null) {
            return methodArray;
        }
        ArrayList<JMethod> methods = new ArrayList<JMethod>();
        EjbBean.getMethods(methods, cl);
        methodArray = methods.toArray(new JMethod[methods.size()]);
        methodMap.put(cl, new SoftReference<JMethod[]>(methodArray));
        return methodArray;
    }

    static void getMethods(ArrayList<JMethod> methods, JClass cl) {
        if (cl == null) {
            return;
        }
        JMethod[] subMethods = cl.getDeclaredMethods();
        for (int i = 0; i < subMethods.length; ++i) {
            if (EjbBean.findMethod(methods, subMethods[i]) != null) continue;
            methods.add(subMethods[i]);
        }
        EjbBean.getMethods(methods, cl.getSuperClass());
        JClass[] interfaces = cl.getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            EjbBean.getMethods(methods, interfaces[i]);
        }
    }

    static JMethod findMethod(ArrayList<JMethod> methods, JMethod method) {
        block0: for (int i = 0; i < methods.size(); ++i) {
            JClass[] bParamTypes;
            JClass[] aParamTypes;
            JMethod oldMethod = methods.get(i);
            if (!method.getName().equals(oldMethod.getName()) || (aParamTypes = oldMethod.getParameterTypes()).length != (bParamTypes = method.getParameterTypes()).length) continue;
            for (int j = 0; j < aParamTypes.length; ++j) {
                if (!aParamTypes[j].equals(bParamTypes[j])) continue block0;
            }
            return oldMethod;
        }
        return null;
    }

    static String getFullMethodName(JMethod method) {
        return EjbBean.getFullMethodName(method.getName(), method.getParameterTypes());
    }

    static String getFullMethodName(String methodName, JClass[] params) {
        String name = new CharBuffer().append(methodName).append("(").toString();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name = new CharBuffer().append(name).append(", ").toString();
            }
            name = new CharBuffer().append(name).append(EjbBean.getShortClassName(params[i])).toString();
        }
        return new CharBuffer().append(name).append(")").toString();
    }

    static String getClassName(JClass cl) {
        if (cl == null) {
            return "null";
        }
        if (cl.isArray()) {
            return new CharBuffer().append(EjbBean.getClassName(cl.getComponentType())).append("[]").toString();
        }
        if (cl.getName().startsWith("java")) {
            int p = cl.getName().lastIndexOf(46);
            return cl.getName().substring(p + 1);
        }
        return cl.getName();
    }

    static String getShortClassName(JClass cl) {
        if (cl.isArray()) {
            return new CharBuffer().append(EjbBean.getShortClassName(cl.getComponentType())).append("[]").toString();
        }
        int p = cl.getName().lastIndexOf(46);
        return cl.getName().substring(p + 1);
    }

    boolean classHasMethod(JMethod method, JClass cl) {
        try {
            JMethod match = cl.getMethod(method.getName(), method.getParameterTypes());
            return match != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    void validateException(JMethod method, Class e) throws ConfigException {
        this.validateException(method, new JClassWrapper(e, this._jClassLoader));
    }

    void validateException(JMethod method, JClass e) throws ConfigException {
        this.validateExceptions(method, new JClass[]{e});
    }

    void validateExceptions(JMethod method, JClass[] exn) throws ConfigException {
        JClass[] methodExceptions = method.getExceptionTypes();
        block0: for (int i = 0; i < exn.length; ++i) {
            if (exn[i].isAssignableTo(EjbBean._resin_compat_class_0())) continue;
            for (int j = 0; j < methodExceptions.length; ++j) {
                if (methodExceptions[j].isAssignableFrom(exn[i])) continue block0;
            }
            throw new ConfigException(L.l("{2}: `{0}' must throw {1}.", EjbBean.getFullMethodName(method), exn[i].getName(), method.getDeclaringClass().getName()));
        }
    }

    void validateExceptions(JMethod caller, JMethod callee) throws ConfigException {
        JClass[] exn = callee.getExceptionTypes();
        JClass missing = this.findMissingException(caller, exn);
        if (missing != null) {
            throw this.error(new CharBuffer().append(L.l("{0}: `{1}' must throw {2}.", caller.getDeclaringClass().getName(), EjbBean.getFullMethodName(caller), EjbBean.getShortClassName(missing), caller.getDeclaringClass().getName())).append(L.l(" {0} must throw all {1}.{2} exceptions.", caller.getName(), EjbBean.getShortClassName(callee.getDeclaringClass()), callee.getName())).toString());
        }
    }

    JClass findMissingException(JMethod method, JClass[] exn) throws ConfigException {
        JClass[] methodExceptions = method.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (this.hasException(method, exn[i]) || exn[i].isAssignableTo(EjbBean._resin_compat_class_0())) continue;
            return exn[i];
        }
        return null;
    }

    boolean hasException(JMethod method, JClass exn) throws ConfigException {
        JClass[] methodExceptions = method.getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    boolean hasException(JMethod method, Class exn) throws ConfigException {
        JClass[] methodExceptions = method.getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    public ConfigException error(String msg) {
        return new ConfigException(msg);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.RuntimeException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.ejb.EJBHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.ejb.EJBObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.ejb.EJBLocalHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.ejb.EJBLocalObject");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("java.rmi.RemoteException");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("com.caucho.ejb.cfg.EjbBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

