/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class ContainerTransaction {
    private static final L10N L = new L10N(ContainerTransaction._resin_compat_class_0());
    private EjbConfig _config;
    private String _location;
    private MethodSignature _method;
    private String _trans;
    private static Class _resin_compat_class_0;

    public ContainerTransaction(EjbConfig config) {
        this._config = config;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = new CharBuffer().append(filename).append(":").append(line).toString();
    }

    public void setDescription(String description) {
    }

    public void setMethod(MethodSignature method) {
        this._method = method;
    }

    public void setTransAttribute(String trans) throws ConfigException {
        if (!(trans.equals("Required") || trans.equals("RequiresNew") || trans.equals("Mandatory") || trans.equals("NotSupported") || trans.equals("Never") || trans.equals("Supports"))) {
            throw new ConfigException(L.l("`{0}' is an unknown transaction type.  The transaction types are:\n  Required - creates a new transaction if none is active.\n  RequiresNew - always creates a new transaction.\n  Mandatory - requires an active transaction.\n  NotSupported - suspends any active transaction.\n  Never - forbids any active transaction.\n  Supports - allows a transaction or no transaction.", trans));
        }
        this._trans = trans;
    }

    public void init() throws ConfigException {
        EjbBean bean = this._config.getBeanConfig(this._method.getEJBName());
        if (bean == null) {
            throw new ConfigException(L.l("`{0}' is an unknown entity bean.", this._method.getEJBName()));
        }
        EjbMethodPattern method = bean.createMethod(this._method);
        method.setTransAttribute(this._trans);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.ejb.cfg.ContainerTransaction");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

